/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.FishingOperations;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.type.CoordinateEditorType;
import fr.ifremer.tutti.ui.swing.content.operation.SecondaryVesselTypeEnum;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.util.Distances;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import jaxx.runtime.swing.editor.gis.DmdCoordinate;
import jaxx.runtime.swing.editor.gis.DmsCoordinate;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.util.DateUtil;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class EditFishingOperationUIModel
extends AbstractTuttiBeanUIModel<FishingOperation, EditFishingOperationUIModel>
implements AttachmentModelAware,
TabContentModel,
FishingOperation {
    private static final long serialVersionUID = 1L;
    public static final String TITLE = I18n.n((String)"tutti.editFishingOperation.tab.general", (Object[])new Object[0]);
    public static final String PROPERTY_PERSISTED = "persisted";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMS = "gearShootingStartLatitudeDms";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMS_SIGN = "gearShootingStartLatitudeDmsSign";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMS_DEGREE = "gearShootingStartLatitudeDmsDegree";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMS_MINUTE = "gearShootingStartLatitudeDmsMinute";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMS_SECOND = "gearShootingStartLatitudeDmsSecond";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMD = "gearShootingStartLatitudeDmd";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMD_SIGN = "gearShootingStartLatitudeDmdSign";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMD_DEGREE = "gearShootingStartLatitudeDmdDegree";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMD_MINUTE = "gearShootingStartLatitudeDmdMinute";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMD_DECIMAL = "gearShootingStartLatitudeDmdDecimal";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMS = "gearShootingStartLongitudeDms";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMS_SIGN = "gearShootingStartLongitudeDmsSign";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMS_DEGREE = "gearShootingStartLongitudeDmsDegree";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMS_MINUTE = "gearShootingStartLongitudeDmsMinute";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMS_SECOND = "gearShootingStartLongitudeDmsSecond";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMD = "gearShootingStartLongitudeDmd";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMD_SIGN = "gearShootingStartLongitudeDmdSign";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMD_DEGREE = "gearShootingStartLongitudeDmdDegree";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMD_MINUTE = "gearShootingStartLongitudeDmdMinute";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMD_DECIMAL = "gearShootingStartLongitudeDmdDecimal";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMS = "gearShootingEndLatitudeDms";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMS_SIGN = "gearShootingEndLatitudeDmsSign";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMS_DEGREE = "gearShootingEndLatitudeDmsDegree";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMS_MINUTE = "gearShootingEndLatitudeDmsMinute";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMS_SECOND = "gearShootingEndLatitudeDmsSecond";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMD = "gearShootingEndLatitudeDmd";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMD_SIGN = "gearShootingEndLatitudeDmdSign";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMD_DEGREE = "gearShootingEndLatitudeDmdDegree";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMD_MINUTE = "gearShootingEndLatitudeDmdMinute";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMD_DECIMAL = "gearShootingEndLatitudeDmdDecimal";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMS = "gearShootingEndLongitudeDms";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMS_SIGN = "gearShootingEndLongitudeDmsSign";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMS_DEGREE = "gearShootingEndLongitudeDmsDegree";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMS_MINUTE = "gearShootingEndLongitudeDmsMinute";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMS_SECOND = "gearShootingEndLongitudeDmsSecond";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMD = "gearShootingEndLongitudeDmd";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMD_SIGN = "gearShootingEndLongitudeDmdSign";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMD_DEGREE = "gearShootingEndLongitudeDmdDegree";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMD_MINUTE = "gearShootingEndLongitudeDmdMinute";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMD_DECIMAL = "gearShootingEndLongitudeDmdDecimal";
    public static final String PROPERTY_VALIDATION_CONTEXT = "validationContext";
    public static final String PROPERTY_SECONDARY_VESSEL_TYPE = "secondaryVesselType";
    public static final String PROPERTY_SECONDARY_VESSEL_TYPE_ALL = "secondaryVesselTypeAll";
    public static final String PROPERTY_SECONDARY_VESSEL_TYPE_SCIENTIFIC = "secondaryVesselTypeScientific";
    public static final String PROPERTY_SECONDARY_VESSEL_TYPE_FISHING = "secondaryVesselTypeFishing";
    public static final String PROPERTY_SECONDARY_VESSEL_TYPE_ONLY_CRUISE = "secondaryVesselTypeOnlyCruise";
    protected final FishingOperation editObject = FishingOperations.newFishingOperation();
    protected final DmsCoordinate gearShootingStartLatitudeDms = DmsCoordinate.empty();
    protected final DmsCoordinate gearShootingStartLongitudeDms = DmsCoordinate.empty();
    protected final DmsCoordinate gearShootingEndLatitudeDms = DmsCoordinate.empty();
    protected final DmsCoordinate gearShootingEndLongitudeDms = DmsCoordinate.empty();
    protected final DmdCoordinate gearShootingStartLatitudeDmd = DmdCoordinate.empty();
    protected final DmdCoordinate gearShootingStartLongitudeDmd = DmdCoordinate.empty();
    protected final DmdCoordinate gearShootingEndLatitudeDmd = DmdCoordinate.empty();
    protected final DmdCoordinate gearShootingEndLongitudeDmd = DmdCoordinate.empty();
    protected int quadrant;
    protected final List<Attachment> attachment = Lists.newArrayList();
    protected FishingOperation fishingOperation;
    protected String validationContext;
    protected CoordinateEditorType coordinateEditorType;
    protected boolean loadingData;
    protected SecondaryVesselTypeEnum secondaryVesselType;
    protected boolean importFromColumnFileEnabled;
    protected static Binder<EditFishingOperationUIModel, FishingOperation> toBeanBinder = BinderFactory.newBinder(EditFishingOperationUIModel.class, FishingOperation.class);
    protected static Binder<FishingOperation, EditFishingOperationUIModel> fromBeanBinder = BinderFactory.newBinder(FishingOperation.class, EditFishingOperationUIModel.class);
    List<Vessel> allSecondaryVessel;
    List<Vessel> onlyCruisSecondaryVessel;
    List<Vessel> scientificSecondaryVessel;
    List<Vessel> fishingSecondaryVessel;

    public int getQuadrant() {
        return this.quadrant;
    }

    public void setQuadrant(int quadrant) {
        Integer oldValue = this.getQuadrant();
        this.quadrant = quadrant;
        this.firePropertyChange("quadrant", oldValue, quadrant);
    }

    public EditFishingOperationUIModel() {
        super(fromBeanBinder, toBeanBinder);
    }

    public boolean isLoadingData() {
        return this.loadingData;
    }

    public void setLoadingData(boolean loadingData) {
        this.loadingData = loadingData;
    }

    public String getTitle() {
        return TITLE;
    }

    public String getIcon() {
        return null;
    }

    public boolean isCloseable() {
        return false;
    }

    public boolean isEmpty() {
        boolean result;
        switch (this.coordinateEditorType) {
            case DMS: {
                result = this.gearShootingStartLatitudeDms.isNull() && this.gearShootingStartLongitudeDms.isNull() && this.gearShootingEndLatitudeDms.isNull() && this.gearShootingEndLongitudeDms.isNull();
                break;
            }
            case DMD: {
                result = this.gearShootingStartLatitudeDmd.isNull() && this.gearShootingStartLongitudeDmd.isNull() && this.gearShootingEndLatitudeDmd.isNull() && this.gearShootingEndLongitudeDmd.isNull();
                break;
            }
            default: {
                result = this.getGearShootingStartLatitude() == null && this.getGearShootingStartLongitude() == null && this.getGearShootingEndLatitude() == null && this.getGearShootingEndLongitude() == null;
            }
        }
        return result && StringUtils.isEmpty((CharSequence)this.getStationNumber()) && this.getFishingOperationNumber() == null && this.getStrata() == null && this.getSubStrata() == null && this.getLocation() == null && this.getGearShootingStartDate() == null && this.getGearShootingEndDate() == null && !this.isFishingOperationRectiligne() && this.getTrawlDistance() == null && this.getFishingOperationValid() == null && CollectionUtils.isEmpty(this.getRecorderPerson()) && this.getGear() == null && StringUtils.isEmpty((CharSequence)this.getComment()) && CollectionUtils.isEmpty(this.getAttachment());
    }

    @Override
    protected FishingOperation newEntity() {
        return this.fishingOperation;
    }

    public FishingOperation getFishingOperation() {
        return this.fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
        this.firePropertyChange(PROPERTY_PERSISTED, null, this.isPersisted());
    }

    public boolean isPersisted() {
        return this.fishingOperation != null && !TuttiEntities.isNew((TuttiEntity)this.fishingOperation);
    }

    public DmsCoordinate getGearShootingStartLatitudeDms() {
        return this.gearShootingStartLatitudeDms;
    }

    public void setGearShootingStartLatitudeDms(Float decimal) {
        DmsCoordinate position = DmsCoordinate.valueOf((Float)decimal);
        this.setGearShootingStartLatitudeDmsSign(position.isSign());
        this.setGearShootingStartLatitudeDmsDegree(position.getDegree());
        this.setGearShootingStartLatitudeDmsMinute(position.getMinute());
        this.setGearShootingStartLatitudeDmsSecond(position.getSecond());
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMS, null, this.getGearShootingStartLatitudeDms());
    }

    public boolean isGearShootingStartLatitudeDmsSign() {
        return this.gearShootingStartLatitudeDms.isSign();
    }

    public void setGearShootingStartLatitudeDmsSign(boolean sign) {
        Boolean oldValue = this.isGearShootingStartLatitudeDmsSign();
        this.gearShootingStartLatitudeDms.setSign(sign);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMS_SIGN, oldValue, sign);
    }

    public Integer getGearShootingStartLatitudeDmsDegree() {
        return this.gearShootingStartLatitudeDms.getDegree();
    }

    public void setGearShootingStartLatitudeDmsDegree(Integer degree) {
        Integer oldValue = this.getGearShootingStartLatitudeDmsDegree();
        if (degree != null) {
            degree = Math.abs(degree);
        }
        this.gearShootingStartLatitudeDms.setDegree(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMS_DEGREE, oldValue, degree);
    }

    public Integer getGearShootingStartLatitudeDmsMinute() {
        return this.gearShootingStartLatitudeDms.getMinute();
    }

    public void setGearShootingStartLatitudeDmsMinute(Integer minute) {
        Integer oldValue = this.getGearShootingStartLatitudeDmsMinute();
        this.gearShootingStartLatitudeDms.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMS_MINUTE, oldValue, minute);
    }

    public Integer getGearShootingStartLatitudeDmsSecond() {
        return this.gearShootingStartLatitudeDms.getSecond();
    }

    public void setGearShootingStartLatitudeDmsSecond(Integer second) {
        Integer oldValue = this.getGearShootingStartLatitudeDmsSecond();
        this.gearShootingStartLatitudeDms.setSecond(second);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMS_SECOND, oldValue, second);
    }

    public DmdCoordinate getGearShootingStartLatitudeDmd() {
        return this.gearShootingStartLatitudeDmd;
    }

    public void setGearShootingStartLatitudeDmd(Float decimal) {
        DmdCoordinate position = DmdCoordinate.valueOf((Float)decimal);
        this.setGearShootingStartLatitudeDmdSign(position.isSign());
        this.setGearShootingStartLatitudeDmdDegree(position.getDegree());
        this.setGearShootingStartLatitudeDmdMinute(position.getMinute());
        this.setGearShootingStartLatitudeDmdDecimal(position.getDecimal());
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMD, null, this.getGearShootingStartLatitudeDmd());
    }

    public boolean isGearShootingStartLatitudeDmdSign() {
        return this.gearShootingStartLatitudeDmd.isSign();
    }

    public void setGearShootingStartLatitudeDmdSign(boolean sign) {
        Boolean oldValue = this.isGearShootingStartLatitudeDmdSign();
        this.gearShootingStartLatitudeDmd.setSign(sign);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMD_SIGN, oldValue, sign);
    }

    public Integer getGearShootingStartLatitudeDmdDegree() {
        return this.gearShootingStartLatitudeDmd.getDegree();
    }

    public void setGearShootingStartLatitudeDmdDegree(Integer degree) {
        Integer oldValue = this.getGearShootingStartLatitudeDmdDegree();
        this.gearShootingStartLatitudeDmd.setDegree(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMD_DEGREE, oldValue, degree);
    }

    public Integer getGearShootingStartLatitudeDmdMinute() {
        return this.gearShootingStartLatitudeDmd.getMinute();
    }

    public void setGearShootingStartLatitudeDmdMinute(Integer minute) {
        Integer oldValue = this.getGearShootingStartLatitudeDmdMinute();
        this.gearShootingStartLatitudeDmd.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMD_MINUTE, oldValue, minute);
    }

    public Integer getGearShootingStartLatitudeDmdDecimal() {
        return this.gearShootingStartLatitudeDmd.getDecimal();
    }

    public void setGearShootingStartLatitudeDmdDecimal(Integer decimal) {
        Integer oldValue = this.getGearShootingStartLatitudeDmdDecimal();
        this.gearShootingStartLatitudeDmd.setDecimal(decimal);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DMD_DECIMAL, oldValue, decimal);
    }

    public DmsCoordinate getGearShootingStartLongitudeDms() {
        return this.gearShootingStartLongitudeDms;
    }

    public void setGearShootingStartLongitudeDms(Float decimal) {
        DmsCoordinate position = DmsCoordinate.valueOf((Float)decimal);
        this.setGearShootingStartLongitudeDmsSign(position.isSign());
        this.setGearShootingStartLongitudeDmsDegree(position.getDegree());
        this.setGearShootingStartLongitudeDmsMinute(position.getMinute());
        this.setGearShootingStartLongitudeDmsSecond(position.getSecond());
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMS, null, this.getGearShootingStartLongitudeDms());
    }

    public boolean isGearShootingStartLongitudeDmsSign() {
        return this.gearShootingStartLongitudeDms.isSign();
    }

    public void setGearShootingStartLongitudeDmsSign(boolean sign) {
        Boolean oldValue = this.isGearShootingStartLongitudeDmsSign();
        this.gearShootingStartLongitudeDms.setSign(sign);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMS_SIGN, oldValue, sign);
    }

    public Integer getGearShootingStartLongitudeDmsDegree() {
        return this.gearShootingStartLongitudeDms.getDegree();
    }

    public void setGearShootingStartLongitudeDmsDegree(Integer degree) {
        Integer oldValue = this.getGearShootingStartLongitudeDmsDegree();
        if (degree != null) {
            degree = Math.abs(degree);
        }
        this.gearShootingStartLongitudeDms.setDegree(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMS_DEGREE, oldValue, degree);
    }

    public Integer getGearShootingStartLongitudeDmsMinute() {
        return this.gearShootingStartLongitudeDms.getMinute();
    }

    public void setGearShootingStartLongitudeDmsMinute(Integer minute) {
        Integer oldValue = this.getGearShootingStartLongitudeDmsMinute();
        this.gearShootingStartLongitudeDms.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMS_MINUTE, oldValue, minute);
    }

    public Integer getGearShootingStartLongitudeDmsSecond() {
        return this.gearShootingStartLongitudeDms.getSecond();
    }

    public void setGearShootingStartLongitudeDmsSecond(Integer second) {
        Integer oldValue = this.getGearShootingStartLongitudeDmsSecond();
        this.gearShootingStartLongitudeDms.setSecond(second);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMS_SECOND, oldValue, second);
    }

    public DmdCoordinate getGearShootingStartLongitudeDmd() {
        return this.gearShootingStartLongitudeDmd;
    }

    public void setGearShootingStartLongitudeDmd(Float decimal) {
        DmdCoordinate position = DmdCoordinate.valueOf((Float)decimal);
        this.setGearShootingStartLongitudeDmdSign(position.isSign());
        this.setGearShootingStartLongitudeDmdDegree(position.getDegree());
        this.setGearShootingStartLongitudeDmdMinute(position.getMinute());
        this.setGearShootingStartLongitudeDmdDecimal(position.getDecimal());
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMD, null, this.getGearShootingStartLongitudeDmd());
    }

    public boolean isGearShootingStartLongitudeDmdSign() {
        return this.gearShootingStartLongitudeDmd.isSign();
    }

    public void setGearShootingStartLongitudeDmdSign(boolean sign) {
        Boolean oldValue = this.isGearShootingStartLongitudeDmdSign();
        this.gearShootingStartLongitudeDmd.setSign(sign);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMD_SIGN, oldValue, sign);
    }

    public Integer getGearShootingStartLongitudeDmdDegree() {
        return this.gearShootingStartLongitudeDmd.getDegree();
    }

    public void setGearShootingStartLongitudeDmdDegree(Integer degree) {
        Integer oldValue = this.getGearShootingStartLongitudeDmdDegree();
        if (degree != null) {
            degree = Math.abs(degree);
        }
        this.gearShootingStartLongitudeDmd.setDegree(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMD_DEGREE, oldValue, degree);
    }

    public Integer getGearShootingStartLongitudeDmdMinute() {
        return this.gearShootingStartLongitudeDmd.getMinute();
    }

    public void setGearShootingStartLongitudeDmdMinute(Integer minute) {
        Integer oldValue = this.getGearShootingStartLongitudeDmdMinute();
        this.gearShootingStartLongitudeDmd.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMD_MINUTE, oldValue, minute);
    }

    public Integer getGearShootingStartLongitudeDmdDecimal() {
        return this.gearShootingStartLongitudeDmd.getDecimal();
    }

    public void setGearShootingStartLongitudeDmdDecimal(Integer minute) {
        Integer oldValue = this.getGearShootingStartLongitudeDmdDecimal();
        this.gearShootingStartLongitudeDmd.setDecimal(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DMD_DECIMAL, oldValue, minute);
    }

    public DmsCoordinate getGearShootingEndLatitudeDms() {
        return this.gearShootingEndLatitudeDms;
    }

    public void setGearShootingEndLatitudeDms(Float decimal) {
        DmsCoordinate position = DmsCoordinate.valueOf((Float)decimal);
        this.setGearShootingEndLatitudeDmsSign(position.isSign());
        this.setGearShootingEndLatitudeDmsDegree(position.getDegree());
        this.setGearShootingEndLatitudeDmsMinute(position.getMinute());
        this.setGearShootingEndLatitudeDmsSecond(position.getSecond());
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMS, null, this.getGearShootingEndLatitudeDms());
    }

    public boolean isGearShootingEndLatitudeDmsSign() {
        return this.gearShootingEndLatitudeDms.isSign();
    }

    public void setGearShootingEndLatitudeDmsSign(boolean sign) {
        Boolean oldValue = this.isGearShootingEndLatitudeDmsSign();
        this.gearShootingEndLatitudeDms.setSign(sign);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMS_SIGN, oldValue, sign);
    }

    public Integer getGearShootingEndLatitudeDmsDegree() {
        return this.gearShootingEndLatitudeDms.getDegree();
    }

    public void setGearShootingEndLatitudeDmsDegree(Integer degree) {
        Integer oldValue = this.getGearShootingEndLatitudeDmsDegree();
        if (degree != null) {
            degree = Math.abs(degree);
        }
        this.gearShootingEndLatitudeDms.setDegree(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMS_DEGREE, oldValue, degree);
    }

    public Integer getGearShootingEndLatitudeDmsMinute() {
        return this.gearShootingEndLatitudeDms.getMinute();
    }

    public void setGearShootingEndLatitudeDmsMinute(Integer minute) {
        Integer oldValue = this.getGearShootingEndLatitudeDmsMinute();
        this.gearShootingEndLatitudeDms.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMS_MINUTE, oldValue, minute);
    }

    public Integer getGearShootingEndLatitudeDmsSecond() {
        return this.gearShootingEndLatitudeDms.getSecond();
    }

    public void setGearShootingEndLatitudeDmsSecond(Integer second) {
        Integer oldValue = this.getGearShootingEndLatitudeDmsSecond();
        this.gearShootingEndLatitudeDms.setSecond(second);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMS_SECOND, oldValue, second);
    }

    public DmdCoordinate getGearShootingEndLatitudeDmd() {
        return this.gearShootingEndLatitudeDmd;
    }

    public void setGearShootingEndLatitudeDmd(Float decimal) {
        DmdCoordinate position = DmdCoordinate.valueOf((Float)decimal);
        this.setGearShootingEndLatitudeDmdSign(position.isSign());
        this.setGearShootingEndLatitudeDmdDegree(position.getDegree());
        this.setGearShootingEndLatitudeDmdMinute(position.getMinute());
        this.setGearShootingEndLatitudeDmdDecimal(position.getDecimal());
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMD, null, this.getGearShootingEndLatitudeDmd());
    }

    public boolean isGearShootingEndLatitudeDmdSign() {
        return this.gearShootingEndLatitudeDmd.isSign();
    }

    public void setGearShootingEndLatitudeDmdSign(boolean sign) {
        Boolean oldValue = this.isGearShootingEndLatitudeDmdSign();
        this.gearShootingEndLatitudeDmd.setSign(sign);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMD_SIGN, oldValue, sign);
    }

    public Integer getGearShootingEndLatitudeDmdDegree() {
        return this.gearShootingEndLatitudeDmd.getDegree();
    }

    public void setGearShootingEndLatitudeDmdDegree(Integer degree) {
        Integer oldValue = this.getGearShootingEndLatitudeDmdDegree();
        this.gearShootingEndLatitudeDmd.setDegree(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMD_DEGREE, oldValue, degree);
    }

    public Integer getGearShootingEndLatitudeDmdMinute() {
        return this.gearShootingEndLatitudeDmd.getMinute();
    }

    public void setGearShootingEndLatitudeDmdMinute(Integer minute) {
        Integer oldValue = this.getGearShootingEndLatitudeDmdMinute();
        this.gearShootingEndLatitudeDmd.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMD_MINUTE, oldValue, minute);
    }

    public Integer getGearShootingEndLatitudeDmdDecimal() {
        return this.gearShootingEndLatitudeDmd.getDecimal();
    }

    public void setGearShootingEndLatitudeDmdDecimal(Integer minute) {
        Integer oldValue = this.getGearShootingEndLatitudeDmdDecimal();
        this.gearShootingEndLatitudeDmd.setDecimal(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DMD_DECIMAL, oldValue, minute);
    }

    public DmsCoordinate getGearShootingEndLongitudeDms() {
        return this.gearShootingEndLongitudeDms;
    }

    public void setGearShootingEndLongitudeDms(Float decimal) {
        DmsCoordinate position = DmsCoordinate.valueOf((Float)decimal);
        this.setGearShootingEndLongitudeDmsSign(position.isSign());
        this.setGearShootingEndLongitudeDmsDegree(position.getDegree());
        this.setGearShootingEndLongitudeDmsMinute(position.getMinute());
        this.setGearShootingEndLongitudeDmsSecond(position.getSecond());
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMS, null, this.getGearShootingEndLongitudeDms());
    }

    public boolean isGearShootingEndLongitudeDmsSign() {
        return this.gearShootingEndLongitudeDms.isSign();
    }

    public void setGearShootingEndLongitudeDmsSign(boolean sign) {
        Boolean oldValue = this.isGearShootingEndLongitudeDmsSign();
        this.gearShootingEndLongitudeDms.setSign(sign);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMS_SIGN, oldValue, sign);
    }

    public Integer getGearShootingEndLongitudeDmsDegree() {
        Integer result = this.gearShootingEndLongitudeDms.getDegree();
        return result;
    }

    public void setGearShootingEndLongitudeDmsDegree(Integer degree) {
        Integer oldValue = this.getGearShootingEndLongitudeDmsDegree();
        if (degree != null) {
            degree = Math.abs(degree);
        }
        this.gearShootingEndLongitudeDms.setDegree(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMS_DEGREE, oldValue, degree);
    }

    public Integer getGearShootingEndLongitudeDmsMinute() {
        return this.gearShootingEndLongitudeDms.getMinute();
    }

    public void setGearShootingEndLongitudeDmsMinute(Integer minute) {
        Integer oldValue = this.getGearShootingEndLongitudeDmsMinute();
        this.gearShootingEndLongitudeDms.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMS_MINUTE, oldValue, minute);
    }

    public Integer getGearShootingEndLongitudeDmsSecond() {
        return this.gearShootingEndLongitudeDms.getSecond();
    }

    public void setGearShootingEndLongitudeDmsSecond(Integer second) {
        Integer oldValue = this.getGearShootingEndLongitudeDmsSecond();
        this.gearShootingEndLongitudeDms.setSecond(second);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMS_SECOND, oldValue, second);
    }

    public DmdCoordinate getGearShootingEndLongitudeDmd() {
        return this.gearShootingEndLongitudeDmd;
    }

    public void setGearShootingEndLongitudeDmd(Float decimal) {
        DmdCoordinate position = DmdCoordinate.valueOf((Float)decimal);
        this.setGearShootingEndLongitudeDmdSign(position.isSign());
        this.setGearShootingEndLongitudeDmdDegree(position.getDegree());
        this.setGearShootingEndLongitudeDmdMinute(position.getMinute());
        this.setGearShootingEndLongitudeDmdDecimal(position.getDecimal());
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMD, null, this.getGearShootingEndLongitudeDmd());
    }

    public boolean isGearShootingEndLongitudeDmdSign() {
        return this.gearShootingEndLongitudeDmd.isSign();
    }

    public void setGearShootingEndLongitudeDmdSign(boolean sign) {
        Boolean oldValue = this.isGearShootingEndLongitudeDmdSign();
        this.gearShootingEndLongitudeDmd.setSign(sign);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMD_SIGN, oldValue, sign);
    }

    public Integer getGearShootingEndLongitudeDmdDegree() {
        return this.gearShootingEndLongitudeDmd.getDegree();
    }

    public void setGearShootingEndLongitudeDmdDegree(Integer degree) {
        Integer oldValue = this.gearShootingEndLongitudeDmd.getDegree();
        this.gearShootingEndLongitudeDmd.setDegree(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMD_DEGREE, oldValue, degree);
    }

    public Integer getGearShootingEndLongitudeDmdMinute() {
        return this.gearShootingEndLongitudeDmd.getMinute();
    }

    public void setGearShootingEndLongitudeDmdMinute(Integer minute) {
        Integer oldValue = this.gearShootingEndLongitudeDmd.getMinute();
        this.gearShootingEndLongitudeDmd.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMD_MINUTE, oldValue, minute);
    }

    public Integer getGearShootingEndLongitudeDmdDecimal() {
        return this.gearShootingEndLongitudeDmd.getDecimal();
    }

    public void setGearShootingEndLongitudeDmdDecimal(Integer decimal) {
        Integer oldValue = this.gearShootingEndLongitudeDmd.getDecimal();
        this.gearShootingEndLongitudeDmd.setDecimal(decimal);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DMD_DECIMAL, oldValue, decimal);
    }

    public void setGearShootingStartTime(Date gearShootingStartDate) {
        Date currentGearShootingStartDate = this.getGearShootingStartDate();
        if (currentGearShootingStartDate != null && gearShootingStartDate != null) {
            Calendar currentCalendar = DateUtil.getDefaultCalendar((Date)currentGearShootingStartDate);
            Calendar timeCalendar = DateUtil.getDefaultCalendar((Date)gearShootingStartDate);
            currentCalendar.set(11, timeCalendar.get(11));
            currentCalendar.set(12, timeCalendar.get(12));
            this.setGearShootingStartDate(currentCalendar.getTime());
        }
    }

    public void setGearShootingEndTime(Date gearShootingEndDate) {
        Date currentGearShootingEndDate = this.getGearShootingEndDate();
        if (currentGearShootingEndDate != null && gearShootingEndDate != null) {
            Calendar currentCalendar = DateUtil.getDefaultCalendar((Date)currentGearShootingEndDate);
            Calendar timeCalendar = DateUtil.getDefaultCalendar((Date)gearShootingEndDate);
            currentCalendar.set(11, timeCalendar.get(11));
            currentCalendar.set(12, timeCalendar.get(12));
            this.setGearShootingEndDate(currentCalendar.getTime());
        }
    }

    public String getValidationContext() {
        return this.validationContext;
    }

    public void setValidationContext(String validationContext) {
        String oldValue = this.getValidationContext();
        this.validationContext = validationContext;
        this.firePropertyChange(PROPERTY_VALIDATION_CONTEXT, oldValue, validationContext);
    }

    public CoordinateEditorType getCoordinateEditorType() {
        return this.coordinateEditorType;
    }

    public void setCoordinateEditorType(CoordinateEditorType coordinateEditorType) {
        this.coordinateEditorType = coordinateEditorType;
    }

    public boolean isDateInCruise(Date date) {
        return DateUtil.between((Date)date, (Date)this.getCruise().getBeginDate(), (Date)this.getCruise().getEndDate());
    }

    public boolean isValidDuration() {
        int minutes = DateUtil.getDifferenceInMinutes((Date)this.getGearShootingStartDate(), (Date)this.getGearShootingEndDate());
        return minutes <= 45 && minutes >= 20;
    }

    public boolean isCoordinateDms() {
        return CoordinateEditorType.DMS.equals((Object)this.getCoordinateEditorType());
    }

    public boolean isCoordinateDmd() {
        return CoordinateEditorType.DMD.equals((Object)this.getCoordinateEditorType());
    }

    public void convertGearShootingCoordinatesFromDD() {
        switch (this.coordinateEditorType) {
            case DMS: {
                this.setGearShootingStartLatitudeDms(this.getGearShootingStartLatitude());
                this.setGearShootingStartLongitudeDms(this.getGearShootingStartLongitude());
                this.setGearShootingEndLatitudeDms(this.getGearShootingEndLatitude());
                this.setGearShootingEndLongitudeDms(this.getGearShootingEndLongitude());
                break;
            }
            case DMD: {
                this.setGearShootingStartLatitudeDmd(this.getGearShootingStartLatitude());
                this.setGearShootingStartLongitudeDmd(this.getGearShootingStartLongitude());
                this.setGearShootingEndLatitudeDmd(this.getGearShootingEndLatitude());
                this.setGearShootingEndLongitudeDmd(this.getGearShootingEndLongitude());
            }
        }
    }

    public void convertGearShootingCoordinatesToDD() {
        switch (this.coordinateEditorType) {
            case DMS: {
                this.editObject.setGearShootingStartLatitude(this.gearShootingStartLatitudeDms.toDecimal());
                this.editObject.setGearShootingStartLongitude(this.gearShootingStartLongitudeDms.toDecimal());
                this.editObject.setGearShootingEndLatitude(this.gearShootingEndLatitudeDms.toDecimal());
                this.editObject.setGearShootingEndLongitude(this.gearShootingEndLongitudeDms.toDecimal());
                break;
            }
            case DMD: {
                this.editObject.setGearShootingStartLatitude(this.gearShootingStartLatitudeDmd.toDecimal());
                this.editObject.setGearShootingStartLongitude(this.gearShootingStartLongitudeDmd.toDecimal());
                this.editObject.setGearShootingEndLatitude(this.gearShootingEndLatitudeDmd.toDecimal());
                this.editObject.setGearShootingEndLongitude(this.gearShootingEndLongitudeDmd.toDecimal());
            }
        }
    }

    public void computeDistance() {
        this.convertGearShootingCoordinatesToDD();
        if (this.getGearShootingStartLatitude() != null && this.getGearShootingStartLongitude() != null && this.getGearShootingEndLatitude() != null && this.getGearShootingEndLongitude() != null) {
            Integer distance = Distances.computeDistanceInMeters((Float)this.getGearShootingStartLatitude(), (Float)this.getGearShootingStartLongitude(), (Float)this.getGearShootingEndLatitude(), (Float)this.getGearShootingEndLongitude());
            this.setTrawlDistance(distance);
        }
    }

    public SecondaryVesselTypeEnum getSecondaryVesselType() {
        return this.secondaryVesselType;
    }

    public boolean isSecondaryVesselTypeAll() {
        return SecondaryVesselTypeEnum.ALL.equals((Object)this.getSecondaryVesselType());
    }

    public boolean isSecondaryVesselTypeScientific() {
        return SecondaryVesselTypeEnum.SCIENTIFIC.equals((Object)this.getSecondaryVesselType());
    }

    public boolean isSecondaryVesselTypeFishing() {
        return SecondaryVesselTypeEnum.FISHING.equals((Object)this.getSecondaryVesselType());
    }

    public boolean isSecondaryVesselTypeOnlyCruise() {
        return SecondaryVesselTypeEnum.ONLY_CRUISE.equals((Object)this.getSecondaryVesselType());
    }

    public void setSecondaryVesselType(SecondaryVesselTypeEnum secondaryVesselType) {
        this.secondaryVesselType = secondaryVesselType;
        this.firePropertyChange(PROPERTY_SECONDARY_VESSEL_TYPE, null, (Object)secondaryVesselType);
        this.firePropertyChange(PROPERTY_SECONDARY_VESSEL_TYPE_ALL, null, this.isSecondaryVesselTypeAll());
        this.firePropertyChange(PROPERTY_SECONDARY_VESSEL_TYPE_SCIENTIFIC, null, this.isSecondaryVesselTypeScientific());
        this.firePropertyChange(PROPERTY_SECONDARY_VESSEL_TYPE_FISHING, null, this.isSecondaryVesselTypeFishing());
    }

    @Override
    public ObjectTypeCode getObjectType() {
        return ObjectTypeCode.OPERATION;
    }

    @Override
    public Integer getObjectId() {
        return this.getIdAsInt();
    }

    @Override
    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    public Cruise getCruise() {
        return this.editObject.getCruise();
    }

    public void setCruise(Cruise cruise) {
        this.editObject.setCruise(cruise);
    }

    public String getStationNumber() {
        return this.editObject.getStationNumber();
    }

    public void setStationNumber(String stationNumber) {
        String oldValue = this.getStationNumber();
        this.editObject.setStationNumber(stationNumber);
        this.firePropertyChange("stationNumber", oldValue, stationNumber);
    }

    public Integer getFishingOperationNumber() {
        return this.editObject.getFishingOperationNumber();
    }

    public void setFishingOperationNumber(Integer fishingOperationNumber) {
        Integer oldValue = this.getFishingOperationNumber();
        this.editObject.setFishingOperationNumber(fishingOperationNumber);
        this.firePropertyChange("fishingOperationNumber", oldValue, fishingOperationNumber);
    }

    public TuttiLocation getStrata() {
        return this.editObject.getStrata();
    }

    public void setStrata(TuttiLocation strata) {
        TuttiLocation oldValue = this.getStrata();
        this.editObject.setStrata(strata);
        this.firePropertyChange("strata", oldValue, strata);
    }

    public TuttiLocation getSubStrata() {
        return this.editObject.getSubStrata();
    }

    public void setSubStrata(TuttiLocation subStrata) {
        TuttiLocation oldValue = this.getSubStrata();
        this.editObject.setSubStrata(subStrata);
        this.firePropertyChange("subStrata", oldValue, subStrata);
    }

    public Float getGearShootingStartLatitude() {
        return this.editObject.getGearShootingStartLatitude();
    }

    public void setGearShootingStartLatitude(Float gearShootingStartLatitude) {
        Float oldValue = this.getGearShootingStartLatitude();
        this.editObject.setGearShootingStartLatitude(gearShootingStartLatitude);
        this.firePropertyChange("gearShootingStartLatitude", oldValue, gearShootingStartLatitude);
    }

    public Float getGearShootingStartLongitude() {
        return this.editObject.getGearShootingStartLongitude();
    }

    public void setGearShootingStartLongitude(Float gearShootingStartLongitude) {
        Float oldValue = this.getGearShootingStartLongitude();
        this.editObject.setGearShootingStartLongitude(gearShootingStartLongitude);
        this.firePropertyChange("gearShootingStartLongitude", oldValue, gearShootingStartLongitude);
    }

    public Date getGearShootingStartDate() {
        return this.editObject.getGearShootingStartDate();
    }

    public void setGearShootingStartDate(Date gearShootingStartDate) {
        Date oldValue = this.getGearShootingStartDate();
        if (gearShootingStartDate != null) {
            Calendar calendar = DateUtil.getDefaultCalendar((Date)gearShootingStartDate);
            calendar.set(13, 0);
            this.editObject.setGearShootingStartDate(calendar.getTime());
        } else {
            this.editObject.setGearShootingStartDate(null);
        }
        this.firePropertyChange("gearShootingStartDate", oldValue, this.getGearShootingStartDate());
    }

    public Float getGearShootingEndLatitude() {
        return this.editObject.getGearShootingEndLatitude();
    }

    public void setGearShootingEndLatitude(Float gearShootingEndLatitude) {
        Float oldValue = this.getGearShootingEndLatitude();
        this.editObject.setGearShootingEndLatitude(gearShootingEndLatitude);
        this.firePropertyChange("gearShootingEndLatitude", oldValue, gearShootingEndLatitude);
    }

    public Float getGearShootingEndLongitude() {
        return this.editObject.getGearShootingEndLongitude();
    }

    public void setGearShootingEndLongitude(Float gearShootingEndLongitude) {
        Float oldValue = this.getGearShootingEndLongitude();
        this.editObject.setGearShootingEndLongitude(gearShootingEndLongitude);
        this.firePropertyChange("gearShootingEndLongitude", oldValue, gearShootingEndLongitude);
    }

    public Date getGearShootingEndDate() {
        return this.editObject.getGearShootingEndDate();
    }

    public void setGearShootingEndDate(Date gearShootingEndDate) {
        Date oldValue = this.getGearShootingEndDate();
        if (gearShootingEndDate != null) {
            Calendar calendar = DateUtil.getDefaultCalendar((Date)gearShootingEndDate);
            calendar.set(13, 0);
            this.editObject.setGearShootingEndDate(calendar.getTime());
        } else {
            this.editObject.setGearShootingEndDate(null);
        }
        this.firePropertyChange("gearShootingEndDate", oldValue, this.getGearShootingEndDate());
    }

    public boolean isFishingOperationRectiligne() {
        return this.editObject.isFishingOperationRectiligne();
    }

    public void setFishingOperationRectiligne(boolean fishingOperationRectiligne) {
        Boolean oldValue = this.isFishingOperationRectiligne();
        this.editObject.setFishingOperationRectiligne(fishingOperationRectiligne);
        this.firePropertyChange("fishingOperationRectiligne", oldValue, fishingOperationRectiligne);
    }

    public Integer getTrawlDistance() {
        return this.editObject.getTrawlDistance();
    }

    public void setTrawlDistance(Integer trawlDistance) {
        Integer oldValue = this.getTrawlDistance();
        this.editObject.setTrawlDistance(trawlDistance);
        this.firePropertyChange("trawlDistance", oldValue, trawlDistance);
    }

    public Boolean getFishingOperationValid() {
        return this.editObject.getFishingOperationValid();
    }

    public void setFishingOperationValid(Boolean fishingOperationValid) {
        Boolean oldValue = this.getFishingOperationValid();
        this.editObject.setFishingOperationValid(fishingOperationValid);
        this.firePropertyChange("fishingOperationValid", oldValue, fishingOperationValid);
    }

    public TuttiLocation getLocation() {
        return this.editObject.getLocation();
    }

    public void setLocation(TuttiLocation location) {
        TuttiLocation oldValue = this.getLocation();
        this.editObject.setLocation(location);
        this.firePropertyChange("location", oldValue, location);
    }

    public String getComment() {
        return this.editObject.getComment();
    }

    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.editObject.setComment(comment);
        this.firePropertyChange("comment", oldValue, comment);
    }

    public String getSynchronizationStatus() {
        return this.editObject.getSynchronizationStatus();
    }

    public void setSynchronizationStatus(String synchronizationStatus) {
        String oldValue = this.getSynchronizationStatus();
        this.editObject.setSynchronizationStatus(synchronizationStatus);
        this.firePropertyChange("synchronizationStatus", oldValue, synchronizationStatus);
    }

    public List<Person> getRecorderPerson() {
        return this.editObject.getRecorderPerson();
    }

    public void setRecorderPerson(List<Person> recorderPerson) {
        ArrayList oldValue = null;
        List<Person> oldRecorderPerson = this.getRecorderPerson();
        if (oldRecorderPerson != null) {
            oldValue = Lists.newArrayList(oldRecorderPerson);
        }
        this.editObject.setRecorderPerson((List)Lists.newArrayList());
        if (recorderPerson != null) {
            this.getRecorderPerson().addAll(recorderPerson);
        }
        this.firePropertyChange("recorderPerson", oldValue, recorderPerson);
    }

    public Gear getGear() {
        return this.editObject.getGear();
    }

    public void setGear(Gear gear) {
        Gear oldValue = this.getGear();
        this.editObject.setGear(gear);
        this.firePropertyChange("gear", oldValue, gear);
    }

    public Vessel getVessel() {
        return this.editObject.getVessel();
    }

    public void setVessel(Vessel vessel) {
        Vessel oldValue = this.getVessel();
        this.editObject.setVessel(vessel);
        this.firePropertyChange("vessel", oldValue, vessel);
    }

    public String getMultirigAggregation() {
        return this.editObject.getMultirigAggregation();
    }

    public void setMultirigAggregation(String multirigAggregation) {
        String oldValue = this.getMultirigAggregation();
        this.editObject.setMultirigAggregation(multirigAggregation);
        this.firePropertyChange("multirigAggregation", oldValue, multirigAggregation);
    }

    public Vessel getSecondaryVessel(int index) {
        return this.editObject.getSecondaryVessel(index);
    }

    public boolean isSecondaryVesselEmpty() {
        return this.editObject.isSecondaryVesselEmpty();
    }

    public int sizeSecondaryVessel() {
        return this.editObject.sizeSecondaryVessel();
    }

    public void addSecondaryVessel(Vessel secondaryVessel) {
        this.editObject.addSecondaryVessel(secondaryVessel);
        this.firePropertyChange("secondaryVessel", null, this.getSecondaryVessel());
    }

    public void addAllSecondaryVessel(Collection<Vessel> secondaryVessel) {
        this.editObject.addAllSecondaryVessel(secondaryVessel);
        this.firePropertyChange("secondaryVessel", null, this.getSecondaryVessel());
    }

    public boolean removeSecondaryVessel(Vessel secondaryVessel) {
        boolean result = this.editObject.removeSecondaryVessel(secondaryVessel);
        this.firePropertyChange("secondaryVessel", null, this.getSecondaryVessel());
        return result;
    }

    public boolean removeAllSecondaryVessel(Collection<Vessel> secondaryVessel) {
        boolean result = this.editObject.removeAllSecondaryVessel(secondaryVessel);
        this.firePropertyChange("secondaryVessel", null, this.getSecondaryVessel());
        return result;
    }

    public boolean containsSecondaryVessel(Vessel secondaryVessel) {
        return this.editObject.containsSecondaryVessel(secondaryVessel);
    }

    public boolean containsAllSecondaryVessel(Collection<Vessel> secondaryVessel) {
        return this.editObject.containsAllSecondaryVessel(secondaryVessel);
    }

    public List<Vessel> getSecondaryVessel() {
        return this.editObject.getSecondaryVessel();
    }

    public void setSecondaryVessel(List<Vessel> secondaryVessel) {
        this.editObject.setSecondaryVessel(secondaryVessel);
        this.firePropertyChange("secondaryVessel", null, this.getSecondaryVessel());
    }

    public List<Vessel> getAllSecondaryVessel() {
        return this.allSecondaryVessel;
    }

    public void setAllSecondaryVessel(List<Vessel> allSecondaryVessel) {
        this.allSecondaryVessel = allSecondaryVessel;
    }

    public List<Vessel> getOnlyCruisSecondaryVessel() {
        return this.onlyCruisSecondaryVessel;
    }

    public void setOnlyCruisSecondaryVessel(List<Vessel> onlyCruisSecondaryVessel) {
        this.onlyCruisSecondaryVessel = onlyCruisSecondaryVessel;
    }

    public List<Vessel> getFishingSecondaryVessel() {
        return this.fishingSecondaryVessel;
    }

    public void setFishingSecondaryVessel(List<Vessel> fishingSecondaryVessel) {
        this.fishingSecondaryVessel = fishingSecondaryVessel;
    }

    public List<Vessel> getScientificSecondaryVessel() {
        return this.scientificSecondaryVessel;
    }

    public void setScientificSecondaryVessel(List<Vessel> scientificSecondaryVessel) {
        this.scientificSecondaryVessel = scientificSecondaryVessel;
    }

    public boolean isPlanktonObserved() {
        return false;
    }

    public void setPlanktonObserved(boolean planktonObserved) {
    }

    public CaracteristicMap getVesselUseFeatures() {
        return null;
    }

    public void setVesselUseFeatures(CaracteristicMap vesselUseFeatures) {
    }

    public CaracteristicMap getGearUseFeatures() {
        return null;
    }

    public void setGearUseFeatures(CaracteristicMap gearUseFeatures) {
    }

    public boolean isAccidentalObserved() {
        return false;
    }

    public void setAccidentalObserved(boolean accidentalObserved) {
    }

    public Person getRecorderPerson(int index) {
        return null;
    }

    public boolean isRecorderPersonEmpty() {
        return false;
    }

    public int sizeRecorderPerson() {
        return 0;
    }

    public void addRecorderPerson(Person recorderPerson) {
    }

    public void addAllRecorderPerson(Collection<Person> recorderPerson) {
    }

    public boolean removeRecorderPerson(Person recorderPerson) {
        return false;
    }

    public boolean removeAllRecorderPerson(Collection<Person> recorderPerson) {
        return false;
    }

    public boolean containsRecorderPerson(Person recorderPerson) {
        return false;
    }

    public boolean containsAllRecorderPerson(Collection<Person> recorderPerson) {
        return false;
    }

    public boolean isImportFromColumnFileEnabled() {
        return this.importFromColumnFileEnabled;
    }

    public void setImportFromColumnFileEnabled(boolean importFromColumnFileEnabled) {
        this.importFromColumnFileEnabled = importFromColumnFileEnabled;
    }
}

