/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.metadata.IObjectDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public class ObjectDefn
implements IObjectDefn {
    protected IMessages messages;
    protected String name = null;
    protected String displayNameKey = null;
    protected Map<String, IPropertyDefn> properties = new LinkedHashMap<String, IPropertyDefn>();
    protected String since;

    public ObjectDefn() {
        this.since = "none";
    }

    public ObjectDefn(String theName) {
        this.name = theName;
    }

    public void setDisplayNameKey(String id) {
        this.displayNameKey = id;
    }

    @Override
    public Object getDisplayNameKey() {
        return this.displayNameKey;
    }

    @Override
    public String getDisplayName() {
        if (this.displayNameKey != null) {
            String displayName = null;
            if (this.messages == null) {
                displayName = ModelMessages.getMessage(this.displayNameKey);
            } else {
                ULocale locale = ThreadResources.getLocale();
                displayName = this.messages.getMessage(this.displayNameKey, locale);
            }
            if (displayName != null) {
                return displayName;
            }
        }
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public void addProperty(PropertyDefn property) throws MetaDataException {
        if (property == null) {
            return;
        }
        String name = property.getName();
        assert (name != null && name.trim().length() != 0);
        if (this.properties.containsKey(name)) {
            throw new MetaDataException(new String[]{name, this.name}, "DUPLICATE_PROPERTY");
        }
        this.properties.put(name, property);
        property.setOwner(this);
    }

    @Override
    public IPropertyDefn findProperty(String propName) {
        assert (propName != null);
        return this.properties.get(propName);
    }

    @Override
    public Iterator<IPropertyDefn> getPropertyIterator() {
        ArrayList<IPropertyDefn> propDefns = new ArrayList<IPropertyDefn>(this.properties.values());
        return ModelUtil.sortPropertiesByLocalizedName(propDefns).iterator();
    }

    @Override
    public Iterator<IPropertyDefn> propertiesIterator() {
        return new ArrayList<IPropertyDefn>(this.properties.values()).iterator();
    }

    protected void buildDefn() throws MetaDataException {
    }

    public void setSince(String value) {
        if (!StringUtil.isBlank(value)) {
            this.since = value;
        }
    }

    public String getSince() {
        return this.since;
    }

    public String toString() {
        if (!StringUtil.isBlank(this.getName())) {
            return this.getName();
        }
        return super.toString();
    }

    public void setMessages(IMessages messages) {
        this.messages = messages;
    }

    public IMessages getMessages() {
        return this.messages;
    }
}

