/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.service.csv.EntityNotFoundException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.ValueParserFormatter;

public abstract class EntityParserFormatterSupport<E extends TuttiEntity>
implements ValueParserFormatter<E> {
    protected final String formatNullValue;
    protected final boolean technical;
    protected final Class<E> entityType;
    protected Map<String, E> entitiesById;
    protected boolean authorizeObsoleteReferentials;

    protected EntityParserFormatterSupport(String formatNullValue, boolean technical, Class<E> entityType) {
        this.formatNullValue = formatNullValue;
        this.technical = technical;
        this.entityType = entityType;
    }

    protected abstract List<E> getEntitiesWithObsoletes();

    protected abstract List<E> getEntities();

    protected abstract String formatBusiness(E var1);

    protected Map<String, E> getEntitiesById() {
        if (this.entitiesById == null) {
            List<E> entities = this.isAuthorizeObsoleteReferentials() ? this.getEntitiesWithObsoletes() : this.getEntities();
            this.entitiesById = TuttiEntities.splitById(entities);
        }
        return this.entitiesById;
    }

    public E parse(String value) throws ParseException {
        E result = null;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            result = this.parseNotBlankValue(value);
        }
        return result;
    }

    public String format(E e) {
        String value = e == null ? (this.technical ? "" : this.formatNullValue) : (this.technical ? this.formatTechnical(e) : this.formatBusiness(e));
        return value;
    }

    protected E parseNotBlankValue(String value) {
        TuttiEntity result = (TuttiEntity)this.getEntitiesById().get(value);
        if (result == null) {
            throw new EntityNotFoundException(this.entityType, value);
        }
        return (E)result;
    }

    protected String formatTechnical(E e) {
        String value = e.getId();
        return value;
    }

    public boolean isAuthorizeObsoleteReferentials() {
        return this.authorizeObsoleteReferentials;
    }

    public void setAuthorizeObsoleteReferentials(boolean authorizeObsoleteReferentials) {
        this.authorizeObsoleteReferentials = authorizeObsoleteReferentials;
    }
}

