/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatReferentialSpeciesImportResult;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersistenceHelper;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.consumer.CsvConsumerForTemporarySpecies;
import fr.ifremer.tutti.service.referential.csv.SpeciesRow;
import java.io.IOException;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportReferentialSpeciesAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportReferentialSpeciesAction.class);
    private final GenericformatImportPersistenceHelper persistenceHelper;

    public ImportReferentialSpeciesAction(GenericFormatContextSupport importContext, GenericformatImportPersistenceHelper persistenceHelper) {
        super(importContext);
        this.persistenceHelper = persistenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.getReferentialTemporarySpeciesFileResult().isFound();
    }

    @Override
    protected void skipExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Skip import temporary species (no file found).");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.import.temporarySpecies", (Object[])new Object[0]));
    }

    @Override
    protected void doExecute() {
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.temporarySpecies", (Object[])new Object[0]));
        if (log.isInfoEnabled()) {
            log.info((Object)"Import temporary species.");
        }
        ReferentialImportRequest<Species, Integer> referentialImportRequest = this.persistenceHelper.createSpeciesImportRequest();
        TreeMap<Integer, Integer> referenceTaxonIdById = new TreeMap<Integer, Integer>();
        GenericFormatReferentialSpeciesImportResult importFileResult = this.importContext.getReferentialTemporarySpeciesFileResult();
        try (CsvConsumerForTemporarySpecies consumer = this.importContext.loadTemporarySpecies(false);){
            for (ImportRow row : consumer) {
                consumer.checkRowForGenericFormatImport(row, referentialImportRequest);
                referenceTaxonIdById.put(((SpeciesRow)row.getBean()).getIdAsInt(), ((SpeciesRow)row.getBean()).getReferenceTaxonId());
            }
            importFileResult.flushErrors(consumer);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close species.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        if (importFileResult.isValid()) {
            ReferentialImportResult<Species> referentialImportResult = this.persistenceHelper.importSpecies(referentialImportRequest);
            importFileResult.flushResult(referentialImportRequest, referentialImportResult);
            importFileResult.flushReferenceTaxonIds(referenceTaxonIdById);
            if (log.isInfoEnabled()) {
                log.info((Object)("Temporary species import result: " + importFileResult.getReport()));
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Do not import temporary species (the incoming file is not valid)");
        }
    }
}

