/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.interfaces.IImageItemModel;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.impl.ActionHelper;

public class ImageHandle
extends ReportItemHandle
implements IImageItemModel {
    public ImageHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public double getScale() {
        return this.getFloatProperty("scale");
    }

    public String getSize() {
        return this.getStringProperty("size");
    }

    @Override
    public String getAltText() {
        return this.getStringProperty("altText");
    }

    @Override
    public void setAltText(String altText) throws SemanticException {
        this.setProperty("altText", altText);
    }

    public String getAltTextKey() {
        return this.getStringProperty("altTextID");
    }

    public void setAltTextKey(String altTextKey) throws SemanticException {
        this.setProperty("altTextID", altTextKey);
    }

    public String getSource() {
        return this.getStringProperty("source");
    }

    public void setSource(String source) throws SemanticException {
        this.setProperty("source", source);
    }

    public String getURI() {
        if ("url".equalsIgnoreCase(this.getSource()) || "file".equalsIgnoreCase(this.getSource())) {
            return this.getStringProperty("uri");
        }
        return null;
    }

    @Override
    public String getURL() {
        if ("url".equalsIgnoreCase(this.getSource())) {
            return this.getStringProperty("uri");
        }
        return null;
    }

    public String getFile() {
        if ("file".equalsIgnoreCase(this.getSource())) {
            return this.getStringProperty("uri");
        }
        return null;
    }

    public String getTypeExpression() {
        if ("expr".equalsIgnoreCase(this.getSource())) {
            return this.getStringProperty("typeExpr");
        }
        return null;
    }

    public String getValueExpression() {
        if ("expr".equalsIgnoreCase(this.getSource())) {
            return this.getStringProperty("valueExpr");
        }
        return null;
    }

    public String getImageName() {
        if (!"embed".equalsIgnoreCase(this.getStringProperty("source"))) {
            return null;
        }
        return this.getStringProperty("imageName");
    }

    public EmbeddedImageHandle getEmbeddedImage() {
        if (!"embed".equals(this.getStringProperty("source"))) {
            return null;
        }
        StructRefValue imageRef = (StructRefValue)this.getElement().getProperty(this.getModule(), "imageName");
        if (imageRef == null) {
            return null;
        }
        if (imageRef.isResolved()) {
            EmbeddedImage image = (EmbeddedImage)imageRef.getTargetStructure();
            DesignElement owner = this.getElement();
            while (owner != null) {
                if (owner.getLocalProperty(this.module, "imageName") == imageRef) {
                    Module targetModule = null;
                    targetModule = owner != this.getElement() ? owner.getRoot() : (imageRef.getLibraryNamespace() != null ? this.getModule().getLibraryWithNamespace(imageRef.getLibraryNamespace()) : this.getModule());
                    assert (targetModule != null);
                    List<Object> images = targetModule.getListProperty(targetModule, "images");
                    if (images == null || images.isEmpty()) continue;
                    int posn = images.indexOf(image);
                    PropertyHandle propHandle = targetModule.getHandle(targetModule).getPropertyHandle("images");
                    assert (posn != -1);
                    EmbeddedImageHandle imageHandle = new EmbeddedImageHandle(propHandle, posn);
                    return imageHandle;
                }
                DesignElement designElement = owner = owner.isVirtualElement() ? owner.getVirtualParent() : owner.getExtendsElement();
            }
        }
        return null;
    }

    public void setImageName(String name) throws SemanticException {
        ActivityStack as = this.module.getActivityStack();
        try {
            as.startTrans(CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{"imageName"}));
            this.setProperty("source", "embed");
            this.setProperty("imageName", name);
        }
        catch (SemanticException e) {
            as.rollback();
            throw e;
        }
        as.commit();
    }

    @Override
    public void setURL(String url) throws SemanticException {
        String source = "url";
        this.setURIProperty(url, source);
    }

    public void setURI(String uri) throws SemanticException {
        this.setURL(uri);
    }

    public void setFile(String file) throws SemanticException {
        String source = "file";
        this.setURIProperty(file, source);
    }

    private void setURIProperty(Object prop, String source) throws SemanticException {
        ActivityStack as = this.module.getActivityStack();
        try {
            as.startTrans(CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{"uri"}));
            this.setProperty("source", source);
            this.setProperty("uri", prop);
        }
        catch (SemanticException e) {
            as.rollback();
            throw e;
        }
        as.commit();
    }

    public void setScale(double scale) throws SemanticException {
        this.setFloatProperty("scale", scale);
    }

    public void setSize(String size) throws SemanticException {
        this.setStringProperty("size", size);
    }

    public void setTypeExpression(String value) throws SemanticException {
        ActivityStack as = this.module.getActivityStack();
        try {
            as.startTrans(CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{"typeExpr"}));
            this.setProperty("source", "expr");
            this.setProperty("typeExpr", value);
        }
        catch (SemanticException e) {
            as.rollback();
            throw e;
        }
        as.commit();
    }

    public void setValueExpression(String value) throws SemanticException {
        ActivityStack as = this.module.getActivityStack();
        try {
            as.startTrans(CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{"valueExpr"}));
            this.setProperty("source", "expr");
            this.setProperty("valueExpr", value);
        }
        catch (SemanticException e) {
            as.rollback();
            throw e;
        }
        as.commit();
    }

    public ActionHandle getActionHandle() {
        return new ActionHelper(this, "action").getActionHandle();
    }

    public ActionHandle setAction(Action action) throws SemanticException {
        return new ActionHelper(this, "action").setAction(action);
    }

    public Iterator<ActionHandle> actionsIterator() {
        return new ActionHelper(this, "action").actionsIterator();
    }

    public String getHelpText() {
        return this.getStringProperty("helpText");
    }

    public void setHelpText(String helpText) throws SemanticException {
        this.setStringProperty("helpText", helpText);
    }

    public String getHelpTextKey() {
        return this.getStringProperty("helpTextID");
    }

    public void setHelpTextKey(String helpTextKey) throws SemanticException {
        this.setStringProperty("helpTextID", helpTextKey);
    }

    public boolean fitToContainer() {
        return this.getBooleanProperty("fitToContainer");
    }

    public void setFitToContainer(boolean fitToContainer) throws SemanticException {
        this.setProperty("fitToContainer", fitToContainer);
    }

    public void setURL(Expression expr) throws SemanticException {
        this.setURIProperty(expr, "url");
    }

    public void setFile(Expression expr) throws SemanticException {
        this.setURIProperty(expr, "file");
    }

    public boolean isProportionalScale() {
        return this.getBooleanProperty("proportionalScale");
    }

    public void setProportionalScale(boolean proportionalScale) throws SemanticException {
        this.setBooleanProperty("proportionalScale", proportionalScale);
    }
}

