// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.vessel.feature.physical;

import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * Caractéristiques d'un navire, sur une période donnée.
 * Si le navire est inscrit au FPC, les caractéristiques FPC sont utilisées (jauge_ums et
 * jauge_brute).
 * REMARQUE : les données ramenées depuis Harmonie sont fusionnées entre les caractéristiques FPC (à
 * utiliser de préférence si présent), et les caractéristiques d'autres sources.
 * Nombre de lignes : 67375
 */
// HibernateEntity.vsl annotations merge-point
public abstract class VesselFeatures
    implements Serializable, Comparable<VesselFeatures>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 4099560918315500551L;

    // Generate 16 attributes
    private Integer id;

    /**
     * 
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * 
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Date startDateTime;

    /**
     * Date de début de validité des caractéristiques navires.
     * @return this.startDateTime Date
     */
    public Date getStartDateTime()
    {
        return this.startDateTime;
    }

    /**
     * Date de début de validité des caractéristiques navires.
     * @param startDateTimeIn Date
     */
    public void setStartDateTime(Date startDateTimeIn)
    {
        this.startDateTime = startDateTimeIn;
    }

    private Date endDateTime;

    /**
     * Date de fin de validité des caractéristiques navires.
     * @return this.endDateTime Date
     */
    public Date getEndDateTime()
    {
        return this.endDateTime;
    }

    /**
     * Date de fin de validité des caractéristiques navires.
     * @param endDateTimeIn Date
     */
    public void setEndDateTime(Date endDateTimeIn)
    {
        this.endDateTime = endDateTimeIn;
    }

    private String name;

    /**
     * Nom du navire pour la période début-fin
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Nom du navire pour la période début-fin
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String exteriorMarking;

    /**
     * Marquage extérieur.
     * par exemple : "BR 101717"
     * @return this.exteriorMarking String
     */
    public String getExteriorMarking()
    {
        return this.exteriorMarking;
    }

    /**
     * Marquage extérieur.
     * par exemple : "BR 101717"
     * @param exteriorMarkingIn String
     */
    public void setExteriorMarking(String exteriorMarkingIn)
    {
        this.exteriorMarking = exteriorMarkingIn;
    }

    private Float administrativePower;

    /**
     * Puissance principale administrative (en Kw) du navire pour la période début-fin.
     * Selon le règlement (CEE) no 2930/86
     * @return this.administrativePower Float
     */
    public Float getAdministrativePower()
    {
        return this.administrativePower;
    }

    /**
     * Puissance principale administrative (en Kw) du navire pour la période début-fin.
     * Selon le règlement (CEE) no 2930/86
     * @param administrativePowerIn Float
     */
    public void setAdministrativePower(Float administrativePowerIn)
    {
        this.administrativePower = administrativePowerIn;
    }

    private Float auxiliaryPower;

    /**
     * Puissance auxiliaire en kW.
     * Reprend toute puissance installée non comprise sous la rubrique Puissance administrative
     * @return this.auxiliaryPower Float
     */
    public Float getAuxiliaryPower()
    {
        return this.auxiliaryPower;
    }

    /**
     * Puissance auxiliaire en kW.
     * Reprend toute puissance installée non comprise sous la rubrique Puissance administrative
     * @param auxiliaryPowerIn Float
     */
    public void setAuxiliaryPower(Float auxiliaryPowerIn)
    {
        this.auxiliaryPower = auxiliaryPowerIn;
    }

    private Integer grossTonnageGT;

    /**
     * Tonnage GT (Gross Tonnage), exprimé en UMS (Universal Measurement System), et multiplié par
     * 100.
     * Il s'agit d'un tonnage reconnu internationnellement.
     * La France s'est engagé à fournir un tonnage GT pour tous les navires de plus de 24m, par
     * application du Décret N°725 du 10 août 1982.
     * ------
     * Jauge GT ou Gross Tonnage en accord avec la Convention internationale de 1969 (règlement de
     * Londres, International Convention on Tonnage Measurement of Ships, London, 1969 (in use since
     * 1996) for vessels >= 15m"
     * Par décret n° 82-725 du 10 août 1982, publié au Journal officiel du 20 août 1982, la
     * Convention internationale de 1969 sur le jaugeage des navires est entrée en vigueur en France
     * le 18 juillet 1982. Le règlement de jaugeage annexé à cette convention conclue à Londres le
     * 23 juin 1969 devient règlement international. La jauge, de Londres comprend la jauge brute et
     * la jauge nette et doit être calculée selon les règles énoncées par la convention
     * internationale de 1969 sur le jaugeage des navires. La jauge brute est obtenue à partir des
     * mesures pratiquées sur tous les espaces fermés d'un navire, à l'exception des espaces exclus
     * par les règles de la convention précitée. La jauge nette est déterminée par les dimensions
     * des espaces réservés au fret et par le nombre des passagers.
     * La jauge de Londres est reprise sur le "certificat international de jaugeage des navires
     * (1969)".
     * @return this.grossTonnageGT Integer
     */
    public Integer getGrossTonnageGT()
    {
        return this.grossTonnageGT;
    }

    /**
     * Tonnage GT (Gross Tonnage), exprimé en UMS (Universal Measurement System), et multiplié par
     * 100.
     * Il s'agit d'un tonnage reconnu internationnellement.
     * La France s'est engagé à fournir un tonnage GT pour tous les navires de plus de 24m, par
     * application du Décret N°725 du 10 août 1982.
     * ------
     * Jauge GT ou Gross Tonnage en accord avec la Convention internationale de 1969 (règlement de
     * Londres, International Convention on Tonnage Measurement of Ships, London, 1969 (in use since
     * 1996) for vessels >= 15m"
     * Par décret n° 82-725 du 10 août 1982, publié au Journal officiel du 20 août 1982, la
     * Convention internationale de 1969 sur le jaugeage des navires est entrée en vigueur en France
     * le 18 juillet 1982. Le règlement de jaugeage annexé à cette convention conclue à Londres le
     * 23 juin 1969 devient règlement international. La jauge, de Londres comprend la jauge brute et
     * la jauge nette et doit être calculée selon les règles énoncées par la convention
     * internationale de 1969 sur le jaugeage des navires. La jauge brute est obtenue à partir des
     * mesures pratiquées sur tous les espaces fermés d'un navire, à l'exception des espaces exclus
     * par les règles de la convention précitée. La jauge nette est déterminée par les dimensions
     * des espaces réservés au fret et par le nombre des passagers.
     * La jauge de Londres est reprise sur le "certificat international de jaugeage des navires
     * (1969)".
     * @param grossTonnageGTIn Integer
     */
    public void setGrossTonnageGT(Integer grossTonnageGTIn)
    {
        this.grossTonnageGT = grossTonnageGTIn;
    }

    private Integer grossTonnageGRT;

    /**
     * Tonnage du navire, ou jauge Brute, exprimé en TJB (Tonnage de Jauge Brute), et multiplié par
     * 100.
     * ------
     * Tonnage (GRT) 'Gross Registered Tonnage' en accord avec la convention d'Oslo (1947) (en
     * emploi en France jusqu'en 1995, toujours utilisé dans certains pays).
     * (GRT represent the total cubic measured content of the permanently enclosed spaces of a
     * vessel, with some allowances or deductions for exempt spaces such as living quarters [1 gross
     * register ton = 100 cubic feet = 2.83 cubic metres]).
     * @return this.grossTonnageGRT Integer
     */
    public Integer getGrossTonnageGRT()
    {
        return this.grossTonnageGRT;
    }

    /**
     * Tonnage du navire, ou jauge Brute, exprimé en TJB (Tonnage de Jauge Brute), et multiplié par
     * 100.
     * ------
     * Tonnage (GRT) 'Gross Registered Tonnage' en accord avec la convention d'Oslo (1947) (en
     * emploi en France jusqu'en 1995, toujours utilisé dans certains pays).
     * (GRT represent the total cubic measured content of the permanently enclosed spaces of a
     * vessel, with some allowances or deductions for exempt spaces such as living quarters [1 gross
     * register ton = 100 cubic feet = 2.83 cubic metres]).
     * @param grossTonnageGRTIn Integer
     */
    public void setGrossTonnageGRT(Integer grossTonnageGRTIn)
    {
        this.grossTonnageGRT = grossTonnageGRTIn;
    }

    private Integer lengthOverAll;

    /**
     * Longueur hors tout (Length OverAll) en cm du navire pour la période début-fin.
     * Définie selon le règlement (CEE) no 2930/86.
     * @return this.lengthOverAll Integer
     */
    public Integer getLengthOverAll()
    {
        return this.lengthOverAll;
    }

    /**
     * Longueur hors tout (Length OverAll) en cm du navire pour la période début-fin.
     * Définie selon le règlement (CEE) no 2930/86.
     * @param lengthOverAllIn Integer
     */
    public void setLengthOverAll(Integer lengthOverAllIn)
    {
        this.lengthOverAll = lengthOverAllIn;
    }

    private Integer lengthBeetweenPerpendiculars;

    /**
     * Longueur entre perpendiculaires (Length Between Perpendiculars) en cm.
     * Définie selon le règlement (CEE) no 2930/86.
     * @return this.lengthBeetweenPerpendiculars Integer
     */
    public Integer getLengthBeetweenPerpendiculars()
    {
        return this.lengthBeetweenPerpendiculars;
    }

    /**
     * Longueur entre perpendiculaires (Length Between Perpendiculars) en cm.
     * Définie selon le règlement (CEE) no 2930/86.
     * @param lengthBeetweenPerpendicularsIn Integer
     */
    public void setLengthBeetweenPerpendiculars(Integer lengthBeetweenPerpendicularsIn)
    {
        this.lengthBeetweenPerpendiculars = lengthBeetweenPerpendicularsIn;
    }

    private Integer constructionYear;

    /**
     * Année de construction du navire
     * @return this.constructionYear Integer
     */
    public Integer getConstructionYear()
    {
        return this.constructionYear;
    }

    /**
     * Année de construction du navire
     * @param constructionYearIn Integer
     */
    public void setConstructionYear(Integer constructionYearIn)
    {
        this.constructionYear = constructionYearIn;
    }

    private String IRCS;

    /**
     * Indicatif radio international du navire (IRCS)
     * @return this.IRCS String
     */
    public String getIRCS()
    {
        return this.IRCS;
    }

    /**
     * Indicatif radio international du navire (IRCS)
     * @param IRCSIn String
     */
    public void setIRCS(String IRCSIn)
    {
        this.IRCS = IRCSIn;
    }

    private Boolean hasVMS;

    /**
     * indique si le navire dispose d'un système VMS ou non.
     * @return this.hasVMS Boolean
     */
    public Boolean getHasVMS()
    {
        return this.hasVMS;
    }

    /**
     * indique si le navire dispose d'un système VMS ou non.
     * @param hasVMSIn Boolean
     */
    public void setHasVMS(Boolean hasVMSIn)
    {
        this.hasVMS = hasVMSIn;
    }

    private Boolean isFPC = Boolean.valueOf(false);

    /**
     * Indique si le navire est inscrit au fichier FPC ou non.
     * @return this.isFPC Boolean
     */
    public Boolean isIsFPC()
    {
        return this.isFPC;
    }

    /**
     * Indique si le navire est inscrit au fichier FPC ou non.
     * @param isFPCIn Boolean
     */
    public void setIsFPC(Boolean isFPCIn)
    {
        this.isFPC = isFPCIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 3 associations
    private Location basePortLocation;

    /**
     * Base port
     * see http://www.fao.org/fi/glossary/default.asp
     * FAO (1998): Guidelines for the routine collection of capture fishery data. FAO Fish. Tech.
     * Pap, 382: 113 p
     * @return this.basePortLocation Location
     */
    public Location getBasePortLocation()
    {
        return this.basePortLocation;
    }

    /**
     * Base port
     * see http://www.fao.org/fi/glossary/default.asp
     * FAO (1998): Guidelines for the routine collection of capture fishery data. FAO Fish. Tech.
     * Pap, 382: 113 p
     * @param basePortLocationIn Location
     */
    public void setBasePortLocation(Location basePortLocationIn)
    {
        this.basePortLocation = basePortLocationIn;
    }

    private QualitativeValue hullMaterial;

    /**
     * Matériausx de la coque (ex : Bois, Métal, Plastique, etc).
     * cf PMFM "HULL_METRIAL".
     * @return this.hullMaterial QualitativeValue
     */
    public QualitativeValue getHullMaterial()
    {
        return this.hullMaterial;
    }

    /**
     * Matériausx de la coque (ex : Bois, Métal, Plastique, etc).
     * cf PMFM "HULL_METRIAL".
     * @param hullMaterialIn QualitativeValue
     */
    public void setHullMaterial(QualitativeValue hullMaterialIn)
    {
        this.hullMaterial = hullMaterialIn;
    }

    private Vessel vessel;

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    /**
     * Returns <code>true</code> if the argument is an VesselFeatures instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof VesselFeatures))
        {
            return false;
        }
        final VesselFeatures that = (VesselFeatures)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link VesselFeatures}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link VesselFeatures}.
         * @return new VesselFeaturesImpl()
         */
        public static VesselFeatures newInstance()
        {
            return new VesselFeaturesImpl();
        }

        /**
         * Constructs a new instance of {@link VesselFeatures}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param startDateTime Date
         * @param isFPC Boolean
         * @param vessel Vessel
         * @return newInstance
         */
        public static VesselFeatures newInstance(Date startDateTime, Boolean isFPC, Vessel vessel)
        {
            final VesselFeatures entity = new VesselFeaturesImpl();
            entity.setStartDateTime(startDateTime);
            entity.setIsFPC(isFPC);
            entity.setVessel(vessel);
            return entity;
        }

        /**
         * Constructs a new instance of {@link VesselFeatures}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param startDateTime Date
         * @param endDateTime Date
         * @param name String
         * @param exteriorMarking String
         * @param administrativePower Float
         * @param auxiliaryPower Float
         * @param grossTonnageGT Integer
         * @param grossTonnageGRT Integer
         * @param lengthOverAll Integer
         * @param lengthBeetweenPerpendiculars Integer
         * @param constructionYear Integer
         * @param IRCS String
         * @param hasVMS Boolean
         * @param isFPC Boolean
         * @param updateDate Timestamp
         * @param basePortLocation Location
         * @param hullMaterial QualitativeValue
         * @param vessel Vessel
         * @return newInstance VesselFeatures
         */
        public static VesselFeatures newInstance(Date startDateTime, Date endDateTime, String name, String exteriorMarking, Float administrativePower, Float auxiliaryPower, Integer grossTonnageGT, Integer grossTonnageGRT, Integer lengthOverAll, Integer lengthBeetweenPerpendiculars, Integer constructionYear, String IRCS, Boolean hasVMS, Boolean isFPC, Timestamp updateDate, Location basePortLocation, QualitativeValue hullMaterial, Vessel vessel)
        {
            final VesselFeatures entity = new VesselFeaturesImpl();
            entity.setStartDateTime(startDateTime);
            entity.setEndDateTime(endDateTime);
            entity.setName(name);
            entity.setExteriorMarking(exteriorMarking);
            entity.setAdministrativePower(administrativePower);
            entity.setAuxiliaryPower(auxiliaryPower);
            entity.setGrossTonnageGT(grossTonnageGT);
            entity.setGrossTonnageGRT(grossTonnageGRT);
            entity.setLengthOverAll(lengthOverAll);
            entity.setLengthBeetweenPerpendiculars(lengthBeetweenPerpendiculars);
            entity.setConstructionYear(constructionYear);
            entity.setIRCS(IRCS);
            entity.setHasVMS(hasVMS);
            entity.setIsFPC(isFPC);
            entity.setUpdateDate(updateDate);
            entity.setBasePortLocation(basePortLocation);
            entity.setHullMaterial(hullMaterial);
            entity.setVessel(vessel);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(VesselFeatures o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getStartDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getStartDateTime().compareTo(o.getStartDateTime()));
            }
            if (this.getEndDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getEndDateTime().compareTo(o.getEndDateTime()));
            }
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getExteriorMarking() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getExteriorMarking().compareTo(o.getExteriorMarking()));
            }
            if (this.getAdministrativePower() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getAdministrativePower().compareTo(o.getAdministrativePower()));
            }
            if (this.getAuxiliaryPower() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getAuxiliaryPower().compareTo(o.getAuxiliaryPower()));
            }
            if (this.getGrossTonnageGT() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getGrossTonnageGT().compareTo(o.getGrossTonnageGT()));
            }
            if (this.getGrossTonnageGRT() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getGrossTonnageGRT().compareTo(o.getGrossTonnageGRT()));
            }
            if (this.getLengthOverAll() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLengthOverAll().compareTo(o.getLengthOverAll()));
            }
            if (this.getLengthBeetweenPerpendiculars() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLengthBeetweenPerpendiculars().compareTo(o.getLengthBeetweenPerpendiculars()));
            }
            if (this.getConstructionYear() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getConstructionYear().compareTo(o.getConstructionYear()));
            }
            if (this.getIRCS() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getIRCS().compareTo(o.getIRCS()));
            }
            if (this.getHasVMS() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getHasVMS().compareTo(o.getHasVMS()));
            }
            if (this.isIsFPC() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsFPC().compareTo(o.isIsFPC()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// VesselFeatures.java merge-point
}