/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import org.eclipse.birt.data.engine.olap.cursor.EdgeDimensionRelation;

class EdgeTraverse {
    int currentPosition = -1;
    int curPosOnMap;
    private EdgeDimensionRelation relationMap;
    private int edgeStart;
    private int edgeEnd;
    private int traverseLength;

    EdgeTraverse(EdgeDimensionRelation relationMap) {
        this.relationMap = relationMap;
        this.edgeStart = 0;
        this.edgeEnd = relationMap.traverseLength - 1;
        this.traverseLength = this.relationMap.traverseLength;
    }

    EdgeTraverse(EdgeDimensionRelation relationMap, int edgeStart, int edgeEnd) {
        this(relationMap);
        this.edgeStart = edgeStart;
        this.edgeEnd = edgeEnd;
        this.traverseLength = edgeEnd - edgeStart + 1;
    }

    void afterLast() {
        this.curPosOnMap = this.edgeEnd + 1;
        this.currentPosition = this.traverseLength;
    }

    void beforeFirst() {
        this.curPosOnMap = this.edgeStart - 1;
        this.currentPosition = -1;
    }

    boolean first() {
        if (this.traverseLength > 0) {
            this.currentPosition = 0;
            this.curPosOnMap = this.edgeStart;
            return true;
        }
        return false;
    }

    int getEdgePostion() {
        return this.currentPosition;
    }

    boolean isAfterLast() {
        return this.currentPosition >= this.traverseLength;
    }

    boolean isBeforeFirst() {
        return this.currentPosition < 0;
    }

    boolean isFirst() {
        return this.currentPosition == 0;
    }

    boolean isLast() {
        return this.currentPosition == this.traverseLength - 1;
    }

    boolean last() {
        if (this.relationMap.traverseLength > 0) {
            this.currentPosition = this.traverseLength - 1;
            this.curPosOnMap = this.edgeEnd - 1;
            return true;
        }
        return false;
    }

    boolean next() {
        ++this.currentPosition;
        ++this.curPosOnMap;
        return this.currentPosition < this.traverseLength;
    }

    boolean previous() {
        --this.currentPosition;
        --this.curPosOnMap;
        if (this.currentPosition >= 0) {
            return true;
        }
        this.currentPosition = -1;
        return false;
    }

    boolean relative(int arg0) {
        if (arg0 == 0) {
            return true;
        }
        int position = this.currentPosition + arg0;
        if (position >= this.relationMap.traverseLength) {
            return false;
        }
        if (position < 0) {
            this.currentPosition = -1;
            this.curPosOnMap = this.edgeStart - 1;
            return false;
        }
        this.curPosOnMap += arg0;
        this.currentPosition = position;
        return true;
    }
}

