// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.transshipment;

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Transbordement d'un produit (capturé) d'un navire à l'autre.
 * Pour connaitre le navire d'origine des produits (celui qui les possédait avant le
 * transbordement), il faut utiliser les liens vers FishingTrip ou MetaFishingTrip, qui possèdent un
 * lien vers Vessel.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Transshipment
    implements Serializable, Comparable<Transshipment>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -6335551037480351483L;

    // Generate 10 attributes
    private Integer id;

    /**
     * Idenfiant interne. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Idenfiant interne. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Date transshipmentDateTime;

    /**
     * Rang du transbordement, utilisé quand plusieurs transbordements ont eu lieu le meme jour pour
     * une meme navire, et que l'heure de landingDateTime ne permet pas de distinguer les
     * transbordements entre eux.
     * Utiliser pour SACAPT : l'ordre es alors celui de présence dans le fichier d'origine.
     * @return this.transshipmentDateTime Date
     */
    public Date getTransshipmentDateTime()
    {
        return this.transshipmentDateTime;
    }

    /**
     * Rang du transbordement, utilisé quand plusieurs transbordements ont eu lieu le meme jour pour
     * une meme navire, et que l'heure de landingDateTime ne permet pas de distinguer les
     * transbordements entre eux.
     * Utiliser pour SACAPT : l'ordre es alors celui de présence dans le fichier d'origine.
     * @param transshipmentDateTimeIn Date
     */
    public void setTransshipmentDateTime(Date transshipmentDateTimeIn)
    {
        this.transshipmentDateTime = transshipmentDateTimeIn;
    }

    private Short rankOrder;

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Rang du transbordement, utilis&#233; quand plusieurs transbordements ont
     * eu lieu le meme jour pour une meme navire, et que l'heure de <i>landingDateTime</i>
     * ne permet pas de distinguer les d&#233;barquement entre eux.<br><br>Utiliser
     * pour SACAPT : l'ordre es alors celui de pr&#233;sence dans le fichier
     * d'origine.
     * </p>
     * </body>
     * </html>
     * @return this.rankOrder Short
     */
    public Short getRankOrder()
    {
        return this.rankOrder;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Rang du transbordement, utilis&#233; quand plusieurs transbordements ont
     * eu lieu le meme jour pour une meme navire, et que l'heure de <i>landingDateTime</i>
     * ne permet pas de distinguer les d&#233;barquement entre eux.<br><br>Utiliser
     * pour SACAPT : l'ordre es alors celui de pr&#233;sence dans le fichier
     * d'origine.
     * </p>
     * </body>
     * </html>
     * @param rankOrderIn Short
     */
    public void setRankOrder(Short rankOrderIn)
    {
        this.rankOrder = rankOrderIn;
    }

    private String comments;

    /**
     * 
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * 
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Date creationDate;

    /**
     * 
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * 
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Date controlDate;

    /**
     * 
     * @return this.controlDate Date
     */
    public Date getControlDate()
    {
        return this.controlDate;
    }

    /**
     * 
     * @param controlDateIn Date
     */
    public void setControlDate(Date controlDateIn)
    {
        this.controlDate = controlDateIn;
    }

    private Date qualificationDate;

    /**
     * 
     * @return this.qualificationDate Date
     */
    public Date getQualificationDate()
    {
        return this.qualificationDate;
    }

    /**
     * 
     * @param qualificationDateIn Date
     */
    public void setQualificationDate(Date qualificationDateIn)
    {
        this.qualificationDate = qualificationDateIn;
    }

    private String qualificationComments;

    /**
     * 
     * @return this.qualificationComments String
     */
    public String getQualificationComments()
    {
        return this.qualificationComments;
    }

    /**
     * 
     * @param qualificationCommentsIn String
     */
    public void setQualificationComments(String qualificationCommentsIn)
    {
        this.qualificationComments = qualificationCommentsIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 10 associations
    private Vessel toVessel;

    /**
     * Navire vers lequel le transbordement a été réalisé.
     * @return this.toVessel Vessel
     */
    public Vessel getToVessel()
    {
        return this.toVessel;
    }

    /**
     * Navire vers lequel le transbordement a été réalisé.
     * @param toVesselIn Vessel
     */
    public void setToVessel(Vessel toVesselIn)
    {
        this.toVessel = toVesselIn;
    }

    private Location transshipmentLocation;

    /**
     * Zone ou port dans lequel se fait le transbordement.
     * Non renseigné dans SACAPT
     * @return this.transshipmentLocation Location
     */
    public Location getTransshipmentLocation()
    {
        return this.transshipmentLocation;
    }

    /**
     * Zone ou port dans lequel se fait le transbordement.
     * Non renseigné dans SACAPT
     * @param transshipmentLocationIn Location
     */
    public void setTransshipmentLocation(Location transshipmentLocationIn)
    {
        this.transshipmentLocation = transshipmentLocationIn;
    }

    private QualityFlag qualityFlag;

    /**
     * Indice qualité d'une donnée.
     * Actuellement, les indices qualités identifiés sont :
     * 0 - Non qualifiée,
     * 1 - Bonne,
     * 2 - Hors statistiques,
     * 3 - Douteuse,
     * 4 - Fausse,
     * 5 - Corrigée,
     * 8 - Incomplète,
     * 9 - Absente.
     * @return this.qualityFlag QualityFlag
     */
    public QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    /**
     * Indice qualité d'une donnée.
     * Actuellement, les indices qualités identifiés sont :
     * 0 - Non qualifiée,
     * 1 - Bonne,
     * 2 - Hors statistiques,
     * 3 - Douteuse,
     * 4 - Fausse,
     * 5 - Corrigée,
     * 8 - Incomplète,
     * 9 - Absente.
     * @param qualityFlagIn QualityFlag
     */
    public void setQualityFlag(QualityFlag qualityFlagIn)
    {
        this.qualityFlag = qualityFlagIn;
    }

    private Department recorderDepartment;

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @return this.recorderDepartment Department
     */
    public Department getRecorderDepartment()
    {
        return this.recorderDepartment;
    }

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @param recorderDepartmentIn Department
     */
    public void setRecorderDepartment(Department recorderDepartmentIn)
    {
        this.recorderDepartment = recorderDepartmentIn;
    }

    private Vessel fromVessel;

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @return this.fromVessel Vessel
     */
    public Vessel getFromVessel()
    {
        return this.fromVessel;
    }

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @param fromVesselIn Vessel
     */
    public void setFromVessel(Vessel fromVesselIn)
    {
        this.fromVessel = fromVesselIn;
    }

    private Person recorderPerson;

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.recorderPerson Person
     */
    public Person getRecorderPerson()
    {
        return this.recorderPerson;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param recorderPersonIn Person
     */
    public void setRecorderPerson(Person recorderPersonIn)
    {
        this.recorderPerson = recorderPersonIn;
    }

    private FishingTrip fishingTrip;

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @return this.fishingTrip FishingTrip
     */
    public FishingTrip getFishingTrip()
    {
        return this.fishingTrip;
    }

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @param fishingTripIn FishingTrip
     */
    public void setFishingTrip(FishingTrip fishingTripIn)
    {
        this.fishingTrip = fishingTripIn;
    }

    private Collection<Produce> produces = new HashSet<Produce>();

    /**
     * Listes de produits transbordés.
     * @return this.produces Collection<Produce>
     */
    public Collection<Produce> getProduces()
    {
        return this.produces;
    }

    /**
     * Listes de produits transbordés.
     * @param producesIn Collection<Produce>
     */
    public void setProduces(Collection<Produce> producesIn)
    {
        this.produces = producesIn;
    }

    /**
     * Listes de produits transbordés.
     * @param elementToAdd Produce
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addProduces(Produce elementToAdd)
    {
        return this.produces.add(elementToAdd);
    }

    /**
     * Listes de produits transbordés.
     * @param elementToRemove Produce
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeProduces(Produce elementToRemove)
    {
        return this.produces.remove(elementToRemove);
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private Collection<SurveyMeasurement> surveyMeasurements = new HashSet<SurveyMeasurement>();

    /**
     * 
     * @return this.surveyMeasurements Collection<SurveyMeasurement>
     */
    public Collection<SurveyMeasurement> getSurveyMeasurements()
    {
        return this.surveyMeasurements;
    }

    /**
     * 
     * @param surveyMeasurementsIn Collection<SurveyMeasurement>
     */
    public void setSurveyMeasurements(Collection<SurveyMeasurement> surveyMeasurementsIn)
    {
        this.surveyMeasurements = surveyMeasurementsIn;
    }

    /**
     * 
     * @param elementToAdd SurveyMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSurveyMeasurements(SurveyMeasurement elementToAdd)
    {
        return this.surveyMeasurements.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove SurveyMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSurveyMeasurements(SurveyMeasurement elementToRemove)
    {
        return this.surveyMeasurements.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an Transshipment instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Transshipment))
        {
            return false;
        }
        final Transshipment that = (Transshipment)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Transshipment}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Transshipment}.
         * @return new TransshipmentImpl()
         */
        public static Transshipment newInstance()
        {
            return new TransshipmentImpl();
        }

        /**
         * Constructs a new instance of {@link Transshipment}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param transshipmentDateTime Date
         * @param creationDate Date
         * @param toVessel Vessel
         * @param qualityFlag QualityFlag
         * @param recorderDepartment Department
         * @param fromVessel Vessel
         * @param program Program
         * @return newInstance
         */
        public static Transshipment newInstance(Date transshipmentDateTime, Date creationDate, Vessel toVessel, QualityFlag qualityFlag, Department recorderDepartment, Vessel fromVessel, Program program)
        {
            final Transshipment entity = new TransshipmentImpl();
            entity.setTransshipmentDateTime(transshipmentDateTime);
            entity.setCreationDate(creationDate);
            entity.setToVessel(toVessel);
            entity.setQualityFlag(qualityFlag);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setFromVessel(fromVessel);
            entity.setProgram(program);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Transshipment}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param transshipmentDateTime Date
         * @param rankOrder Short
         * @param comments String
         * @param creationDate Date
         * @param controlDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param toVessel Vessel
         * @param transshipmentLocation Location
         * @param qualityFlag QualityFlag
         * @param recorderDepartment Department
         * @param fromVessel Vessel
         * @param recorderPerson Person
         * @param fishingTrip FishingTrip
         * @param produces Collection<Produce>
         * @param program Program
         * @param surveyMeasurements Collection<SurveyMeasurement>
         * @return newInstance Transshipment
         */
        public static Transshipment newInstance(Date transshipmentDateTime, Short rankOrder, String comments, Date creationDate, Date controlDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Integer remoteId, Vessel toVessel, Location transshipmentLocation, QualityFlag qualityFlag, Department recorderDepartment, Vessel fromVessel, Person recorderPerson, FishingTrip fishingTrip, Collection<Produce> produces, Program program, Collection<SurveyMeasurement> surveyMeasurements)
        {
            final Transshipment entity = new TransshipmentImpl();
            entity.setTransshipmentDateTime(transshipmentDateTime);
            entity.setRankOrder(rankOrder);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setToVessel(toVessel);
            entity.setTransshipmentLocation(transshipmentLocation);
            entity.setQualityFlag(qualityFlag);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setFromVessel(fromVessel);
            entity.setRecorderPerson(recorderPerson);
            entity.setFishingTrip(fishingTrip);
            entity.setProduces(produces);
            entity.setProgram(program);
            entity.setSurveyMeasurements(surveyMeasurements);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Transshipment o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getTransshipmentDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getTransshipmentDateTime().compareTo(o.getTransshipmentDateTime()));
            }
            if (this.getRankOrder() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRankOrder().compareTo(o.getRankOrder()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getControlDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getControlDate().compareTo(o.getControlDate()));
            }
            if (this.getQualificationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationDate().compareTo(o.getQualificationDate()));
            }
            if (this.getQualificationComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationComments().compareTo(o.getQualificationComments()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Transshipment.java merge-point
}