/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.svggen.DefaultCachedImageHandler;
import org.apache.batik.svggen.ImageCacher;
import org.apache.batik.svggen.SVGGraphics2DIOException;

public class CachedImageHandlerJPEGEncoder
extends DefaultCachedImageHandler {
    public static final String CACHED_JPEG_PREFIX = "jpegImage";
    public static final String CACHED_JPEG_SUFFIX = ".jpg";
    protected String refPrefix = "";

    public CachedImageHandlerJPEGEncoder(String string, String string2) throws SVGGraphics2DIOException {
        this.refPrefix = string2 + "/";
        this.setImageCacher(new ImageCacher.External(string, CACHED_JPEG_PREFIX, CACHED_JPEG_SUFFIX));
    }

    public void encodeImage(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
        JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
        jPEGEncodeParam.setQuality(1.0f, false);
        jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
    }

    public int getBufferedImageType() {
        return 1;
    }

    public String getRefPrefix() {
        return this.refPrefix;
    }
}

