/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.awt.Component;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveBenthosBatchAction
extends LongActionSupport<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {
    protected int rowIndex;
    protected Set<BenthosBatchRowModel> rowToRemove;

    public RemoveBenthosBatchAction(BenthosBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        this.rowIndex = -1;
        if (result) {
            int answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), I18n.t((String)"tutti.editBenthosBatch.action.removeBatch.confirm.message", (Object[])new Object[0]), I18n.t((String)"tutti.editBenthosBatch.action.removeBatch.confirm.title", (Object[])new Object[0]), 0);
            result = answer == 0;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        JXTable table = ((BenthosBatchUIHandler)this.handler).getTable();
        this.rowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        Preconditions.checkState((this.rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove batch if no batch selected");
        BenthosBatchTableModel tableModel = ((BenthosBatchUIHandler)this.handler).getTableModel();
        BenthosBatchRowModel selectedBatch = (BenthosBatchRowModel)tableModel.getEntry(this.rowIndex);
        Preconditions.checkState((!TuttiEntities.isNew(selectedBatch) ? 1 : 0) != 0, (Object)"Can't remove batch if batch is not persisted");
        persistenceService.deleteBenthosBatch(selectedBatch.getId());
        if (selectedBatch.isBatchRoot()) {
            ((BenthosBatchUIHandler)this.handler).removeFromSpeciesUsed(selectedBatch);
        } else {
            BenthosBatchRowModel parentBatch = selectedBatch.getParentBatch();
            parentBatch.getChildBatch().remove(selectedBatch);
        }
        this.rowToRemove = Sets.newHashSet();
        this.rowToRemove.add(selectedBatch);
        ((BenthosBatchUIHandler)this.handler).collectChildren(selectedBatch, this.rowToRemove);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        JXTable table = ((BenthosBatchUIHandler)this.handler).getTable();
        ((BenthosBatchUIModel)this.getModel()).getRows().removeAll(this.rowToRemove);
        ((BenthosBatchUIHandler)this.handler).getTableModel().fireTableDataChanged();
        TuttiUIUtil.selectFirstCellOnFirstRowAndStopEditing((JXTable)table);
    }
}

