/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.export.toconfirmreport.ToConfirmReportService;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.actions.AbstractMainUITuttiAction;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SpeciesToConfirmReportForCruiseAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(SpeciesToConfirmReportForCruiseAction.class);
    public static final DateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
    protected File file;

    public SpeciesToConfirmReportForCruiseAction(MainUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            Cruise cruise = this.getDataContext().getCruise();
            String now = df.format(new Date());
            this.file = this.saveFile(I18n.t((String)"tutti.speciesToConfirmReport.fileName.default", (Object[])new Object[]{cruise.getName(), now}), "pdf", I18n.t((String)"tutti.speciesToConfirmReport.title.choose.exportFile", (Object[])new Object[0]), I18n.t((String)"tutti.speciesToConfirmReport.action.chooseFile", (Object[])new Object[0]), new String[]{"^.+\\.pdf$", I18n.t((String)"tutti.common.file.pdf", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Cruise cruise = this.getDataContext().getCruise();
        Preconditions.checkNotNull((Object)cruise);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export cruise " + cruise.getId() + " to file: " + this.file));
        }
        ToConfirmReportService toConfirmReportService = this.getContext().getToConfirmReportService();
        int nbSteps = toConfirmReportService.getNumberOfSteps(this.getDataContext().getCruiseId());
        this.createProgressionModelIfRequired(1);
        ProgressionModel progressionModel = this.getProgressionModel();
        progressionModel.adaptTotal(nbSteps);
        toConfirmReportService.createToConfirmReport(this.file, cruise.getId(), progressionModel);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.sendCruiseReport.action.success", (Object[])new Object[]{this.file}));
    }
}

