/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Gears;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Persons;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Vessels;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.referential.GearModel;
import fr.ifremer.tutti.service.referential.GearRow;
import fr.ifremer.tutti.service.referential.PersonModel;
import fr.ifremer.tutti.service.referential.PersonRow;
import fr.ifremer.tutti.service.referential.SpeciesModel;
import fr.ifremer.tutti.service.referential.SpeciesRow;
import fr.ifremer.tutti.service.referential.VesselModel;
import fr.ifremer.tutti.service.referential.VesselRow;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ReferentialExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ReferentialExportService.class);
    protected PersistenceService persistenceService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
    }

    public void exportExistingTemporarySpecies(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Getting all species from database");
        }
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllReferentSpecies());
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + targetList.size() + " species"));
        }
        List<Species> toExport = this.persistenceService.retainTemporarySpeciesList(targetList);
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + toExport.size() + " temporary species"));
        }
        this.exportTemporarySpecies(file, toExport);
    }

    public void exportTemporarySpeciesExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Species s = Speciess.newSpecies();
        s.setName("Temporary Species name 1");
        toExport.add(s);
        s = Speciess.newSpecies();
        s.setName("Temporary Species name 2");
        toExport.add(s);
        s = Speciess.newSpecies();
        s.setName("Temporary Species name 3");
        toExport.add(s);
        this.exportTemporarySpecies(file, toExport);
    }

    protected void exportTemporarySpecies(File file, List<Species> toExport) throws IOException {
        SpeciesModel csvModel = new SpeciesModel(this.getCsvSeparator());
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        List toExportRows = Lists.transform(toExport, (Function)new Function<Species, SpeciesRow>(){

            public SpeciesRow apply(Species species) {
                return new SpeciesRow(species);
            }
        });
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExportRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.species.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public void exportExistingTemporaryVessel(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Getting all vessels from database");
        }
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllFishingVessel());
        targetList.addAll(this.persistenceService.getAllScientificVessel());
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + targetList.size() + " vessels"));
        }
        List<Vessel> toExport = this.persistenceService.retainTemporaryVesselList(targetList);
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + toExport.size() + " temporary vessels"));
        }
        this.exportTemporaryVessel(file, toExport);
    }

    public void exportTemporaryVesselExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Vessel v = Vessels.newVessel();
        v.setRegistrationCode("RegCode1");
        v.setName("Temporary fishing vessel name 1");
        v.setInternationalRegistrationCode("International registration code F1");
        v.setScientificVessel(false);
        toExport.add(v);
        v = Vessels.newVessel();
        v.setRegistrationCode("RegCode2");
        v.setName("Temporary fishing vessel name 2");
        v.setInternationalRegistrationCode("International registration code F2");
        v.setScientificVessel(false);
        toExport.add(v);
        v = Vessels.newVessel();
        v.setRegistrationCode("RegCode3");
        v.setName("Temporary scientific vessel name 3");
        v.setInternationalRegistrationCode("International registration code S3");
        v.setScientificVessel(true);
        toExport.add(v);
        v = Vessels.newVessel();
        v.setRegistrationCode("RegCode4");
        v.setName("Temporary scientific vessel name 4");
        v.setInternationalRegistrationCode("International registration code S4");
        v.setScientificVessel(true);
        toExport.add(v);
        this.exportTemporaryVessel(file, toExport);
    }

    protected void exportTemporaryVessel(File file, List<Vessel> toExport) throws IOException {
        VesselModel csvModel = new VesselModel(this.getCsvSeparator());
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        List toExportRows = Lists.transform(toExport, (Function)new Function<Vessel, VesselRow>(){

            public VesselRow apply(Vessel vessel) {
                return new VesselRow(vessel);
            }
        });
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExportRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.vessel.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public void exportExistingTemporaryPerson(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Getting all persons from database");
        }
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllPerson());
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + targetList.size() + " persons"));
        }
        List<Person> toExport = this.persistenceService.retainTemporaryPersonList(targetList);
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + toExport.size() + " temporary persons"));
        }
        this.exportTemporaryPerson(file, toExport);
    }

    public void exportTemporaryPersonExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Person p = Persons.newPerson();
        p.setFirstName("First name 1");
        p.setLastName("Last name 1");
        toExport.add(p);
        p = Persons.newPerson();
        p.setFirstName("First name 2");
        p.setLastName("Last name 2");
        toExport.add(p);
        p = Persons.newPerson();
        p.setFirstName("First name 3");
        p.setLastName("Last name 3");
        toExport.add(p);
        this.exportTemporaryPerson(file, toExport);
    }

    protected void exportTemporaryPerson(File file, List<Person> toExport) throws IOException {
        PersonModel csvModel = new PersonModel(this.getCsvSeparator());
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        List toExportRows = Lists.transform(toExport, (Function)new Function<Person, PersonRow>(){

            public PersonRow apply(Person person) {
                return new PersonRow(person);
            }
        });
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExportRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.person.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public void exportExistingTemporaryGear(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Getting all gears from database");
        }
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllFishingGear());
        targetList.addAll(this.persistenceService.getAllScientificGear());
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + targetList.size() + " gears"));
        }
        List<Gear> toExport = this.persistenceService.retainTemporaryGearList(targetList);
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + toExport.size() + " temporary gears"));
        }
        this.exportTemporaryGear(file, toExport);
    }

    public void exportTemporaryGearExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Gear g = Gears.newGear();
        g.setName("Gear fishing name 1");
        g.setLabel("Gear fishing label 1");
        toExport.add(g);
        g = Gears.newGear();
        g.setName("Gear fishing name 2");
        g.setLabel("Gear fishing label 2");
        toExport.add(g);
        g = Gears.newGear();
        g.setName("Gear scientific name 3");
        g.setLabel("Gear scientific label 3");
        g.setScientificGear(true);
        toExport.add(g);
        g = Gears.newGear();
        g.setName("Gear scientific name 4");
        g.setLabel("Gear scientific label 4");
        g.setScientificGear(true);
        toExport.add(g);
        this.exportTemporaryGear(file, toExport);
    }

    protected void exportTemporaryGear(File file, List<Gear> toExport) throws IOException {
        GearModel csvModel = new GearModel(this.getCsvSeparator());
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        List toExportRows = Lists.transform(toExport, (Function)new Function<Gear, GearRow>(){

            public GearRow apply(Gear gear) {
                return new GearRow(gear);
            }
        });
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExportRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.gear.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected char getCsvSeparator() {
        return this.context.getConfig().getCsvSeparator();
    }
}

