/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.cache;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileSystemAndNameKey
implements Comparable<FileSystemAndNameKey> {
    private final FileSystem fileSystem;
    private final FileName fileName;
    private final int fileSystemId;

    FileSystemAndNameKey(FileSystem fileSystem, FileName fileName) {
        this.fileSystem = fileSystem;
        this.fileSystemId = System.identityHashCode(fileSystem);
        this.fileName = fileName;
    }

    @Override
    public int compareTo(FileSystemAndNameKey other) {
        if (this.fileSystemId < other.fileSystemId) {
            return -1;
        }
        if (this.fileSystemId > other.fileSystemId) {
            return 1;
        }
        return this.fileName.compareTo(other.fileName);
    }

    FileSystem getFileSystem() {
        return this.fileSystem;
    }

    FileName getFileName() {
        return this.fileName;
    }
}

