/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SelectedCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateBenthosBatchUIModel
extends AbstractTuttiTableUIModel<CreateBenthosBatchUIModel, SplitBenthosBatchRowModel, CreateBenthosBatchUIModel>
implements SelectedCategoryAble {
    private static final Log log = LogFactory.getLog(CreateBenthosBatchUIModel.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_AVAILABLE_SPECIES = "availableSpecies";
    public static final String PROPERTY_SPECIES = "species";
    public static final String PROPERTY_SAMPLE_CATEGORY = "sampleCategory";
    public static final String PROPERTY_BATCH_WEIGHT = "batchWeight";
    public static final String PROPERTY_BATCH_COUNT = "batchCount";
    public static final String PROPERTY_CATEGORY = "category";
    public static final String PROPERTY_SELECTED_CATEGORY = "selectedCategory";
    public static final String PROPERTY_SAMPLE_WEIGHT = "sampleWeight";
    protected List<Species> availableSpecies;
    protected Species species;
    protected CaracteristicQualitativeValue sampleCategory;
    protected Float batchWeight;
    protected Integer batchCount;
    protected List<SampleCategoryModelEntry> category;
    protected SampleCategoryModelEntry selectedCategory;
    protected Float sampleWeight;
    protected SampleCategoryModel sampleCategoryModel;
    protected final Multimap<CaracteristicQualitativeValue, Species> speciesUsed = ArrayListMultimap.create();

    public CreateBenthosBatchUIModel(SampleCategoryModel sampleCategoryModel) {
        super(CreateBenthosBatchUIModel.class, null, null);
        this.sampleCategoryModel = sampleCategoryModel;
    }

    public SampleCategoryModel getSampleCategoryModel() {
        return this.sampleCategoryModel;
    }

    public List<Species> getAvailableSpecies() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAvailableSpecies " + this.availableSpecies));
        }
        return this.availableSpecies;
    }

    public void setAvailableSpecies(List<Species> availableSpecies) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setAvailableSpecies " + availableSpecies));
        }
        List<Species> oldValue = this.getAvailableSpecies();
        this.availableSpecies = availableSpecies;
        this.firePropertyChange(PROPERTY_AVAILABLE_SPECIES, oldValue, availableSpecies);
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        Species oldSpecies = this.getSpecies();
        this.species = species;
        this.firePropertyChange(PROPERTY_SPECIES, oldSpecies, this.getSpecies());
    }

    public CaracteristicQualitativeValue getSampleCategory() {
        return this.sampleCategory;
    }

    public void setSampleCategory(CaracteristicQualitativeValue sampleCategory) {
        CaracteristicQualitativeValue oldValue = this.getSampleCategory();
        this.sampleCategory = sampleCategory;
        this.firePropertyChange(PROPERTY_SAMPLE_CATEGORY, oldValue, sampleCategory);
    }

    public Float getBatchWeight() {
        return this.batchWeight;
    }

    public void setBatchWeight(Float batchWeight) {
        Float oldValue = this.getBatchWeight();
        this.batchWeight = batchWeight;
        this.firePropertyChange(PROPERTY_BATCH_WEIGHT, oldValue, batchWeight);
    }

    public Integer getBatchCount() {
        return this.batchCount;
    }

    public void setBatchCount(Integer batchCount) {
        Integer oldValue = this.getBatchCount();
        this.batchCount = batchCount;
        this.firePropertyChange(PROPERTY_BATCH_COUNT, oldValue, batchCount);
    }

    public List<SampleCategoryModelEntry> getCategory() {
        return this.category;
    }

    public void setCategory(List<SampleCategoryModelEntry> category) {
        List<SampleCategoryModelEntry> oldValue = this.getCategory();
        this.category = category;
        this.firePropertyChange(PROPERTY_CATEGORY, oldValue, category);
    }

    @Override
    public SampleCategoryModelEntry getSelectedCategory() {
        return this.selectedCategory;
    }

    public void setSelectedCategory(SampleCategoryModelEntry selectedCategory) {
        SampleCategoryModelEntry oldValue = this.getSelectedCategory();
        this.selectedCategory = selectedCategory;
        this.firePropertyChange(PROPERTY_SELECTED_CATEGORY, oldValue, selectedCategory);
    }

    public Float getSampleWeight() {
        return this.sampleWeight;
    }

    public void setSampleWeight(Float sampleWeight) {
        Float oldValue = this.getSampleWeight();
        this.sampleWeight = sampleWeight;
        this.firePropertyChange(PROPERTY_SAMPLE_WEIGHT, oldValue, sampleWeight);
    }

    public Multimap<CaracteristicQualitativeValue, Species> getSpeciesUsed() {
        return this.speciesUsed;
    }

    public boolean isSpeciesAndCategoryAvailable() {
        boolean result = this.species != null && this.sampleCategory != null && this.isSpeciesAndCategoryAvailable(this.species, this.sampleCategory);
        return result;
    }

    public boolean isSpeciesAndCategoryAvailable(Species species, CaracteristicQualitativeValue value) {
        boolean result = !this.speciesUsed.containsEntry((Object)value, (Object)species);
        return result;
    }

    public boolean isCategoryIsFilled() {
        boolean result;
        boolean bl = result = this.selectedCategory != null;
        if (result) {
            result = false;
            for (SplitBenthosBatchRowModel rowModel : this.getRows()) {
                if (!rowModel.isValid()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    protected CreateBenthosBatchUIModel newEntity() {
        return new CreateBenthosBatchUIModel(this.sampleCategoryModel);
    }
}

