/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ichtyometer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intel.bluetooth.BlueCoveImpl;
import fr.ifremer.tutti.ichtyometer.LocalDeviceNotFoundException;
import fr.ifremer.tutti.ichtyometer.RemoteDeviceChooser;
import fr.ifremer.tutti.ichtyometer.RemoteDeviceNotFoundException;
import fr.ifremer.tutti.ichtyometer.RemoteDeviceServiceNotFoundException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IchtyometerClient
implements Closeable {
    private static final Log log = LogFactory.getLog(IchtyometerClient.class);
    protected static Map<String, RemoteDevice> REMOTE_DEVICE_CACHE;
    protected static Map<String, String> REMOTE_CONNECTION_URL_CACHE;
    protected LocalDevice localDevice;
    protected final Set<StreamConnection> connections = Sets.newHashSet();
    protected RemoteDevice remoteDevice;
    protected String connectionUrl;
    protected boolean open;
    protected String name;

    public static void clearRemoteDeviceCaches() {
        REMOTE_DEVICE_CACHE = null;
        REMOTE_CONNECTION_URL_CACHE = null;
    }

    public void open(RemoteDeviceChooser remoteDeviceChooser, boolean forceCompleteScan) throws IOException {
        Preconditions.checkState((!this.open ? 1 : 0) != 0, (Object)"Client is already opened");
        try {
            this.localDevice = LocalDevice.getLocalDevice();
        }
        catch (BluetoothStateException e) {
            throw new LocalDeviceNotFoundException();
        }
        if (forceCompleteScan || REMOTE_DEVICE_CACHE == null) {
            try {
                REMOTE_DEVICE_CACHE = this.discoverDevices();
            }
            catch (Exception e) {
                throw new RemoteDeviceNotFoundException("Could not detected devices", e);
            }
        }
        if (REMOTE_DEVICE_CACHE.isEmpty()) {
            throw new RemoteDeviceNotFoundException("No remote device found");
        }
        this.name = remoteDeviceChooser.chooseRemoteDevice(REMOTE_DEVICE_CACHE.keySet());
        if (this.name == null) {
            throw new RemoteDeviceNotFoundException("User did not choose a remote device");
        }
        this.remoteDevice = REMOTE_DEVICE_CACHE.get(this.name);
        if (this.remoteDevice == null) {
            throw new RemoteDeviceNotFoundException("Could not find remote device with name '" + this.name + "'");
        }
        if (forceCompleteScan || REMOTE_CONNECTION_URL_CACHE == null) {
            REMOTE_CONNECTION_URL_CACHE = Maps.newTreeMap();
        }
        if (!REMOTE_CONNECTION_URL_CACHE.containsKey(this.name)) {
            List<ServiceRecord> serviceRecords;
            int serviceIndex = 3;
            try {
                serviceRecords = this.discoverServiceUrls(new UUID((long)serviceIndex), this.remoteDevice);
            }
            catch (Exception e) {
                throw new RemoteDeviceNotFoundException("Could not read remote device services", e);
            }
            if (serviceRecords.isEmpty()) {
                throw new RemoteDeviceServiceNotFoundException("No services detected.");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Found some services for index: " + serviceIndex));
            }
            serviceRecords.addAll(serviceRecords);
            ServiceRecord serviceRecord = serviceRecords.get(0);
            String connectionUrl = serviceRecord.getConnectionURL(0, true);
            if (log.isInfoEnabled()) {
                log.info((Object)("Found service(" + serviceIndex + "): " + connectionUrl + ", name: " + this.name));
            }
            REMOTE_CONNECTION_URL_CACHE.put(this.name, connectionUrl);
        }
        this.connectionUrl = REMOTE_CONNECTION_URL_CACHE.get(this.name);
        this.open = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        try {
            for (StreamConnection connection : Sets.newHashSet(this.connections)) {
                this.closeConnection(connection);
            }
        }
        finally {
            BlueCoveImpl.shutdown();
        }
    }

    public StreamConnection openConnection() throws IOException {
        this.checkIsOpened();
        StreamConnection connection = (StreamConnection)Connector.open((String)this.connectionUrl, (int)2);
        this.connections.add(connection);
        return connection;
    }

    public void closeConnection(StreamConnection connection) throws IOException {
        this.checkIsOpened();
        boolean remove = this.connections.remove(connection);
        if (!remove) {
            throw new IllegalArgumentException("Connection is not coming from this client, won't close it!");
        }
        connection.close();
    }

    public String getConnectionUrl() {
        this.checkIsOpened();
        return this.connectionUrl;
    }

    public boolean isOpen() {
        return this.open;
    }

    public String getName() {
        this.checkIsOpened();
        return this.name;
    }

    protected void checkIsOpened() {
        if (!this.open) {
            throw new IllegalStateException("Client is not opened!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, RemoteDevice> discoverDevices() throws BluetoothStateException, InterruptedException {
        TreeMap devices = Maps.newTreeMap();
        MyDiscoveryListener listener = new MyDiscoveryListener(this, devices, null);
        IchtyometerClient ichtyometerClient = this;
        synchronized (ichtyometerClient) {
            boolean started = this.localDevice.getDiscoveryAgent().startInquiry(10390272, (DiscoveryListener)listener);
            if (started) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"wait for device inquiry to complete...");
                }
                this.wait();
                if (log.isInfoEnabled()) {
                    log.info((Object)(devices.size() + " device(s) found"));
                }
            }
        }
        return devices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ServiceRecord> discoverServiceUrls(UUID serviceUUID, RemoteDevice device) throws BluetoothStateException, InterruptedException {
        ArrayList serviceRecords = Lists.newArrayList();
        MyDiscoveryListener listener = new MyDiscoveryListener(this, null, serviceRecords);
        IchtyometerClient ichtyometerClient = this;
        synchronized (ichtyometerClient) {
            int[] attrIDs = new int[]{256};
            this.localDevice.getDiscoveryAgent().searchServices(attrIDs, new UUID[]{serviceUUID}, device, (DiscoveryListener)listener);
            this.wait();
        }
        return serviceRecords;
    }

    public static String getServiceName(ServiceRecord serviceRecord) {
        DataElement serviceName = serviceRecord.getAttributeValue(256);
        String result = serviceName == null ? null : String.valueOf(serviceName.getValue());
        return result;
    }

    protected static class MyDiscoveryListener
    implements DiscoveryListener {
        final Object lock;
        final Map<String, RemoteDevice> devices;
        final List<ServiceRecord> serviceRecords;

        MyDiscoveryListener(Object lock, Map<String, RemoteDevice> devices, List<ServiceRecord> serviceRecords) {
            this.lock = lock;
            this.devices = devices;
            this.serviceRecords = serviceRecords;
        }

        public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
            block4: {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Device " + btDevice.getBluetoothAddress() + " found"));
                }
                try {
                    String friendlyName = btDevice.getFriendlyName(false);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Name: " + friendlyName));
                    }
                    this.devices.put(friendlyName, btDevice);
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Can't get name of remote", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void inquiryCompleted(int discType) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Device Inquiry completed!");
            }
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceSearchCompleted(int transID, int respCode) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Service search completed!");
            }
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
            for (ServiceRecord aServRecord : servRecord) {
                String url = aServRecord.getConnectionURL(0, false);
                if (url == null) continue;
                this.serviceRecords.add(aServRecord);
                String serviceName = IchtyometerClient.getServiceName(aServRecord);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("service found " + url + (serviceName == null ? "" : ", name: " + serviceName)));
            }
        }
    }
}

