/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.util.ApplicationUIUtil;

public final class TuttiUIUtil
extends ApplicationUIUtil {
    private static final Log log = LogFactory.getLog(TuttiUIUtil.class);

    private TuttiUIUtil() {
    }

    public static TuttiUIContext getApplicationContext(JAXXObject ui) {
        return (TuttiUIContext)ApplicationUIUtil.getApplicationContext((JAXXObject)ui);
    }

    public static void setParentUI(JAXXObject ui, TuttiUI<?, ?> parentUI) {
        JAXXUtil.initContext((JAXXObject)ui, parentUI);
        TuttiUIUtil.setApplicationContext((JAXXObject)ui, (ApplicationUIContext)((AbstractTuttiUIHandler)parentUI.getHandler()).getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryToConnectToUpdateUrl(String urlAsString, String badUrlFormatI18nKey, String notReachI18nKey, String notFoundI18nKey) {
        URLConnection urlConnection;
        URL url;
        try {
            url = new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bad url syntax at " + urlAsString), (Throwable)e);
            }
            throw new ApplicationBusinessException(I18n.t((String)badUrlFormatI18nKey, (Object[])new Object[]{urlAsString}));
        }
        try {
            urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(10000);
            urlConnection.connect();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not connect to " + urlAsString), (Throwable)e);
            }
            throw new ApplicationBusinessException(I18n.t((String)notReachI18nKey, (Object[])new Object[]{urlAsString}));
        }
        try {
            urlConnection.setReadTimeout(1000);
            InputStream inputStream = null;
            try {
                inputStream = urlConnection.getInputStream();
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not found file at to " + urlAsString), (Throwable)e);
            }
            throw new ApplicationBusinessException(I18n.t((String)notFoundI18nKey, (Object[])new Object[]{urlAsString}));
        }
    }
}

