/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.report;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.report.ReportModel;
import java.io.File;
import java.io.FileFilter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ReportService.class);
    public static final FileFilter REPORT_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(".rptdesign");
        }
    };
    public static final String REPORT_FILENAME_PATTERN = "tutti-report-%s.pdf";
    public static final DateFormat df = new SimpleDateFormat("yyy-MM-dd_HH-mm");

    public void generateReport(ReportModel model) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will generate report using report " + model.getReport()));
        }
    }

    public List<File> getAvailableReports() {
        ArrayList result = Lists.newArrayList();
        File reportDirectory = this.context.getConfig().getReportDirectory();
        File[] files = reportDirectory.listFiles(REPORT_FILTER);
        if (files != null) {
            result.addAll(Arrays.asList(files));
        }
        return result;
    }

    public File getDefaultOutputFile() {
        String filename = String.format(REPORT_FILENAME_PATTERN, df.format(this.context.currentDate()));
        File result = new File(this.context.getConfig().getReportBackupDirectory(), filename);
        return result;
    }
}

