/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export;

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.CatchExportRow;
import fr.ifremer.tutti.service.export.ExportSampleCategory;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.csv.ValueFormatter;

public class CatchExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<CatchExportRow> {
    public static final String WEIGHT_OR_VOL_TYPE = "Poids";
    protected SampleCategoryModel sampleCategoryModel;

    public CatchExportModel(char separator, SampleCategoryModel sampleCategoryModel, DecoratorService decoratorService) {
        super(separator);
        this.sampleCategoryModel = sampleCategoryModel;
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", "name");
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newNullableColumnForExport("Engin", "gear.name");
        this.newColumnForExport("Id_Operation", "stationNumber");
        this.newColumnForExport("NumOrdre_Station", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("Navire", "vessel", TuttiCsvUtil.VESSEL_VALUE_FORMATTER);
        this.newColumnForExport("Taxon", "species.referenceTaxonId", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Nom_scientifique", "species.name");
        this.newColumnForExport("Commentaire", "comment");
        for (SampleCategoryModelEntry entry : sampleCategoryModel.getCategory()) {
            this.addSampleCategory(entry.getCanonicalLabel(), entry.getOrder());
        }
        this.newNullableColumnForExport("Code_Longueur", "frequency.lengthStepCaracteristic.id");
        this.newNullableColumnForExportByDecorator("Libelle_Longueur", "frequency.lengthStepCaracteristic", decoratorService.getDecoratorByType(Caracteristic.class));
        this.newNullableColumnForExport("Taille", "frequency.lengthStep", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("NumOrdre_Taille_H2", "frequency.rankOrder", TuttiCsvUtil.INTEGER);
        this.newNullableColumnForExport("Poids_Classe_Taille", "frequency.weight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Unite_Taille", "frequency.lengthStepCaracteristic.unit");
        this.newNullableColumnForExport("Precision_Mesure", "frequency.lengthStepCaracteristic.precision", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Nbr", "batchNumber", TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poids_Reference", "referenceWeight", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
        this.newColumnForExport("Coef_Elev_Espece_Capture", "raisingFactor", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
    }

    public void prepareRows(PersistenceService persistenceService, List<CatchExportRow> rows, Cruise cruise, FishingOperation operation, BatchContainer<SpeciesBatch> rootSpeciesBatch, BatchContainer<BenthosBatch> rootBenthosBatch, Float speciesCatchRaisingFactor, Float benthosCatchRaisingFactor) {
        float totalBatchWeight;
        Float sortedBatchWeight;
        CatchExportRow row;
        Caracteristic weightMeasuredCaracteristic = persistenceService.getWeightMeasuredCaracteristic();
        String batchWeightUnit = weightMeasuredCaracteristic.getUnit();
        for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
            row = new CatchExportRow();
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            row.setSpecies(speciesBatch.getSpecies());
            row.setBatchWeightUnit(batchWeightUnit);
            if (persistenceService.isVracSpeciesBatch(speciesBatch)) {
                sortedBatchWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)speciesBatch.getSampleCategoryWeight(), (Number)speciesBatch.getSampleCategoryComputedWeight());
                totalBatchWeight = sortedBatchWeight == null ? 0.0f : speciesCatchRaisingFactor.floatValue() * sortedBatchWeight.floatValue();
                this.prepareSortedRows(persistenceService, row, rows, speciesBatch, totalBatchWeight);
                continue;
            }
            this.prepareUnsortedRows(row, rows, speciesBatch);
        }
        for (BenthosBatch benthosBatch : rootBenthosBatch.getChildren()) {
            row = new CatchExportRow();
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            row.setSpecies(benthosBatch.getSpecies());
            row.setBatchWeightUnit(batchWeightUnit);
            if (persistenceService.isVracBenthosBatch(benthosBatch)) {
                sortedBatchWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)benthosBatch.getSampleCategoryWeight(), (Number)benthosBatch.getSampleCategoryComputedWeight());
                totalBatchWeight = sortedBatchWeight == null ? 0.0f : benthosCatchRaisingFactor.floatValue() * sortedBatchWeight.floatValue();
                this.prepareSortedRows(persistenceService, row, rows, benthosBatch, totalBatchWeight);
                continue;
            }
            this.prepareUnsortedRows(row, rows, benthosBatch);
        }
    }

    protected void prepareSortedRows(PersistenceService persistenceService, CatchExportRow currentRow, List<CatchExportRow> rows, SpeciesBatch speciesBatch, float totalBatchWeight) {
        currentRow.addComment(speciesBatch.getComment());
        this.prepareBatch(currentRow, speciesBatch.getSampleCategoryId(), speciesBatch.getSampleCategoryValue(), speciesBatch.getSampleCategoryWeight(), speciesBatch.getSampleCategoryComputedWeight(), speciesBatch.getWeight(), speciesBatch.getNumber(), speciesBatch.getRankOrder());
        if (speciesBatch.isChildBatchsEmpty()) {
            List<SpeciesBatchFrequency> speciesBatchFrequency = persistenceService.getAllSpeciesBatchFrequency(speciesBatch.getId());
            if (CollectionUtils.isEmpty(speciesBatchFrequency)) {
                CatchExportRow row = currentRow.copy();
                Float referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)speciesBatch.getWeight(), (Number)speciesBatch.getComputedWeight());
                if (referenceWeight == null) {
                    referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)speciesBatch.getSampleCategoryWeight(), (Number)speciesBatch.getSampleCategoryComputedWeight());
                }
                this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                rows.add(row);
            } else {
                boolean withNoWeightOnFrequencies = speciesBatchFrequency.get(0).getWeight() == null;
                Float referenceWeight = null;
                if (withNoWeightOnFrequencies && (referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)speciesBatch.getWeight(), (Number)speciesBatch.getComputedWeight())) == null) {
                    referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)speciesBatch.getSampleCategoryWeight(), (Number)speciesBatch.getSampleCategoryComputedWeight());
                }
                for (SpeciesBatchFrequency batchFrequency : speciesBatchFrequency) {
                    CatchExportRow row = currentRow.copy();
                    row.setSpeciesFrequency(batchFrequency);
                    rows.add(row);
                    if (!withNoWeightOnFrequencies) {
                        referenceWeight = batchFrequency.getWeight();
                    }
                    this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                }
            }
        } else {
            for (SpeciesBatch childBatch : speciesBatch.getChildBatchs()) {
                this.prepareSortedRows(persistenceService, currentRow, rows, childBatch, totalBatchWeight);
            }
        }
        currentRow.popLastComment();
    }

    protected void prepareUnsortedRows(CatchExportRow currentRow, List<CatchExportRow> rows, SpeciesBatch speciesBatch) {
        this.prepareBatch(currentRow, speciesBatch.getSampleCategoryId(), speciesBatch.getSampleCategoryValue(), speciesBatch.getSampleCategoryWeight(), speciesBatch.getSampleCategoryComputedWeight(), speciesBatch.getWeight(), speciesBatch.getNumber(), speciesBatch.getRankOrder());
        CatchExportRow row = currentRow.copy();
        row.addComment(speciesBatch.getComment());
        float referenceWeight = ((Float)TuttiEntities.getValueOrComputedValue((Number)speciesBatch.getSampleCategoryWeight(), (Number)speciesBatch.getSampleCategoryComputedWeight())).floatValue();
        this.setRaisingFactor(row, referenceWeight, Float.valueOf(referenceWeight));
        rows.add(row);
    }

    protected void prepareSortedRows(PersistenceService persistenceService, CatchExportRow currentRow, List<CatchExportRow> rows, BenthosBatch benthosBatch, float totalBatchWeight) {
        currentRow.addComment(benthosBatch.getComment());
        this.prepareBatch(currentRow, benthosBatch.getSampleCategoryId(), benthosBatch.getSampleCategoryValue(), benthosBatch.getSampleCategoryWeight(), benthosBatch.getSampleCategoryComputedWeight(), benthosBatch.getWeight(), benthosBatch.getNumber(), benthosBatch.getRankOrder());
        if (benthosBatch.isChildBatchsEmpty()) {
            List<BenthosBatchFrequency> benthosBatchFrequency = persistenceService.getAllBenthosBatchFrequency(benthosBatch.getId());
            if (CollectionUtils.isEmpty(benthosBatchFrequency)) {
                CatchExportRow row = currentRow.copy();
                Float referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)benthosBatch.getWeight(), (Number)benthosBatch.getComputedWeight());
                if (referenceWeight == null) {
                    referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)benthosBatch.getSampleCategoryWeight(), (Number)benthosBatch.getSampleCategoryComputedWeight());
                }
                this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                rows.add(row);
            } else {
                boolean withNoWeightOnFrequencies;
                Float referenceWeight = null;
                boolean bl = withNoWeightOnFrequencies = benthosBatchFrequency.get(0).getWeight() == null;
                if (withNoWeightOnFrequencies && (referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)benthosBatch.getWeight(), (Number)benthosBatch.getComputedWeight())) == null) {
                    referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)benthosBatch.getSampleCategoryWeight(), (Number)benthosBatch.getSampleCategoryComputedWeight());
                }
                for (BenthosBatchFrequency batchFrequency : benthosBatchFrequency) {
                    CatchExportRow row = currentRow.copy();
                    row.setBenthosFrequency(batchFrequency);
                    rows.add(row);
                    if (!withNoWeightOnFrequencies) {
                        referenceWeight = batchFrequency.getWeight();
                    }
                    this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                }
            }
        } else {
            for (BenthosBatch childBatch : benthosBatch.getChildBatchs()) {
                this.prepareSortedRows(persistenceService, currentRow, rows, childBatch, totalBatchWeight);
            }
        }
        currentRow.popLastComment();
    }

    protected void prepareUnsortedRows(CatchExportRow currentRow, List<CatchExportRow> rows, BenthosBatch benthosBatch) {
        this.prepareBatch(currentRow, benthosBatch.getSampleCategoryId(), benthosBatch.getSampleCategoryValue(), benthosBatch.getSampleCategoryWeight(), benthosBatch.getSampleCategoryComputedWeight(), benthosBatch.getWeight(), benthosBatch.getNumber(), benthosBatch.getRankOrder());
        CatchExportRow row = currentRow.copy();
        row.addComment(benthosBatch.getComment());
        Float referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)benthosBatch.getSampleCategoryWeight(), (Number)benthosBatch.getSampleCategoryComputedWeight());
        this.setRaisingFactor(row, referenceWeight.floatValue(), referenceWeight);
        rows.add(row);
    }

    protected void setRaisingFactor(CatchExportRow row, float totalBatchWeight, Float referenceWeight) {
        row.setReferenceWeight(referenceWeight);
        row.setRaisingFactor(referenceWeight == null ? 1.0f : totalBatchWeight / referenceWeight.floatValue());
    }

    protected void prepareBatch(CatchExportRow currentRow, Integer sampleCategoryId, Serializable sampleCategoryValue, Float sampleCategoryWeight, Float sampleCategoryComputedWeight, Float batchWeight, Integer batchNumber, Integer batchRankOrder) {
        currentRow.setBatchNumber(batchNumber);
        ExportSampleCategory sampleCategory = new ExportSampleCategory();
        SampleCategoryModelEntry categoryById = this.sampleCategoryModel.getCategoryById(sampleCategoryId);
        sampleCategory.setCategoryDef(categoryById);
        sampleCategory.setCategoryValue(sampleCategoryValue);
        sampleCategory.setCategoryWeight(sampleCategoryWeight);
        sampleCategory.setSampleWeight(batchWeight);
        sampleCategory.setComputedWeight(sampleCategoryComputedWeight);
        sampleCategory.setWeightOrVolType(WEIGHT_OR_VOL_TYPE);
        sampleCategory.setRankOrder(batchRankOrder);
        currentRow.addSampleCategory(sampleCategory);
    }

    protected void addSampleCategory(String headerPrefix, int categoryOrder) {
        String categoryName = "sampleCategory";
        this.newIndexNullableColumnForExport(headerPrefix, categoryName, categoryOrder, "categoryValue", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newIndexNullableColumnForExport("Num_Ordre_" + headerPrefix + "_H2", categoryName, categoryOrder, "rankOrder", TuttiCsvUtil.INTEGER);
        this.newIndexNullableColumnForExport("Tot_" + headerPrefix, categoryName, categoryOrder, "categoryWeight", TuttiCsvUtil.FLOAT);
        this.newIndexNullableColumnForExport("Ech_" + headerPrefix, categoryName, categoryOrder, "sampleWeight", TuttiCsvUtil.FLOAT);
        this.newIndexNullableColumnForExport("Type_Volume_Poids_" + headerPrefix, categoryName, categoryOrder, "weightOrVolType");
        this.newNullableColumnForExport("Unite_Volume_Poids_" + headerPrefix, "batchWeightUnit");
    }
}

