/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.validator.ValidationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuiton.validator.xwork2.field.NuitonFieldValidatorSupport;

public class FrenchPhoneNumberFieldValidator
extends NuitonFieldValidatorSupport {
    protected static String PHONE_NUMBER_REGEXP = "[0-9]{10}|(([0-9]{2}[-\\.\\s]){4})[0-9]{2}";
    protected static Pattern p = Pattern.compile(PHONE_NUMBER_REGEXP);

    @Override
    public void validateWhenNotSkip(Object object) throws ValidationException {
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            if ("".equals(value)) {
                return;
            }
            Matcher m = p.matcher((String)value);
            if (!m.matches()) {
                this.addFieldError(fieldName, object);
            }
        } else {
            this.addFieldError(fieldName, object);
        }
    }

    public String getValidatorType() {
        return "frenchPhoneNumber";
    }
}

