package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id: NewProgramAction.java 1170 2013-09-13 16:21:34Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.9/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/home/NewProgramAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;

/**
 * Opens the program creation screen.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class NewProgramAction extends AbstractChangeScreenAction {

    public NewProgramAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.EDIT_PROGRAM);
    }

    @Override
    public void doAction() throws Exception {
        getContext().setProgramId(null);
        getContext().setCruiseId(null);
        super.doAction();
    }
}
