/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.BuildInformation;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class ExceptionRecorder {
    private static final Logger logger = Logger.getLogger((Class)(class$org$andromda$core$common$ExceptionRecorder == null ? (class$org$andromda$core$common$ExceptionRecorder = ExceptionRecorder.class$("org.andromda.core.common.ExceptionRecorder")) : class$org$andromda$core$common$ExceptionRecorder));
    static final String FILE_HEADER = "------- AndroMDA Exception Recording -------";
    static final String RUN_SYSTEM = "Run System .....: ";
    static final String RUN_JDK = "Run JDK ........: ";
    static final String INFORMATION_UNAVAILABLE = " unavailable";
    private static String exceptionDirectoryName = ".";
    private static File exceptionDirectory = null;
    private static final SimpleDateFormat cvDateFormat = new SimpleDateFormat("yyMMddHHmmss");
    private static final Random random = new Random();
    private static final ExceptionRecorder instance = new ExceptionRecorder();
    private static final String DEFAULT_PREFIX = "andromda";
    private static final String SUFFIX = ".exc";
    static /* synthetic */ Class class$org$andromda$core$common$ExceptionRecorder;

    private ExceptionRecorder() {
    }

    public static ExceptionRecorder instance() {
        return instance;
    }

    public String record(Throwable throwable) {
        return this.record("", throwable, "S");
    }

    public String record(String errorMessage, Throwable throwable) {
        return this.record(errorMessage, throwable, "S");
    }

    public String record(String message, Throwable throwable, String prefix) {
        String result = null;
        if (StringUtils.isEmpty((String)prefix)) {
            prefix = DEFAULT_PREFIX;
        }
        try {
            BuildInformation buildInformation = BuildInformation.instance();
            String uniqueName = this.getUniqueName(prefix);
            File exceptionFile = new File(exceptionDirectory, uniqueName);
            result = exceptionFile.getCanonicalPath();
            PrintWriter writer = new PrintWriter(new FileWriter(exceptionFile));
            writer.println(FILE_HEADER);
            writer.println("Version ........: " + buildInformation.getBuildVersion());
            writer.println("Error ..........: " + message);
            writer.println("Build ..........: " + buildInformation.getBuildDate());
            writer.println("Build System ...: " + buildInformation.getBuildSystem());
            writer.println("Build JDK ......: " + buildInformation.getBuildJdk());
            writer.println("Build Builder ..: " + buildInformation.getBuildBuilder());
            try {
                writer.println(RUN_SYSTEM + System.getProperty("os.name") + System.getProperty("os.version"));
                writer.println(RUN_JDK + System.getProperty("java.vm.vendor") + System.getProperty("java.vm.version"));
            }
            catch (Exception ex) {
                writer.println("Run System .....:  unavailable");
                writer.println("Run JDK ........:  unavailable");
            }
            writer.println("Main Exception .: " + throwable.getMessage());
            Throwable cause = ExceptionUtils.getRootCause((Throwable)throwable);
            if (cause == null) {
                cause = throwable;
            }
            writer.println("Root Exception .: " + cause);
            cause.printStackTrace(writer);
            writer.close();
            AndroMDALogger.error("Exception recorded in --> '" + result + "'");
        }
        catch (Throwable th) {
            String errorMessage = "ExceptionRecorder.record error recording exception --> '" + throwable + "'";
            logger.error((Object)errorMessage, th);
        }
        return result;
    }

    protected synchronized String getUniqueName(String prefix) {
        String uniqueName = prefix + cvDateFormat.format(new Date()) + SUFFIX;
        int suffix = 0;
        File exceptionFile = new File(exceptionDirectory, uniqueName);
        while (exceptionFile.exists()) {
            uniqueName = prefix + cvDateFormat.format(new Date()) + "_" + suffix++ + SUFFIX;
            exceptionFile = new File(exceptionDirectory, uniqueName);
            try {
                Thread.sleep(Math.abs(random.nextInt() % 100));
            }
            catch (InterruptedException e1) {}
        }
        try {
            RandomAccessFile file = new RandomAccessFile(exceptionFile, "rw");
            file.writeChar(116);
            file.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return uniqueName;
    }

    public File getExceptionDirectory() {
        return exceptionDirectory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            exceptionDirectory = new File(exceptionDirectoryName);
            if (!exceptionDirectory.exists()) {
                exceptionDirectory.mkdir();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (exceptionDirectory == null) {
                exceptionDirectory = new File(".");
            }
        }
    }
}

