/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.catches.ExportCatchesReportService;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SendCruiseReportAction
extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {
    private static final Log log = LogFactory.getLog(SendCruiseReportAction.class);
    protected File file;

    public SendCruiseReportAction(SelectCruiseUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            Cruise cruise = ((SelectCruiseUIModel)this.getModel()).getCruise();
            this.file = this.saveFile("exportCruise-" + cruise.getName(), "pdf", I18n._((String)"tutti.sendCruiseReport.title.choose.exportFile", (Object[])new Object[0]), I18n._((String)"tutti.sendCruiseReport.action.chooseFile", (Object[])new Object[0]), "^.+\\.pdf$", I18n._((String)"tutti.common.file.pdf", (Object[])new Object[0]));
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Cruise cruise = ((SelectCruiseUIModel)this.getModel()).getCruise();
        Preconditions.checkNotNull((Object)cruise);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export cruise " + cruise.getId() + " to file: " + this.file));
        }
        ExportCatchesReportService service = this.getContext().getGeneratePDFService();
        service.generatePDFFile(this.file, cruise.getId(), this.getConfig().getI18nLocale());
        try {
            TuttiUIUtil.mail(I18n._((String)"tutti.sendCruiseReport.mail.subject", (Object[])new Object[]{cruise.getName()}), I18n._((String)"tutti.sendCruiseReport.mail.body", (Object[])new Object[]{cruise.getName(), this.file.getAbsolutePath()}));
        }
        catch (TuttiTechnicalException e) {
            JOptionPane.showMessageDialog(this.getContext().getMainUI(), I18n._((String)"tutti.sendCruiseReport.action.error.mail.message", (Object[])new Object[]{this.file}), I18n._((String)"tutti.sendCruiseReport.action.error.mail.title", (Object[])new Object[0]), 2);
        }
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n._((String)"tutti.sendCruiseReport.action.success", (Object[])new Object[]{this.file}));
    }
}

