package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class MarineLitterBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<MarineLitterBatchUIModel, MarineLitterBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_BEAN = "marineLitterTotalWeightField.bean";
    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_MODEL = "marineLitterTotalWeightField.model";
    public static final String BINDING_REMOVE_MARINE_LITTER_BATCH_MENU_ENABLED = "removeMarineLitterBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(MarineLitterBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton createMarineLitterBatchButton;
    protected MarineLitterBatchUI editMarineLitterBatchTopPanel = this;
    protected JButton exportMultiPostButton;
    protected Table form;
    protected MarineLitterBatchUIHandler handler;
    protected JButton importMultiPostButton;
    protected JToolBar marineLitterBatchTabToolBar;
    @ValidatorField( validatorId = "validator",  propertyName = "marineLitterTotalWeight",  editorName = "marineLitterTotalWeightField")
    protected TuttiComputedOrNotDataEditor marineLitterTotalWeightField;
    protected JLabel marineLitterTotalWeightLabel;
    protected MarineLitterBatchUIModel model;
    protected JMenuItem removeMarineLitterBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<MarineLitterBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MarineLitterBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            MarineLitterBatchUIHandler handler = new MarineLitterBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public MarineLitterBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MarineLitterBatchUI() {
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MarineLitterBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MarineLitterBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createMarineLitterBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createBatch();
    }

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCreateMarineLitterBatchButton() {
        return createMarineLitterBatchButton;
    }

    public JButton getExportMultiPostButton() {
        return exportMultiPostButton;
    }

    public Table getForm() {
        return form;
    }

    public MarineLitterBatchUIHandler getHandler() {
        return handler;
    }

    public JButton getImportMultiPostButton() {
        return importMultiPostButton;
    }

    public JToolBar getMarineLitterBatchTabToolBar() {
        return marineLitterBatchTabToolBar;
    }

    public TuttiComputedOrNotDataEditor getMarineLitterTotalWeightField() {
        return marineLitterTotalWeightField;
    }

    public JLabel getMarineLitterTotalWeightLabel() {
        return marineLitterTotalWeightLabel;
    }

    public MarineLitterBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveMarineLitterBatchMenu() {
        return removeMarineLitterBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<MarineLitterBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditMarineLitterBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(marineLitterBatchTabToolBar);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(marineLitterTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(marineLitterTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(tableToolbar, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMarineLitterBatchTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterBatchTabToolBar.add(importMultiPostButton);
        marineLitterBatchTabToolBar.add(exportMultiPostButton);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeMarineLitterBatchMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editMarineLitterBatch.help"));
    }

    protected void createCreateMarineLitterBatchButton() {
        $objectMap.put("createMarineLitterBatchButton", createMarineLitterBatchButton = new JButton());
        
        createMarineLitterBatchButton.setName("createMarineLitterBatchButton");
        createMarineLitterBatchButton.setText(_("tutti.editMarineLitterBatch.action.createBatch"));
        createMarineLitterBatchButton.setToolTipText(_("tutti.editMarineLitterBatch.action.createBatch.tip"));
        createMarineLitterBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createMarineLitterBatchButton"));
        createMarineLitterBatchButton.putClientProperty("help", "tutti.editMarineLitterBatch.action.createBatch.help");
    }

    protected void createExportMultiPostButton() {
        $objectMap.put("exportMultiPostButton", exportMultiPostButton = new JButton());
        
        exportMultiPostButton.setName("exportMultiPostButton");
        exportMultiPostButton.setText(_("tutti.editMarineLitterBatch.action.exportMultiPost"));
        exportMultiPostButton.setToolTipText(_("tutti.editMarineLitterBatch.action.exportMultiPost.tip"));
        exportMultiPostButton.putClientProperty("help", "tutti.editMarineLitterBatch.action.exportMultiPost.help");
        exportMultiPostButton.putClientProperty("tuttiAction", ExportMultiPostAction.class);
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(MarineLitterBatchUIHandler.class));
    }

    protected void createImportMultiPostButton() {
        $objectMap.put("importMultiPostButton", importMultiPostButton = new JButton());
        
        importMultiPostButton.setName("importMultiPostButton");
        importMultiPostButton.setText(_("tutti.editMarineLitterBatch.action.importMultiPost"));
        importMultiPostButton.setToolTipText(_("tutti.editMarineLitterBatch.action.importMultiPost.tip"));
        importMultiPostButton.putClientProperty("help", "tutti.editMarineLitterBatch.action.importMultiPost.help");
        importMultiPostButton.putClientProperty("tuttiAction", ImportMultiPostAction.class);
    }

    protected void createMarineLitterBatchTabToolBar() {
        $objectMap.put("marineLitterBatchTabToolBar", marineLitterBatchTabToolBar = new JToolBar());
        
        marineLitterBatchTabToolBar.setName("marineLitterBatchTabToolBar");
        marineLitterBatchTabToolBar.setFloatable(false);
        marineLitterBatchTabToolBar.setOpaque(false);
        marineLitterBatchTabToolBar.setBorderPainted(false);
    }

    protected void createMarineLitterTotalWeightField() {
        $objectMap.put("marineLitterTotalWeightField", marineLitterTotalWeightField = new TuttiComputedOrNotDataEditor(this));
        
        marineLitterTotalWeightField.setName("marineLitterTotalWeightField");
        marineLitterTotalWeightField.setUseFloat(true);
        marineLitterTotalWeightField.setShowReset(true);
    }

    protected void createMarineLitterTotalWeightLabel() {
        $objectMap.put("marineLitterTotalWeightLabel", marineLitterTotalWeightLabel = new JLabel());
        
        marineLitterTotalWeightLabel.setName("marineLitterTotalWeightLabel");
        marineLitterTotalWeightLabel.setText(_("tutti.editMarineLitterBatch.field.marineLitterTotalWeight"));
        marineLitterTotalWeightLabel.setToolTipText(_("tutti.editMarineLitterBatch.field.marineLitterTotalWeight.tip"));
        marineLitterTotalWeightLabel.putClientProperty("help", "tutti.editMarineLitterBatch.field.marineLitterTotalWeight.help");
        marineLitterTotalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getMarineLitterWeightUnit());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(MarineLitterBatchUIModel.class));
    }

    protected void createRemoveMarineLitterBatchMenu() {
        $objectMap.put("removeMarineLitterBatchMenu", removeMarineLitterBatchMenu = new JMenuItem());
        
        removeMarineLitterBatchMenu.setName("removeMarineLitterBatchMenu");
        removeMarineLitterBatchMenu.setText(_("tutti.editMarineLitterBatch.action.removeBatch"));
        removeMarineLitterBatchMenu.setToolTipText(_("tutti.editMarineLitterBatch.action.removeBatch.tip"));
        removeMarineLitterBatchMenu.putClientProperty("help", "tutti.editMarineLitterBatch.action.removeBatch.help");
        removeMarineLitterBatchMenu.putClientProperty("tuttiAction", RemoveMarineLitterBatchAction.class);
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editMarineLitterBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(MarineLitterBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditMarineLitterBatchTopPanel();
        addChildrenToValidator();
        addChildrenToMarineLitterBatchTabToolBar();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createMarineLitterBatchButton);
        addChildrenToTableScrollPane();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        importMultiPostButton.setIcon(SwingUtil.createActionIcon("import"));
        importMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editMarineLitterBatch.action.importMultiPost.mnemonic"),'Z'));
        exportMultiPostButton.setIcon(SwingUtil.createActionIcon("export"));
        exportMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editMarineLitterBatch.action.exportMultiPost.mnemonic"),'Z'));
        removeMarineLitterBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeMarineLitterBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editMarineLitterBatch.action.removeBatch.mnemonic"),'Z'));
        marineLitterTotalWeightLabel.setLabelFor(marineLitterTotalWeightField);
        marineLitterTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        marineLitterTotalWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        marineLitterTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        createMarineLitterBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        createMarineLitterBatchButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editMarineLitterBatch.action.createBatch.mnemonic"),'Z'));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editMarineLitterBatchTopPanel, "tutti.editMarineLitterBatch.help");
        registerHelpId(_broker, importMultiPostButton, "tutti.editMarineLitterBatch.action.importMultiPost.help");
        registerHelpId(_broker, exportMultiPostButton, "tutti.editMarineLitterBatch.action.exportMultiPost.help");
        registerHelpId(_broker, removeMarineLitterBatchMenu, "tutti.editMarineLitterBatch.action.removeBatch.help");
        registerHelpId(_broker, marineLitterTotalWeightLabel, "tutti.editMarineLitterBatch.field.marineLitterTotalWeight.help");
        registerHelpId(_broker, createMarineLitterBatchButton, "tutti.editMarineLitterBatch.action.createBatch.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editMarineLitterBatchTopPanel", editMarineLitterBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createMarineLitterBatchTabToolBar();
        createImportMultiPostButton();
        createExportMultiPostButton();
        createTablePopup();
        createRemoveMarineLitterBatchMenu();
        createForm();
        createMarineLitterTotalWeightLabel();
        createMarineLitterTotalWeightField();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateMarineLitterBatchButton();
        createTableScrollPane();
        createTable();
        // inline creation of editMarineLitterBatchTopPanel
        setName("editMarineLitterBatchTopPanel");
        setLayout(new BorderLayout());
        editMarineLitterBatchTopPanel.putClientProperty("help", "tutti.editMarineLitterBatch.help");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_MARINE_LITTER_BATCH_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeMarineLitterBatchMenu.setEnabled(model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterTotalWeightField.setModel(model.getMarineLitterTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterTotalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterTotalComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterTotalWeightField.setBean(model.getMarineLitterTotalComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterTotalComputedOrNotWeight", this);
                }
            }
        });
    }

}