/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.config;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.RessourceClassLoader;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfigOption;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.i18n.I18n;

public class TuttiPersistenceConfig {
    private static final Log log = LogFactory.getLog(TuttiPersistenceConfig.class);
    private static TuttiPersistenceConfig instance;
    protected final ApplicationConfig config;

    public static TuttiPersistenceConfig getInstance() {
        return instance;
    }

    public static void setInstance(TuttiPersistenceConfig instance) {
        TuttiPersistenceConfig.instance = instance;
    }

    public TuttiPersistenceConfig(ApplicationConfig config) {
        this.config = config;
    }

    public void initConfig(RessourceClassLoader resourceLoader) {
        File directory = this.getDbDirectory();
        TuttiIOUtil.forceMkdir(directory, I18n._((String)"tutti.persistence.mkDir.error", (Object[])new Object[]{directory}));
        directory = this.getDbAttachmentDirectory();
        TuttiIOUtil.forceMkdir(directory, I18n._((String)"tutti.persistence.mkDir.error", (Object[])new Object[]{directory}));
        directory = this.getProtocolDirectory();
        TuttiIOUtil.forceMkdir(directory, I18n._((String)"tutti.persistence.mkDir.error", (Object[])new Object[]{directory}));
        directory = this.getDbBackupDirectory();
        TuttiIOUtil.forceMkdir(directory, I18n._((String)"tutti.persistence.mkDir.error", (Object[])new Object[]{directory}));
        resourceLoader.addSearchInDirectoriesPredicate(new Predicate<String>(){
            Set<String> matchingNames;
            {
                this.matchingNames = Sets.newHashSet((Object[])new String[]{TuttiPersistenceConfig.this.getDbConfigurationPath().getName(), TuttiPersistenceConfig.this.getDbEnumerationPath().getName()});
            }

            public boolean apply(String input) {
                return this.matchingNames.contains(input);
            }
        });
        File configurationPath = this.getDbConfigurationPath();
        resourceLoader.addDirectory(configurationPath.getParentFile());
        File enumerationPath = this.getDbEnumerationPath();
        resourceLoader.addDirectory(enumerationPath.getParentFile());
        this.generateExternalDbFiles(false);
    }

    public File getDbConfigurationPath() {
        return this.config.getOptionAsFile(TuttiPersistenceConfigOption.DB_CONFIGURATION_PATH.getKey());
    }

    public File getDbDirectory() {
        return this.config.getOptionAsFile(TuttiPersistenceConfigOption.DB_DIRECTORY.getKey());
    }

    public File getDbAttachmentDirectory() {
        return this.config.getOptionAsFile(TuttiPersistenceConfigOption.DB_ATTACHMENT_DIRECTORY.getKey());
    }

    public File getCacheDirectory() {
        return this.config.getOptionAsFile(TuttiPersistenceConfigOption.DB_CACHE_DIRECTORY.getKey());
    }

    public File getDbBackupDirectory() {
        return this.config.getOptionAsFile(TuttiPersistenceConfigOption.DB_BACKUP_DIRECTORY.getKey());
    }

    public File getProtocolDirectory() {
        return this.config.getOptionAsFile(TuttiPersistenceConfigOption.DB_PROTOCOL_DIRECTORY.getKey());
    }

    public String getDbName() {
        return this.config.getOption(TuttiPersistenceConfigOption.DB_NAME.getKey());
    }

    public SampleCategoryModel getSampleCategoryModel() {
        SampleCategoryModel result = (SampleCategoryModel)this.config.getOption(SampleCategoryModel.class, TuttiPersistenceConfigOption.SAMPLE_CATEGORY_MODEL.getKey());
        return result;
    }

    public void setSampleCategoryModel(SampleCategoryModel model) {
        this.config.setOption(TuttiPersistenceConfigOption.SAMPLE_CATEGORY_MODEL.getKey(), String.valueOf(model));
    }

    public boolean isDbExists() {
        File f = new File(this.getDbDirectory(), this.getDbName() + ".data");
        return f.exists();
    }

    public File getDbEnumerationPath() {
        return this.config.getOptionAsFile(TuttiPersistenceConfigOption.DB_ENUMERATION_PATH.getKey());
    }

    public String getJdbcUrl() {
        return this.config.getOption(TuttiPersistenceConfigOption.JDBC_URL.getKey());
    }

    public Class getJdbcDriver() {
        return this.config.getOptionAsClass(TuttiPersistenceConfigOption.JDBC_DRIVER.getKey());
    }

    public String getJdbcUsername() {
        return this.config.getOption(TuttiPersistenceConfigOption.JDBC_USERNAME.getKey());
    }

    public String getJdbcPassword() {
        return this.config.getOption(TuttiPersistenceConfigOption.JDBC_PASSWORD.getKey());
    }

    public Class getHibernateDialect() {
        return this.config.getOptionAsClass(TuttiPersistenceConfigOption.HIBERNATE_DIALECT.getKey());
    }

    public boolean isHibernateShowSql() {
        boolean result = this.config.getOptionAsBoolean(TuttiPersistenceConfigOption.HIBERNATE_SHOW_SQL.getKey());
        return result;
    }

    public boolean isHibernateUseSqlComment() {
        boolean result = this.config.getOptionAsBoolean(TuttiPersistenceConfigOption.HIBERNATE_USE_SQL_COMMENT.getKey());
        return result;
    }

    public boolean isHibernateFormatSql() {
        boolean result = this.config.getOptionAsBoolean(TuttiPersistenceConfigOption.HIBERNATE_FORMAT_SQL.getKey());
        return result;
    }

    public ApplicationConfig getConfig() {
        return this.config;
    }

    public void generateExternalDbFiles(boolean force) {
        try {
            this.generateDbConfiguration(true);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.persistence.config.generateFile.error", (Object[])new Object[0]));
        }
        try {
            this.generateDbEnumerationConfiguration(force);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.persistence.config.generateEnumFile.error", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateDbConfiguration(boolean force) throws IOException {
        File destination = this.getDbConfigurationPath();
        if (force || !destination.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Generate " + destination + " from classpath."));
            }
            Properties result = new Properties();
            InputStream in = this.getClass().getResourceAsStream("/tutti-db-conf.properties");
            try {
                result.load(in);
                in.close();
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            result.put("dataSource.jdbc.driver", this.getJdbcDriver().getName());
            result.put("dataSource.jdbc.username", this.getJdbcUsername());
            result.put("dataSource.jdbc.password", this.getJdbcPassword());
            result.put("dataSource.jdbc.url", this.getJdbcUrl());
            result.put("hibernate.dialect", this.getHibernateDialect().getName());
            result.put("hibernate.show_sql", this.isHibernateShowSql() + "");
            result.put("hibernate.format_sql", this.isHibernateFormatSql() + "");
            result.put("hibernate.use_sql_comments", this.isHibernateUseSqlComment() + "");
            result.put("ehcache.disk.store.dir", this.getCacheDirectory().getAbsolutePath());
            BufferedWriter writer = Files.newWriter((File)destination, (Charset)Charsets.UTF_8);
            try {
                result.store(writer, "Generated by " + this.getClass().getName());
                writer.close();
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateDbEnumerationConfiguration(boolean force) throws IOException {
        File destination = this.getDbEnumerationPath();
        if (force || !destination.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Generate " + destination + " from classpath."));
            }
            Properties result = new Properties();
            InputStream in = this.getClass().getResourceAsStream("/tutti-db-enumerations.properties");
            try {
                result.load(in);
                in.close();
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            BufferedWriter writer = Files.newWriter((File)destination, (Charset)Charsets.UTF_8);
            try {
                result.store(writer, "Generated by " + this.getClass().getName());
                writer.close();
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getDbEnumerations() throws IOException {
        Properties result = new Properties();
        BufferedReader in = Files.newReader((File)this.getDbEnumerationPath(), (Charset)Charsets.UTF_8);
        try {
            result.load(in);
            in.close();
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
        return result;
    }
}

