/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise;

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import javax.swing.JOptionPane;
import org.nuiton.i18n.I18n;

public class SaveCruiseAction
extends AbstractTuttiAction<EditCruiseUIModel, EditCruiseUI, EditCruiseUIHandler> {
    protected PersistenceService persistenceService = this.getContext().getPersistenceService();

    public SaveCruiseAction(EditCruiseUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {
        Cruise oldCruise;
        boolean result = super.prepareAction();
        Cruise bean = (Cruise)((EditCruiseUIModel)this.getModel()).toBean();
        if (!TuttiEntities.isNew(bean) && !(oldCruise = this.persistenceService.getCruise(bean.getId())).getVessel().equals(bean.getVessel())) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.editCruise.action.save.vesselChanged.message", (Object[])new Object[0]), I18n._((String)"tutti.editCruise.action.save.vesselChanged.help", (Object[])new Object[0]));
            int answer = JOptionPane.showConfirmDialog(this.getContext().getActionUI(), htmlMessage, I18n._((String)"tutti.editCruise.action.save.vesselChanged.title", (Object[])new Object[0]), 2, 2);
            result = answer == 0;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        Cruise saved;
        TuttiUIContext context = this.getContext();
        EditCruiseUIModel model = (EditCruiseUIModel)this.getModel();
        Cruise bean = (Cruise)model.toBean();
        if (TuttiEntities.isNew(bean)) {
            saved = this.persistenceService.createCruise(bean);
            model.setId(saved.getId());
            this.sendMessage(I18n._((String)"tutti.flash.info.cruiseCreated", (Object[])new Object[]{bean.getName()}));
        } else {
            saved = this.persistenceService.saveCruise(bean);
            this.sendMessage(I18n._((String)"tutti.flash.info.cruiseSaved", (Object[])new Object[]{bean.getName()}));
        }
        context.setProgramId(saved.getProgram().getId());
        context.setCruiseId(saved.getId());
        model.setModify(false);
    }

    @Override
    public void postSuccessAction() {
        this.getContext().getMainUI().getHandler().setBodyTitle(EditCruiseUIHandler.getTitle(true));
    }
}

