/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.decorator.MultiJXPathDecorator;
import org.nuiton.util.beans.BeanUtil;

public class TuttiDecorator<O>
extends MultiJXPathDecorator<O>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TuttiDecorator.class);
    protected final Map<String, Method> tokenMethods = Maps.newHashMap();
    protected final LoadingCache<O, String> cache;
    protected boolean useCache;

    public static <O> TuttiDecorator<O> newDecorator(Class<O> internalClass, String expression, String separator, String separatorReplacement) {
        return new TuttiDecorator<O>(internalClass, expression, separator, separatorReplacement);
    }

    protected TuttiDecorator(Class<O> internalClass, String expression, String separator, String separatorReplacement) throws IllegalArgumentException, NullPointerException {
        super(internalClass, expression, separator, separatorReplacement);
        Set descriptors = BeanUtil.getDescriptors((Class)this.type, (Predicate)BeanUtil.IS_READ_DESCRIPTOR);
        for (String token : this.getTokens()) {
            Method m = null;
            for (PropertyDescriptor propertyDescriptor : descriptors) {
                if (!propertyDescriptor.getName().equals(token)) continue;
                m = propertyDescriptor.getReadMethod();
                break;
            }
            if (m == null) {
                throw new IllegalArgumentException("could not find the property " + token + " in " + this.type);
            }
            this.tokenMethods.put(token, m);
        }
        int i = 0;
        for (JXPathDecorator.Context OContext : this.contexts) {
            OContext.setComparator(new TuttiDecoratorComparator(this.getProperty(i++)));
        }
        this.cache = CacheBuilder.newBuilder().build(new CacheLoader<O, String>(){

            public String load(O key) throws Exception {
                String result = key == null ? "" : TuttiDecorator.this.toString(key);
                return result;
            }
        });
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
        this.cache.invalidateAll();
    }

    public String toString(Object bean) {
        String result;
        Object bean1;
        block10: {
            bean1 = bean;
            result = null;
            if (this.useCache) {
                try {
                    result = (String)this.cache.get(bean1);
                }
                catch (ExecutionException e) {
                    if (!log.isErrorEnabled()) break block10;
                    log.error((Object)"Could not obtain from cache", (Throwable)e);
                }
            }
        }
        if (result == null && bean != null) {
            Object[] args = new Object[this.nbToken];
            String[] tokens = this.getTokens();
            for (int i = 0; i < this.nbToken; ++i) {
                String token = tokens[i];
                Object value = this.getValue(bean1, token);
                if (value == null) {
                    value = this.onNullValue(bean1, token);
                }
                args[i] = value;
            }
            try {
                result = String.format(this.getExpression(), args);
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Could not format " + this.getExpression() + "" + " with args : " + Arrays.toString(args)), (Throwable)eee);
                }
                result = "";
            }
            if (this.useCache) {
                this.cache.put(bean1, (Object)result);
            }
        }
        return result;
    }

    protected Object getValue(O bean, String token) {
        Object result;
        Method method = this.tokenMethods.get(token);
        Preconditions.checkNotNull((Object)method, (Object)("Could not find method for token " + token));
        try {
            result = method.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Could not obtain token [" + token + "] value"), (Throwable)e);
            }
            result = "";
        }
        return result;
    }

    protected Object onNullValue(O bean, String token) {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class TuttiDecoratorComparator<O>
    extends JXPathDecorator.JXPathComparator<O>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected String expression;

        public TuttiDecoratorComparator(String expression) {
            super(expression);
            this.expression = expression;
        }

        public void init(JXPathDecorator<O> decorator, List<O> datas) {
            this.clear();
            TuttiDecorator tuttDecorator = (TuttiDecorator)decorator;
            for (O data : datas) {
                String key = tuttDecorator.toString(data);
                this.valueCache.put(data, key);
            }
        }
    }
}

