/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.updater;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.config.ApplicationConfig;
import org.nuiton.util.config.ArgumentsParserException;
import org.nuiton.util.updater.ApplicationInfo;
import org.nuiton.util.updater.ApplicationUpdaterActionGetVersions;
import org.nuiton.util.updater.ApplicationUpdaterActionUpdate;
import org.nuiton.util.updater.ApplicationUpdaterCallback;
import org.nuiton.util.updater.DownloadMonitor;

public class ApplicationUpdater {
    private static final Log log = LogFactory.getLog(ApplicationUpdater.class);
    protected static final String VERSION_FILE = "version.appup";
    protected static final String SEPARATOR_KEY = ".";
    public static final String ZERO_VERSION = "0";
    protected ApplicationConfig config;

    public ApplicationUpdater() {
        this(null);
    }

    public ApplicationUpdater(ApplicationConfig config) {
        if (config == null) {
            try {
                config = new ApplicationConfig(ApplicationUpdater.class.getSimpleName() + ".properties");
                config.parse(new String[0]);
                config = config.getSubConfig(ApplicationUpdater.class.getSimpleName() + SEPARATOR_KEY);
            }
            catch (ArgumentsParserException eee) {
                throw new RuntimeException(eee);
            }
        }
        this.config = config;
    }

    public static File getVersionFile(File dir) {
        File versionFile = new File(dir, VERSION_FILE);
        return versionFile;
    }

    public static void createVersionFile(File dir, String version) throws IOException {
        File versionFile = ApplicationUpdater.getVersionFile(dir);
        FileUtils.writeStringToFile((File)versionFile, (String)version);
    }

    public static String loadVersionFile(String appName, File dir) {
        File f = ApplicationUpdater.getVersionFile(dir);
        String version = ZERO_VERSION;
        try {
            version = FileUtils.readFileToString((File)f);
        }
        catch (IOException ex) {
            log.warn((Object)String.format("Can't find file version file for application '%s', this file should be '%s'", appName, f));
        }
        version = StringUtils.trim((String)version);
        return version;
    }

    public static void storeVersionFile(File dir, String version) throws IOException {
        File f = ApplicationUpdater.getVersionFile(dir);
        FileUtils.writeStringToFile((File)f, (String)version);
    }

    public void update(String url, File currentDir, File destDir, boolean async, ApplicationUpdaterCallback callback) {
        this.update(url, currentDir, destDir, async, callback, null);
    }

    public void update(String url, File currentDir, File destDir, boolean async, ApplicationUpdaterCallback callback, DownloadMonitor downloadMonitor) {
        ApplicationUpdaterActionUpdate action = new ApplicationUpdaterActionUpdate(this.config, url, currentDir, destDir, downloadMonitor, callback);
        if (async) {
            Thread thread = new Thread((Runnable)action, ApplicationUpdater.class.getSimpleName());
            thread.start();
        } else {
            action.run();
        }
    }

    public Map<String, ApplicationInfo> getVersions(String url, File currentDir) {
        ApplicationUpdaterActionGetVersions action = new ApplicationUpdaterActionGetVersions(this.config, url, currentDir);
        action.run();
        Map<String, ApplicationInfo> updates = action.getUpdates();
        return updates;
    }
}

