/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.ValidateCruiseOperationsService;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import org.nuiton.i18n.I18n;

public class ExportOperationValidationMessagesAction
extends AbstractTuttiAction<ValidateCruiseUIModel, ValidateCruiseUI, ValidateCruiseUIHandler> {
    protected File file;
    protected ValidateCruiseOperationsService validationService = this.getContext().getValidateCruiseOperationsService();

    public ExportOperationValidationMessagesAction(ValidateCruiseUIHandler handler) {
        super(handler, false);
        this.setActionDescription(I18n._((String)"tutti.validateCruise.action.export.operation.tip", (Object[])new Object[0]));
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        this.file = TuttiUIUtil.saveFile(I18n._((String)"tutti.validateCruise.action.export.operation.chooseFile.defaultFile", (Object[])new Object[]{this.decorate(((ValidateCruiseUIModel)((Object)this.getModel())).getSelectedFishingOperation(), "fileNameCompatible")}), this.getContext().getMainUI(), I18n._((String)"tutti.validateCruise.action.export.operation.chooseFile.title", (Object[])new Object[0]), I18n._((String)"tutti.validateCruise.action.export.operation.chooseFile.label", (Object[])new Object[0]), new String[0]);
        boolean bl = doAction = this.file != null;
        if (doAction) {
            doAction = ((ValidateCruiseUIHandler)this.getHandler()).askOverwriteFile(this.file);
        }
        return doAction;
    }

    @Override
    protected void doAction() throws Exception {
        ValidateCruiseUIModel uiModel = (ValidateCruiseUIModel)((Object)this.getModel());
        FishingOperation operation = ((ValidateCruiseUIModel)((Object)this.getModel())).getSelectedFishingOperation();
        this.validationService.exportValidationResult(this.file, operation, uiModel.getValidator().get(operation));
    }

    @Override
    protected void releaseAction() {
        super.releaseAction();
        this.file = null;
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n._((String)"tutti.validateCruise.action.export.operation.success", (Object[])new Object[]{this.file}));
    }
}

