/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.decorator;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.decorator.Decorator;

public class JXPathDecorator<O>
extends Decorator<O> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(JXPathDecorator.class);
    protected Context<O> context;
    protected int nbToken;
    protected String initialExpression;

    protected JXPathDecorator(Class<O> internalClass, String expression, Context<O> context) throws IllegalArgumentException, NullPointerException {
        super(internalClass);
        this.initialExpression = expression;
        if (context != null) {
            this.setContext(context);
        }
    }

    @Override
    public String toString(Object bean) {
        String result;
        if (bean == null) {
            return null;
        }
        JXPathContext jxcontext = JXPathContext.newContext((Object)bean);
        Object[] args = new Object[this.nbToken];
        for (int i = 0; i < this.nbToken; ++i) {
            try {
                args[i] = this.getTokenValue(jxcontext, this.context.tokens[i]);
                continue;
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)("can not obtain token " + this.context.tokens[i] + " on object of type " + bean.getClass().getName() + " for reason " + e.getMessage()), (Throwable)e);
            }
        }
        try {
            result = String.format(this.context.expression, args);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Could not format " + this.context.expression + "" + " with args : " + Arrays.toString(args)), (Throwable)eee);
            }
            result = "";
        }
        return result;
    }

    public String getProperty(int pos) {
        return this.getTokens()[pos];
    }

    public String getExpression() {
        return this.context.expression;
    }

    public String[] getTokens() {
        return this.context.tokens;
    }

    public int getNbToken() {
        return this.nbToken;
    }

    public String getInitialExpression() {
        return this.initialExpression;
    }

    public String toString() {
        return super.toString() + '<' + this.context + '>';
    }

    public void setContext(Context<O> context) {
        this.context = context;
        this.nbToken = context.tokens.length;
        if (log.isDebugEnabled()) {
            log.debug(context);
        }
    }

    protected Comparator<O> getComparator(int pos) {
        JXPathDecorator.ensureTokenIndex(this, pos);
        return this.context.getComparator(pos);
    }

    protected Comparable<Comparable<?>> getTokenValue(JXPathContext jxcontext, String token) {
        return (Comparable)jxcontext.getValue(token);
    }

    protected static void ensureTokenIndex(JXPathDecorator<?> decorator, int pos) {
        if (pos < -1 || pos > decorator.getNbToken()) {
            throw new ArrayIndexOutOfBoundsException("token index " + pos + " is out of bound, can be inside [" + 0 + ',' + decorator.nbToken + ']');
        }
    }

    public static class Context<O>
    implements Serializable {
        protected String expression;
        protected String[] tokens;
        protected transient Comparator<O> comparator;
        private static final long serialVersionUID = 1L;

        public Context(String expression, String[] tokens) {
            this.expression = expression;
            this.tokens = tokens;
        }

        public String getFirstProperty() {
            return this.tokens[0];
        }

        public Comparator<O> getComparator(int pos) {
            if (this.comparator == null) {
                this.comparator = new JXPathComparator(this.tokens[pos]);
            }
            return this.comparator;
        }

        public void setComparator(Comparator<O> comparator) {
            this.comparator = comparator;
        }

        public String toString() {
            return "<expression:" + this.expression + ", tokens:" + Arrays.toString(this.tokens) + '>';
        }
    }

    public static class JXPathComparator<O>
    implements Comparator<O> {
        protected Map<O, Comparable<Comparable<?>>> valueCache;
        private final String expression;

        public JXPathComparator(String expression) {
            this.expression = expression;
            this.valueCache = new HashMap();
        }

        @Override
        public int compare(O o1, O o2) {
            Comparable<Comparable<?>> c1 = this.valueCache.get(o1);
            Comparable<Comparable<?>> c2 = this.valueCache.get(o2);
            if (c1 == null) {
                if (c2 == null) {
                    return 0;
                }
                return 1;
            }
            if (c2 == null) {
                return -1;
            }
            return c1.compareTo(c2);
        }

        public void clear() {
            this.valueCache.clear();
        }

        public void init(JXPathDecorator<O> decorator, List<O> datas) {
            this.clear();
            for (O data : datas) {
                JXPathContext jxcontext = JXPathContext.newContext(data);
                Comparable<Comparable<?>> key = decorator.getTokenValue(jxcontext, this.expression);
                this.valueCache.put(data, key);
            }
        }
    }
}

