/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.OperationExportRow;
import java.util.List;
import org.nuiton.util.csv.ValueFormatter;

public class OperationExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<OperationExportRow> {
    protected final Caracteristic verticalOpeningCaracteristic;
    protected final Caracteristic horizontalOpeningWingCaracteristic;
    protected final Caracteristic horizontalOpeningDoorCaracteristic;

    public OperationExportModel(char separator, Caracteristic verticalOpeningCaracteristic, Caracteristic horizontalOpeningWingCaracteristic, Caracteristic horizontalOpeningDoorCaracteristic) {
        super(separator);
        this.verticalOpeningCaracteristic = verticalOpeningCaracteristic;
        this.horizontalOpeningWingCaracteristic = horizontalOpeningWingCaracteristic;
        this.horizontalOpeningDoorCaracteristic = horizontalOpeningDoorCaracteristic;
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", "name");
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newColumnForExport("Id_Operation", "stationNumber");
        this.newColumnForExport("NumOrdre_Station", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Engin", "gear", "name");
        this.newColumnForExport("Navire", "vessel", "name");
        this.newColumnForExport("DateDeb_Op", "gearShootingStartDate", (ValueFormatter)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newColumnForExport("LatDeb", "gearShootingStartLatitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("LongDeb", "gearShootingStartLongitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("DateFin_Op", "gearShootingEndDate", (ValueFormatter)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newColumnForExport("LatFin", "gearShootingEndLatitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("LongFin", "gearShootingEndLongitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("Duree", "duration");
        this.newColumnForExport("Strate", "strata", "name", "NA");
        this.newColumnForExport("Sous-Strate", "subStrata", "name", "NA");
        this.newColumnForExport("Localite", "location", "name", "NA");
        this.newColumnForExport("Validite_OP", "fishingOperationValid", (ValueFormatter)TuttiCsvUtil.BOOLEAN);
        this.newColumnForExport("Rectiligne", "fishingOperationRectiligne", (ValueFormatter)TuttiCsvUtil.BOOLEAN);
        this.newColumnForExport("Distance", "trawlDistance", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("Ouv_Verticale", "verticalOpeningGearUseFeature", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newColumnForExport("Ouv_Horizontale_Ailes", "horizontalOpeningWingGearUseFeature", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newColumnForExport("Ouv_Horizontale_Panneaux", "horizontalOpeningDoorGearUseFeature", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newColumnForExport("Commentaire", "comment");
    }

    public void prepareRows(List<OperationExportRow> rows, Cruise cruise, List<FishingOperation> operations) {
        for (FishingOperation operation : operations) {
            OperationExportRow row = new OperationExportRow(this.verticalOpeningCaracteristic, this.horizontalOpeningWingCaracteristic, this.horizontalOpeningDoorCaracteristic);
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            rows.add(row);
        }
    }
}

