/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export;

import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.CatchExportRow;
import fr.ifremer.tutti.service.export.ExportSampleCategory;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.util.csv.ValueFormatter;

public class CatchExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<CatchExportRow> {
    public CatchExportModel(char separator, List<SampleCategoryEnum> samplingOrder) {
        super(separator);
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", "name");
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newColumnForExport("Engin", "gear", "name");
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("Id_Operation", "stationNumber");
        this.newColumnForExport("NumOrdre_Station", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Navire", "vessel", "name");
        this.newColumnForExport("Taxon", "speciesSampleCategory");
        this.newColumnForExport("NumOrdre_Taxon_H2", "speciesSampleCategory");
        this.newColumnForExport("Tot_Taxon", "speciesSampleCategory");
        this.newColumnForExport("Ech_Taxon", "speciesSampleCategory");
        this.newColumnForExport("Type_Volume_Poids_Taxon", "speciesSampleCategory");
        this.newColumnForExport("Unite_Volume_Poids_Taxon", "speciesSampleCategory");
        for (SampleCategoryEnum sampleCategoryEnum : samplingOrder) {
            switch (sampleCategoryEnum) {
                case sortedUnsorted: {
                    this.newColumnForExport("Vrac/Hors_Vrac", "sortedUnsortedSampleCategory");
                    this.newColumnForExport("NumOrdre_Vrac_H2", "sortedUnsortedSampleCategory");
                    this.newColumnForExport("Tot_Vrac", "sortedUnsortedSampleCategory");
                    this.newColumnForExport("Ech_Vrac", "sortedUnsortedSampleCategory");
                    this.newColumnForExport("Type_Volume_Poids_Vrac", "sortedUnsortedSampleCategory");
                    this.newColumnForExport("Unite_Volume_Poids_Vrac", "sortedUnsortedSampleCategory");
                    break;
                }
                case size: {
                    this.newColumnForExport("Categorie", "sizeSampleCategory");
                    this.newColumnForExport("NumOrdre_Cat_H2", "sizeSampleCategory");
                    this.newColumnForExport("Tot_Cat", "sizeSampleCategory");
                    this.newColumnForExport("Ech_Cat", "sizeSampleCategory");
                    this.newColumnForExport("Type_Volume_Poids_Cat", "sizeSampleCategory");
                    this.newColumnForExport("Unite_Volume_Poids_Cat", "sizeSampleCategory");
                    break;
                }
                case sex: {
                    this.newColumnForExport("Sexe", "SexSampleCategory");
                    this.newColumnForExport("NumOrdre_Sexe_H2", "SexSampleCategory");
                    this.newColumnForExport("Tot_Sexe", "SexSampleCategory");
                    this.newColumnForExport("Ech_Sexe", "SexSampleCategory");
                    this.newColumnForExport("Type_Volume_Poids_Sexe", "SexSampleCategory");
                    this.newColumnForExport("Unite_Volume_Poids_Sexe", "SexSampleCategory");
                    break;
                }
                case maturity: {
                    this.newColumnForExport("Maturite", "maturitySampleCategory");
                    this.newColumnForExport("NumOrdre_Maturite_H2", "maturitySampleCategory");
                    this.newColumnForExport("Tot_Maturite", "maturitySampleCategory");
                    this.newColumnForExport("Ech_Maturite", "maturitySampleCategory");
                    this.newColumnForExport("Type_Volume_Poids_Maturite", "maturitySampleCategory");
                    this.newColumnForExport("Unite_Volume_Poids_Maturite", "maturitySampleCategory");
                    break;
                }
                case age: {
                    this.newColumnForExport("Age", "ageSampleCategory");
                    this.newColumnForExport("Num_Ordre_Age_H2", "ageSampleCategory");
                }
            }
        }
        this.newColumnForExport("Code_Longueur", "frequencyLengthStepCaracteristic", "id");
        this.newColumnForExport("Taille", "frequencyLengthStep");
        this.newColumnForExport("NumOrdre_Taille_H2", "headOfMission");
        this.newColumnForExport("Poids_Classe_Taille", "frequencyWeight");
        this.newColumnForExport("Unite_Taille", "frequencyLengthStepCaracteristic");
        this.newColumnForExport("Precision_Mesure", "frequencyLengthStepCaracteristic");
        this.newColumnForExport("Nbr", "frequencyNumber");
        this.newColumnForExport("Poids_Reference", "headOfSortRoom");
        this.newColumnForExport("Coef_Final_Elevation", "comment");
    }

    public void prepareRows(PersistenceService persistenceService, List<CatchExportRow> rows, Cruise cruise, FishingOperation operation, BatchContainer<SpeciesBatch> rootSpeciesBatch, BatchContainer<BenthosBatch> rootBenthosBatch) {
        ExportSampleCategory speciesCategory;
        CatchExportRow row;
        for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
            row = new CatchExportRow();
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            speciesCategory = new ExportSampleCategory();
            speciesCategory.setCategoryValue((Serializable)speciesBatch.getSpecies());
            speciesCategory.setCategoryWeight(speciesBatch.getWeight());
            speciesCategory.setComputedWeight(speciesBatch.getComputedWeight());
            speciesCategory.setNumber(speciesBatch.getNumber());
            speciesCategory.setComputedNumber(speciesBatch.getComputedNumber());
            row.setSpeciesCategory(speciesCategory);
            this.prepareRows(persistenceService, row, rows, speciesBatch);
        }
        for (BenthosBatch benthosBatch : rootBenthosBatch.getChildren()) {
            row = new CatchExportRow();
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            speciesCategory = new ExportSampleCategory();
            speciesCategory.setCategoryValue((Serializable)benthosBatch.getSpecies());
            speciesCategory.setCategoryWeight(benthosBatch.getWeight());
            speciesCategory.setComputedWeight(benthosBatch.getComputedWeight());
            speciesCategory.setNumber(benthosBatch.getNumber());
            speciesCategory.setComputedNumber(benthosBatch.getComputedNumber());
            row.setSpeciesCategory(speciesCategory);
            this.prepareRows(persistenceService, row, rows, benthosBatch);
        }
    }

    public void prepareRows(PersistenceService persistenceService, CatchExportRow currentRow, List<CatchExportRow> rows, SpeciesBatch speciesBatch) {
        ExportSampleCategory sampleCategory = new ExportSampleCategory();
        sampleCategory.setCategoryType(speciesBatch.getSampleCategoryType());
        sampleCategory.setCategoryValue(speciesBatch.getSampleCategoryValue());
        sampleCategory.setCategoryWeight(speciesBatch.getSampleCategoryWeight());
        sampleCategory.setComputedWeight(speciesBatch.getSampleCategoryComputedWeight());
        sampleCategory.setNumber(speciesBatch.getNumber());
        sampleCategory.setComputedNumber(speciesBatch.getComputedNumber());
        currentRow.addCategory(sampleCategory);
        if (speciesBatch.isChildBatchsEmpty()) {
            List<SpeciesBatchFrequency> speciesBatchFrequency = persistenceService.getAllSpeciesBatchFrequency(speciesBatch.getId());
            if (CollectionUtils.isEmpty(speciesBatchFrequency)) {
                rows.add(currentRow.copy());
            } else {
                for (SpeciesBatchFrequency batchFrequency : speciesBatchFrequency) {
                    CatchExportRow row = currentRow.copy();
                    row.setSpeciesFrequency(batchFrequency);
                    rows.add(row);
                }
            }
        } else {
            for (SpeciesBatch childBatch : speciesBatch.getChildBatchs()) {
                this.prepareRows(persistenceService, currentRow, rows, childBatch);
            }
        }
    }

    public void prepareRows(PersistenceService persistenceService, CatchExportRow currentRow, List<CatchExportRow> rows, BenthosBatch benthosBatch) {
    }
}

