package fr.ifremer.tutti.ui.swing.content.operation.catches.accidental;

/*
 * #%L
 * Tutti :: UI
 * $Id: AccidentalBatchTableModel.java 827 2013-04-18 19:11:54Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/accidental/AccidentalBatchTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import org.jdesktop.swingx.table.TableColumnModelExt;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class AccidentalBatchTableModel extends AbstractTuttiTableModel<AccidentalBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final ColumnIdentifier<AccidentalBatchRowModel> SPECIES = ColumnIdentifier.newId(
            AccidentalBatchRowModel.PROPERTY_SPECIES,
            n_("tutti.editAccidentalBatch.table.header.species"),
            n_("tutti.editAccidentalBatch.table.header.species.tip"));

    public static final ColumnIdentifier<AccidentalBatchRowModel> GENDER = ColumnIdentifier.newId(
            AccidentalBatchRowModel.PROPERTY_GENDER,
            n_("tutti.editAccidentalBatch.table.header.gender"),
            n_("tutti.editAccidentalBatch.table.header.gender.tip"));

    public static final ColumnIdentifier<AccidentalBatchRowModel> WEIGHT = ColumnIdentifier.newId(
            AccidentalBatchRowModel.PROPERTY_WEIGHT,
            n_("tutti.editAccidentalBatch.table.header.weight"),
            n_("tutti.editAccidentalBatch.table.header.weight.tip"));

    public static final ColumnIdentifier<AccidentalBatchRowModel> SIZE = ColumnIdentifier.newId(
            AccidentalBatchRowModel.PROPERTY_SIZE,
            n_("tutti.editAccidentalBatch.table.header.size"),
            n_("tutti.editAccidentalBatch.table.header.size.tip"));

    public static final ColumnIdentifier<AccidentalBatchRowModel> LENGTH_STEP_CARACTERISTIC = ColumnIdentifier.newId(
            AccidentalBatchRowModel.PROPERTY_LENGTH_STEP_CARACTERISTIC,
            n_("tutti.editAccidentalBatch.table.header.lengthStepCaracteristic"),
            n_("tutti.editAccidentalBatch.table.header.lengthStepCaracteristic.tip"));

    public static final ColumnIdentifier<AccidentalBatchRowModel> DEAD_OR_ALIVE = ColumnIdentifier.newId(
            AccidentalBatchRowModel.PROPERTY_DEAD_OR_ALIVE,
            n_("tutti.editAccidentalBatch.table.header.deadOrAlive"),
            n_("tutti.editAccidentalBatch.table.header.deadOrAlive.tip"));

    public static final ColumnIdentifier<AccidentalBatchRowModel> OTHER_CARACTERISTICS = ColumnIdentifier.newId(
            IndividualObservationBatchRowModel.PROPERTY_CARACTERISTICS,
            n_("tutti.editAccidentalBatch.table.header.otherCaracteristics"),
            n_("tutti.editAccidentalBatch.table.header.otherCaracteristics.tip"));

    public static final ColumnIdentifier<AccidentalBatchRowModel> COMMENT = ColumnIdentifier.newId(
            AccidentalBatchRowModel.PROPERTY_COMMENT,
            n_("tutti.editAccidentalBatch.table.header.comment"),
            n_("tutti.editAccidentalBatch.table.header.comment.tip"));

    public static final ColumnIdentifier<AccidentalBatchRowModel> ATTACHMENT = ColumnIdentifier.newReadOnlyId(
            AccidentalBatchRowModel.PROPERTY_ATTACHMENT,
            n_("tutti.editAccidentalBatch.table.header.file"),
            n_("tutti.editAccidentalBatch.table.header.file.tip"));


    public AccidentalBatchTableModel(TableColumnModelExt columnModel) {
        super(columnModel, false, false);

        setNoneEditableCols();
    }

    @Override
    public AccidentalBatchRowModel createNewRow() {
        AccidentalBatchRowModel result = new AccidentalBatchRowModel();

        // by default empty row is not valid
        result.setValid(false);
        return result;
    }
}