package fr.ifremer.tutti.ui.swing.content.operation.catches.plankton;

/*
 * #%L
 * Tutti :: UI
 * $Id: PlanktonBatchUIModel.java 105 2012-12-21 20:51:46Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/plankton/PlanktonBatchUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class PlanktonBatchUIModel extends AbstractTuttiBatchUIModel<PlanktonBatchRowModel, PlanktonBatchUIModel> {

    private static final long serialVersionUID = 1L;

    public PlanktonBatchUIModel(EditCatchesUIModel catchesUIModel) {
        super(catchesUIModel,
              EditCatchesUIModel.PROPERTY_PLANKTON_TOTAL_WEIGHT,
              EditCatchesUIModel.PROPERTY_PLANKTON_TOTAL_SAMPLE_WEIGHT);
    }

    public Float getPlanktonTotalWeight() {
        return catchesUIModel.getPlanktonTotalWeight();
    }

    public void setPlanktonTotalWeight(Float planktonTotalWeight) {
        catchesUIModel.setPlanktonTotalWeight(planktonTotalWeight);
    }

    public Float getPlanktonTotalSampleWeight() {
        return catchesUIModel.getPlanktonTotalSampleWeight();
    }

    public void setPlanktonTotalSampleWeight(Float planktonTotalSampleWeight) {
        catchesUIModel.setPlanktonTotalSampleWeight(planktonTotalSampleWeight);
    }
}