/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import fr.ifremer.tutti.persistence.TuttiPersistenceServiceImplementor;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.ObjectType;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Zone;
import java.util.List;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public interface ReferentialPersistenceService
extends TuttiPersistenceServiceImplementor {
    @Cacheable(value={"programZones"})
    public List<Zone> getAllProgramZone();

    public List<Country> getAllCountry();

    public List<FishingOperationLocation> getAllFishingOperationStrata(String var1);

    public List<FishingOperationLocation> getAllFishingOperationSubStrata(String var1, String var2);

    public List<FishingOperationLocation> getAllFishingOperationLocation(String var1, String var2, String var3);

    public FishingOperationLocation getFishingOperationLocation(String var1);

    public List<Vessel> getAllScientificVessel();

    @Cacheable(value={"fishingVessels"})
    public List<Vessel> getAllFishingVessel();

    @Cacheable(value={"vesselByCode"}, key="#vesselCode")
    public Vessel getVessel(String var1);

    @Cacheable(value={"referentSpecies"})
    public List<Species> getAllReferentSpecies();

    @Cacheable(value={"species"})
    public List<Species> getAllSpecies();

    @Cacheable(value={"referentSpeciesById"}, key="#referenceTaxonId", condition="#referenceTaxonId != null")
    public Species getSpeciesByReferenceTaxonId(Integer var1);

    @Cacheable(value={"pmfms"})
    public List<Caracteristic> getAllCaracteristic();

    public List<Caracteristic> getAllNumericCaracteristic();

    @Cacheable(value={"objectTypes"})
    public List<ObjectType> getAllObjectType();

    public Caracteristic getSizeCategoryCaracteristic();

    public Caracteristic getSexCaracteristic();

    public Caracteristic getSortedUnsortedCaracteristic();

    public Caracteristic getMaturityCaracteristic();

    public Caracteristic getAgeCaracteristic();

    public Caracteristic getMacroWasteCategoryCaracteristic();

    public Caracteristic getMacroWasteSizeCategoryCaracteristic();

    public List<Gear> getAllScientificGear();

    public List<Gear> getAllFishingGear();

    @Cacheable(value={"persons"})
    public List<Person> getAllPerson();

    @Cacheable(value={"personById"}, key="#personId")
    public Person getPerson(Integer var1);

    public Gear getGear(Integer var1);

    @Cacheable(value={"pmfmById"}, key="#pmfmId")
    public Caracteristic getCaracteristic(Integer var1);

    @Cacheable(value={"objectTypeByCode"}, key="#objectTypeCode")
    public ObjectType getObjectType(String var1);

    public boolean isSortedQualitativeValue(CaracteristicQualitativeValue var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"species", "referentSpecies", "referentSpeciesById"}, allEntries=true)
    public List<Species> importTemporarySpecies(List<Species> var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"fishingVessels", "vesselByCode"}, allEntries=true)
    public List<Vessel> importTemporaryVessel(List<Vessel> var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"persons", "personById"}, allEntries=true)
    public List<Person> importTemporaryPerson(List<Person> var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"gears"}, allEntries=true)
    public List<Gear> importTemporaryGear(List<Gear> var1);
}

