/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.decorator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.util.decorator.DecoratorUtil;
import org.nuiton.util.decorator.JXPathDecorator;
import org.nuiton.util.decorator.MultiJXPathDecorator;
import org.nuiton.util.decorator.PropertyDecorator;

public abstract class DecoratorProvider {
    private static final Log log = LogFactory.getLog(DecoratorProvider.class);
    protected List<DecoratorContext<?>> decorators;

    public DecoratorProvider() {
        this.loadDecorators();
    }

    protected abstract void loadDecorators();

    public <O> Decorator<O> getDecorator(O object) {
        return this.getDecorator(object, null);
    }

    public <O> Decorator<O> getDecorator(O object, String name) {
        Class<?> k = object.getClass();
        return this.getDecoratorByType(k, name);
    }

    public <O> Decorator<O> getDecoratorByType(Class<O> type) {
        return this.getDecoratorByType(type, null);
    }

    public <O> Decorator<O> getDecoratorByType(Class<O> type, String name) {
        DecoratorContext<O> d = this.getDecoratorContext(type, name);
        return d == null ? null : d.getDecorator();
    }

    public void reload() {
        this.clear();
        this.loadDecorators();
    }

    public void registerPropertyDecorator(Class<?> klass, String expression) {
        this.registerPropertyDecorator(klass, null, expression);
    }

    public void registerJXPathDecorator(Class<?> klass, String expression) {
        this.registerJXPathDecorator(klass, null, expression);
    }

    public void registerMultiJXPathDecorator(Class<?> klass, String expression, String separator, String separatorReplacement) {
        this.registerMultiJXPathDecorator(klass, null, expression, separator, separatorReplacement);
    }

    public void registerPropertyDecorator(Class<?> klass, String name, String expression) {
        PropertyDecorator<?> decorator = DecoratorUtil.newPropertyDecorator(klass, expression);
        this.registerDecorator(name, decorator);
    }

    public void registerJXPathDecorator(Class<?> klass, String name, String expression) {
        JXPathDecorator<?> decorator = DecoratorUtil.newJXPathDecorator(klass, expression);
        this.registerDecorator(name, decorator);
    }

    public void registerMultiJXPathDecorator(Class<?> klass, String name, String expression, String separator, String separatorReplacement) {
        MultiJXPathDecorator<?> decorator = DecoratorUtil.newMultiJXPathDecorator(klass, expression, separator, separatorReplacement);
        this.registerDecorator(name, decorator);
    }

    public void registerDecorator(Decorator<?> decorator) {
        this.registerDecorator(null, decorator);
    }

    public <T> void registerDecorator(String context, Decorator<T> decorator) {
        DecoratorContext<T> result = this.getDecoratorContext(decorator.getType(), context);
        if (result != null) {
            throw new IllegalArgumentException("there is an already register decorator with context " + result);
        }
        DecoratorContext<T> decoratorContext = new DecoratorContext<T>(context, decorator);
        if (log.isDebugEnabled()) {
            log.debug(decoratorContext);
        }
        this.getDecorators().add(decoratorContext);
    }

    public void clear() {
        if (this.decorators != null) {
            this.decorators.clear();
        }
    }

    protected List<DecoratorContext<?>> getDecorators() {
        if (this.decorators == null) {
            this.decorators = new ArrayList();
        }
        return this.decorators;
    }

    protected <T> DecoratorContext<T> getDecoratorContext(Class<T> type, String context) {
        DecoratorContext<T> result = null;
        if (this.decorators != null) {
            for (DecoratorContext<T> decoratorContext : this.decorators) {
                if (type == null) {
                    if (!decoratorContext.accept(context)) continue;
                    result = decoratorContext;
                    break;
                }
                if (!decoratorContext.accept(type, context)) continue;
                result = decoratorContext;
                break;
            }
        }
        return result;
    }

    public static class DecoratorContext<T> {
        final String context;
        final Decorator<T> decorator;

        public DecoratorContext(String context, Decorator<T> decorator) {
            this.context = context;
            this.decorator = decorator;
        }

        public String getContext() {
            return this.context;
        }

        public Decorator<T> getDecorator() {
            return this.decorator;
        }

        public Class<T> getType() {
            return this.decorator.getType();
        }

        public boolean accept(Class<?> type, String context) {
            boolean accept = this.getType().isAssignableFrom(type) && this.accept(context);
            return accept;
        }

        public boolean accept(String context) {
            return this.context == null && context == null || this.context != null && this.context.equals(context);
        }

        public String toString() {
            return super.toString() + "<type: " + this.getType().getName() + ", context :" + this.context + ">";
        }
    }
}

