/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class EditProtocolUIModel
extends AbstractTuttiTableUIModel<TuttiProtocol, EditProtocolSpeciesRowModel, EditProtocolUIModel> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_COMMENT = "comment";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_LENGTH_CLASSES_PMFM_ID = "lengthClassesPmfmId";
    public static final String PROPERTY_GEAR_USE_FEATURE_PMFM_ID = "gearUseFeaturePmfmId";
    public static final String PROPERTY_VESSEL_USE_FEATURE_PMFM_ID = "vesselUseFeaturePmfmId";
    public static final String PROPERTY_REMOVE_SPECIES_ENABLED = "removeSpeciesEnabled";
    public static final String PROPERTY_IMPORTED = "imported";
    public static final String PROPERTY_CLONED = "cloned";
    protected String name;
    protected String comment;
    protected List<String> lengthClassesPmfmId;
    protected List<String> gearUseFeaturePmfmId;
    protected List<String> vesselUseFeaturePmfmId;
    protected boolean imported;
    protected boolean cloned;
    protected boolean removeSpeciesEnabled;
    protected List<Species> allSpecies;
    protected List<Species> allSynonyms;
    protected Multimap<String, Species> allSpeciesByTaxonId;
    protected Map<String, Species> allReferentSpeciesByTaxonId;
    protected List<Caracteristic> caracteristics;
    protected Map<String, Caracteristic> allCaracteristic;
    protected static Binder<EditProtocolUIModel, TuttiProtocol> toBeanBinder = BinderFactory.newBinder(EditProtocolUIModel.class, TuttiProtocol.class);
    protected static Binder<TuttiProtocol, EditProtocolUIModel> fromBeanBinder = BinderFactory.newBinder(TuttiProtocol.class, EditProtocolUIModel.class);
    private List<TuttiProtocol> existingProtocols;

    public EditProtocolUIModel() {
        super(TuttiProtocol.class, fromBeanBinder, toBeanBinder);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.getName();
        this.name = name;
        this.firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.comment = comment;
        this.firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    public List<String> getLengthClassesPmfmId() {
        return this.lengthClassesPmfmId;
    }

    public void setLengthClassesPmfmId(List<String> lengthClassesPmfmId) {
        this.lengthClassesPmfmId = lengthClassesPmfmId;
        this.firePropertyChange(PROPERTY_LENGTH_CLASSES_PMFM_ID, null, lengthClassesPmfmId);
    }

    public void setLengthClassesPmfm(List<Caracteristic> lengthClassesPmfm) {
        List<String> ids = TuttiEntities.collecIds(lengthClassesPmfm);
        this.setLengthClassesPmfmId(ids);
    }

    public List<String> getGearUseFeaturePmfmId() {
        return this.gearUseFeaturePmfmId;
    }

    public void setGearUseFeaturePmfmId(List<String> gearUseFeaturePmfmId) {
        List<String> oldValue = this.getGearUseFeaturePmfmId();
        this.gearUseFeaturePmfmId = gearUseFeaturePmfmId;
        this.firePropertyChange(PROPERTY_GEAR_USE_FEATURE_PMFM_ID, oldValue, gearUseFeaturePmfmId);
    }

    public void setGearUseFeaturePmfm(List<Caracteristic> gearUseFeaturePmfm) {
        List<String> ids = TuttiEntities.collecIds(gearUseFeaturePmfm);
        this.setGearUseFeaturePmfmId(ids);
    }

    public List<String> getVesselUseFeaturePmfmId() {
        return this.vesselUseFeaturePmfmId;
    }

    public void setVesselUseFeaturePmfmId(List<String> vesselUseFeaturePmfmId) {
        List<String> oldValue = this.getVesselUseFeaturePmfmId();
        this.vesselUseFeaturePmfmId = vesselUseFeaturePmfmId;
        this.firePropertyChange(PROPERTY_VESSEL_USE_FEATURE_PMFM_ID, oldValue, vesselUseFeaturePmfmId);
    }

    public void setVesselUseFeaturePmfm(List<Caracteristic> vesselUseFeaturePmfm) {
        List<String> ids = TuttiEntities.collecIds(vesselUseFeaturePmfm);
        this.setVesselUseFeaturePmfmId(ids);
    }

    public boolean isRemoveSpeciesEnabled() {
        return this.removeSpeciesEnabled;
    }

    public void setRemoveSpeciesEnabled(boolean removeSpeciesEnabled) {
        Boolean oldValue = this.isRemoveSpeciesEnabled();
        this.removeSpeciesEnabled = removeSpeciesEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_SPECIES_ENABLED, oldValue, removeSpeciesEnabled);
    }

    public boolean isImported() {
        return this.imported;
    }

    public void setImported(boolean imported) {
        Boolean oldValue = this.isImported();
        this.imported = imported;
        this.firePropertyChange(PROPERTY_IMPORTED, oldValue, imported);
    }

    public boolean isCloned() {
        return this.cloned;
    }

    public void setCloned(boolean cloned) {
        Boolean oldValue = this.isCloned();
        this.cloned = cloned;
        this.firePropertyChange(PROPERTY_CLONED, oldValue, cloned);
    }

    public List<TuttiProtocol> getExistingProtocols() {
        return this.existingProtocols;
    }

    public void setExistingProtocols(List<TuttiProtocol> existingProtocols) {
        this.existingProtocols = existingProtocols;
    }

    public List<Species> getAllSpecies() {
        return this.allSpecies;
    }

    public void setAllSpecies(List<Species> allSpecies) {
        this.allSpecies = allSpecies;
        if (this.allReferentSpeciesByTaxonId != null && allSpecies != null) {
            this.allSynonyms = Lists.newArrayList(allSpecies);
            this.allSynonyms.removeAll(this.allReferentSpeciesByTaxonId.values());
        }
    }

    public Multimap<String, Species> getAllSpeciesByTaxonId() {
        return this.allSpeciesByTaxonId;
    }

    public Collection<Species> getAllSynonyms(String taxonId) {
        return this.allSpeciesByTaxonId.get((Object)taxonId);
    }

    public void setAllSpeciesByTaxonId(Multimap<String, Species> allSpeciesByTaxonId) {
        this.allSpeciesByTaxonId = allSpeciesByTaxonId;
    }

    public List<Species> getAllSynonyms() {
        return this.allSynonyms;
    }

    public Map<String, Species> getAllReferentSpeciesByTaxonId() {
        return this.allReferentSpeciesByTaxonId;
    }

    public void setAllReferentSpeciesByTaxonId(Map<String, Species> allReferentSpeciesByTaxonId) {
        this.allReferentSpeciesByTaxonId = allReferentSpeciesByTaxonId;
        if (allReferentSpeciesByTaxonId != null && this.allSpecies != null) {
            this.allSynonyms = Lists.newArrayList(this.allSpecies);
            this.allSynonyms.removeAll(allReferentSpeciesByTaxonId.values());
        }
    }

    public List<Caracteristic> getCaracteristics() {
        return this.caracteristics;
    }

    public void setCaracteristics(List<Caracteristic> caracteristics) {
        this.caracteristics = caracteristics;
    }

    public Map<String, Caracteristic> getAllCaracteristic() {
        return this.allCaracteristic;
    }

    public void setAllCaracteristic(Map<String, Caracteristic> allCaracteristic) {
        this.allCaracteristic = allCaracteristic;
    }
}

