/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.plankton;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.PlanktonBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.plankton.PlanktonBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.plankton.PlanktonBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.plankton.PlanktonBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.plankton.PlanktonBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellEditor;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.util.decorator.Decorator;

public class PlanktonBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<PlanktonBatchRowModel, PlanktonBatchUIModel, PlanktonBatchUI> {
    private static final Log log = LogFactory.getLog(PlanktonBatchUIHandler.class);

    public PlanktonBatchUIHandler(TuttiUI<?, ?> parentUi, PlanktonBatchUI ui) {
        super(parentUi, ui, "speciesToConfirm", "species", "weight", "comment");
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        PlanktonBatchUIModel model = (PlanktonBatchUIModel)this.getModel();
        if (empty) {
            rows = null;
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Get plankton batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew(bean)) {
                List catches = this.persistenceService.getAllPlanktonBatch(bean.getId());
                for (PlanktonBatch aBatch : catches) {
                    PlanktonBatchRowModel entry = new PlanktonBatchRowModel(aBatch);
                    rows.add(entry);
                }
            }
        }
        model.setRows(rows);
    }

    public PlanktonBatchTableModel getTableModel() {
        return (PlanktonBatchTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((PlanktonBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(PlanktonBatchRowModel row) {
        boolean result = row.getSpecies() != null && row.getWeight() != null;
        return result;
    }

    @Override
    protected void onRowModified(int rowIndex, PlanktonBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<PlanktonBatchRowModel> rowMonitor, PlanktonBatchRowModel row) {
        if (row.isValid()) {
            if (rowMonitor.wasModified()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Row " + row + " was modified, will save it"));
                }
                this.saveRow(row);
                rowMonitor.clearModified();
            }
        } else {
            PlanktonBatch catchBean = (PlanktonBatch)row.toBean();
            if (!TuttiEntities.isNew(catchBean)) {
                this.persistenceService.deletePlanktonBatch(catchBean.getId());
            }
        }
    }

    @Override
    public SwingValidator<PlanktonBatchUIModel> getValidator() {
        return ((PlanktonBatchUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("beforeInit: " + this.ui));
        }
        EditCatchesUIModel catchesUIModel = ((PlanktonBatchUI)this.ui).getContextValue(EditCatchesUIModel.class);
        PlanktonBatchUIModel model = new PlanktonBatchUIModel(catchesUIModel);
        ((PlanktonBatchUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        List allSpecies = this.persistenceService.getAllSpecies();
        Decorator<Species> decorator = this.getDecorator(Species.class, null);
        this.addComboDataColumnToModel((TableColumnModel)columnModel, PlanktonBatchTableModel.SPECIES_BY_CODE, decorator, allSpecies);
        decorator = this.getDecorator(Species.class, null);
        this.addComboDataColumnToModel((TableColumnModel)columnModel, PlanktonBatchTableModel.SPECIES_BY_GENUS_CODE, decorator, allSpecies);
        this.addFloatColumnToModel((TableColumnModel)columnModel, PlanktonBatchTableModel.WEIGHT, "\\d{0,6}|\\d{1,6}\\.\\d{0,3}");
        this.addColumnToModel((TableColumnModel)columnModel, PlanktonBatchTableModel.SAMPLE_WEIGHT);
        this.addColumnToModel((TableColumnModel)columnModel, CommentCellEditor.newEditor(this.ui), CommentCellRenderer.newRender(), PlanktonBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(this.ui), AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null)), PlanktonBatchTableModel.ATTACHMENT);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, PlanktonBatchTableModel.SPECIES_TO_CONFIRM, (JTable)this.getTable());
        PlanktonBatchTableModel tableModel = new PlanktonBatchTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModel)columnModel, tableModel);
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
    }

    protected void saveRow(PlanktonBatchRowModel row) {
        PlanktonBatch catchBean = (PlanktonBatch)row.toBean();
        FishingOperation fishingOperation = ((PlanktonBatchUIModel)this.getModel()).getFishingOperation();
        catchBean.setFishingOperation(fishingOperation);
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected fishingOperation: " + fishingOperation.getId()));
        }
        if (TuttiEntities.isNew(catchBean)) {
            catchBean = this.persistenceService.createPlanktonBatch(catchBean);
            row.setId(catchBean.getId());
        } else {
            this.persistenceService.savePlanktonBatch(catchBean);
        }
    }
}

