/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import fr.ifremer.tutti.persistence.entities.IdAware;
import java.text.ParseException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.csv.Common;
import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ValueParserFormatter;
import org.nuiton.util.csv.ext.AbstractImportExportModel;

public class TuttiCsvUtil {
    protected TuttiCsvUtil() {
    }

    public static class NotExistingKeyValue
    implements ValueParserFormatter<String> {
        protected final String propertyName;
        protected final Set<String> existingValues;

        public NotExistingKeyValue(String propertyName, Set<String> universe) {
            this.propertyName = propertyName;
            this.existingValues = universe;
        }

        public String parse(String value) throws ParseException {
            if (StringUtils.isNotBlank((CharSequence)value) && this.existingValues.contains(value)) {
                throw new RuntimeException("Property '" + this.propertyName + "' with value " + value + " is already defined.");
            }
            return value;
        }

        public String format(String e) {
            return e;
        }
    }

    public static class ForeignKeyValue<E extends IdAware>
    implements ValueParserFormatter<E> {
        protected final String propertyName;
        protected final Class<E> entityType;
        protected final Map<String, E> universe;

        public ForeignKeyValue(Class<E> entityType, String propertyName, Map<String, E> universe) {
            this.entityType = entityType;
            this.propertyName = propertyName;
            this.universe = universe;
        }

        public E parse(String value) throws ParseException {
            IdAware result = null;
            if (StringUtils.isNotBlank((CharSequence)value) && (result = (IdAware)this.universe.get(value)) == null) {
                throw new RuntimeException("Could not find entity of type " + this.entityType.getSimpleName() + " with '" + this.propertyName + "' = " + value);
            }
            return (E)result;
        }

        public String format(E e) {
            String value = "";
            if (e != null) {
                value = e.getId();
            }
            return value;
        }
    }

    public static class StringParserFormatter
    extends Common.NullableParserFormatter<String> {
        public StringParserFormatter(String defaultValue, boolean nullAllowed) {
            super((Object)defaultValue, nullAllowed);
        }

        public String format(String value) {
            String str = "";
            if (value != null) {
                str = String.valueOf(value);
            }
            return str;
        }

        protected String parseNoneEmptyValue(String value) {
            return value;
        }
    }

    public static abstract class AbstractTuttiImportExportModel<M>
    extends AbstractImportExportModel<M> {
        public AbstractTuttiImportExportModel(char separator) {
            super(separator);
        }

        public <E extends IdAware> void newForeignKeyColumn(String headerName, String propertyName, Class<E> entityType, String foreignKeyName, Map<String, E> universe) {
            this.newMandatoryColumn(headerName, propertyName, (ValueParser)this.newForeignKeyValue(entityType, foreignKeyName, universe));
        }

        public <E extends IdAware> void newForeignKeyColumn(String propertyName, Class<E> entityType, String foreignKeyName, Map<String, E> universe) {
            this.newMandatoryColumn(propertyName, propertyName, (ValueParser)this.newForeignKeyValue(entityType, foreignKeyName, universe));
        }

        public <E extends IdAware> ForeignKeyValue<E> newForeignKeyValue(Class<E> type, String propertyName, Map<String, E> universe) {
            return new ForeignKeyValue<E>(type, propertyName, universe);
        }

        public void newNotExistingValueColumn(String propertyName, Set<String> universe) {
            this.newNotExistingValueColumn(propertyName, propertyName, universe);
        }

        public void newNotExistingValueColumn(String headerName, String propertyName, Set<String> universe) {
            this.newMandatoryColumn(headerName, propertyName, (ValueParser)new NotExistingKeyValue(propertyName, universe));
        }
    }
}

