/*
 * Decompiled with CFR 0.152.
 */
package com.ezware.oxbow.swingbits.table.filter;

import com.ezware.oxbow.swingbits.table.filter.FilterTableHeaderRenderer;
import com.ezware.oxbow.swingbits.table.filter.IFilterChangeListener;
import com.ezware.oxbow.swingbits.table.filter.ITableFilter;
import com.ezware.oxbow.swingbits.table.filter.JTableFilter;
import com.ezware.oxbow.swingbits.table.filter.TableFilterColumnPopup;
import com.ezware.oxbow.swingbits.util.IObjectToStringTranslator;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public final class TableRowFilterSupport {
    private boolean searchable = false;
    private IObjectToStringTranslator translator;
    private final ITableFilter<?> filter;
    private boolean actionsVisible = true;
    private boolean useTableRenderers = false;

    private TableRowFilterSupport(ITableFilter<?> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        this.filter = filter;
    }

    public static TableRowFilterSupport forTable(JTable table) {
        return new TableRowFilterSupport(new JTableFilter(table));
    }

    public static TableRowFilterSupport forFilter(ITableFilter<?> filter) {
        return new TableRowFilterSupport(filter);
    }

    public TableRowFilterSupport actions(boolean visible) {
        this.actionsVisible = visible;
        return this;
    }

    public TableRowFilterSupport searchable(boolean serachable) {
        this.searchable = serachable;
        return this;
    }

    public TableRowFilterSupport searchTransalator(IObjectToStringTranslator translator) {
        this.translator = translator;
        return this;
    }

    public TableRowFilterSupport useTableRenderers(boolean value) {
        this.useTableRenderers = value;
        return this;
    }

    public JTable apply() {
        TableFilterColumnPopup filterPopup = new TableFilterColumnPopup(this.filter);
        filterPopup.setEnabled(true);
        filterPopup.setActionsVisible(this.actionsVisible);
        filterPopup.setSearchable(this.searchable);
        filterPopup.setSearchTranslator(this.translator);
        filterPopup.setUseTableRenderers(this.useTableRenderers);
        this.setupTableHeader();
        return this.filter.getTable();
    }

    private void setupTableHeader() {
        Object table = this.filter.getTable();
        this.filter.addChangeListener(new IFilterChangeListener((JTable)table){
            private final /* synthetic */ JTable val$table;
            {
                this.val$table = jTable;
            }

            @Override
            public void filterChanged(ITableFilter<?> filter) {
                this.val$table.getTableHeader().repaint();
            }
        });
        this.setupHeaderRenderers(((JTable)table).getModel(), true);
    }

    private void setupHeaderRenderers(TableModel newModel, boolean fullSetup) {
        Object table = this.filter.getTable();
        FilterTableHeaderRenderer headerRenderer = new FilterTableHeaderRenderer(this.filter);
        this.filter.modelChanged(newModel);
        for (TableColumn c : Collections.list(((JTable)table).getColumnModel().getColumns())) {
            c.setHeaderRenderer(headerRenderer);
        }
        if (!fullSetup) {
            return;
        }
        ((Container)table).addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                TableRowFilterSupport.this.setupHeaderRenderers((TableModel)e.getNewValue(), false);
            }
        });
    }
}

