/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.programStrategy.ProgramDao;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassification;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassificationImpl;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.location.LocationClassification;
import fr.ifremer.adagio.core.dao.referential.location.LocationDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupType;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupTypeImpl;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Zone;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.ProgramPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="programPersistenceService")
public class ProgramPersistenceServiceImpl
extends AbstractPersistenceService
implements ProgramPersistenceService {
    private static final Log log = LogFactory.getLog(ProgramPersistenceServiceImpl.class);
    @Autowired
    protected ReferentialPersistenceService referentialService;
    @Resource(name="programDao")
    protected ProgramDao programDao;
    @Resource(name="locationDao")
    protected LocationDao locationDao;
    protected final int maxCodeLengthInDatabase = 40;
    public static final String EMPTY_COMMENT = "$$EMPTY_COMMENT$$";

    @Override
    public List<Program> getAllProgram() {
        String codePattern = "%";
        if (this.enumeration.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX != null) {
            codePattern = this.enumeration.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX + codePattern;
        }
        Iterator<Object[]> list = this.queryList("allPrograms", "codePattern", StringType.INSTANCE, codePattern);
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            Program target = new Program();
            this.loadProgram(target, source, false);
            result.add(target);
        }
        return result;
    }

    @Override
    public Program getProgram(String id) {
        Program result;
        Iterator<Object[]> list = this.queryList("program", "programCode", StringType.INSTANCE, id, "locationLevelId", IntegerType.INSTANCE, this.enumeration.LOCATION_LEVEL_ID_PROGRAM, "locationClassificationId", IntegerType.INSTANCE, this.enumeration.LOCATION_CLASSIFICATION_ID_SECTOR);
        if (list.hasNext()) {
            Object[] source = list.next();
            result = new Program();
            this.loadProgram(result, source, true);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Program createProgram(Program bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getName());
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create program with name: " + bean.getName()));
        }
        fr.ifremer.adagio.core.dao.administration.programStrategy.Program program = Program.Factory.newInstance();
        this.beanToEntity(bean, program, true);
        program = this.programDao.create(program);
        bean.setId(String.valueOf(program.getCode()));
        return bean;
    }

    @Override
    public Program saveProgram(Program bean) {
        fr.ifremer.adagio.core.dao.administration.programStrategy.Program program;
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getName());
        Preconditions.checkNotNull((Object)bean.getId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create program with name: " + bean.getName()));
        }
        if ((program = this.programDao.load(bean.getId())) == null) {
            throw new DataRetrievalFailureException("Could not retrieve program with code=" + bean.getId());
        }
        this.beanToEntity(bean, program, true);
        this.programDao.update(program);
        return bean;
    }

    protected void loadProgram(Program result, Object[] source, boolean loadZone) {
        result.setId((String)source[0]);
        result.setName((String)source[1]);
        result.setComment((String)source[2]);
        if (EMPTY_COMMENT.equals(result.getComment())) {
            result.setComment(null);
        }
        if (loadZone && source[3] != null) {
            Zone zone = new Zone();
            zone.setId(String.valueOf(source[3]));
            zone.setLabel((String)source[4]);
            zone.setName((String)source[5]);
            result.setZone(zone);
        }
    }

    protected void beanToEntity(Program source, fr.ifremer.adagio.core.dao.administration.programStrategy.Program target, boolean copyIfNull) {
        if (target.getDescription() != null && target.getDescription().equals(target.getName())) {
            target.setDescription(null);
        }
        if (target.getCode() == null && source.getName() != null) {
            String programCode = source.getName().toUpperCase().replaceAll(" ", "_");
            if (this.enumeration.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX != null) {
                programCode = this.enumeration.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX + programCode;
            }
            if (programCode.length() > 40) {
                programCode = programCode.substring(0, 39);
            }
            target.setCode(programCode);
            target.setGearClassification((GearClassification)this.load(GearClassificationImpl.class, this.enumeration.GEAR_CLASSIFICIATION_ID_SCIENTIFIC));
            target.setTaxonGroupType((TaxonGroupType)this.load(TaxonGroupTypeImpl.class, (Serializable)((Object)this.enumeration.TAXON_GROUP_TYPE_ID_COMMERCIAL_SPECIES)));
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            target.setCreationDate(calendar.getTime());
        }
        if (copyIfNull && source.getName() == null) {
            target.setName(null);
        } else if (source.getName() != null) {
            target.setName(source.getName());
        }
        if (source.getComment() == null) {
            target.setDescription(EMPTY_COMMENT);
        } else {
            target.setDescription(source.getComment());
        }
        if (copyIfNull && source.getZone() == null) {
            if (target.getLocationClassifications() != null) {
                target.getLocationClassifications().clear();
            }
            if (target.getLocations() != null) {
                target.getLocations().clear();
            }
        } else if (source.getZone() != null && source.getZone().getId() != null) {
            Location location = this.locationDao.load(Integer.valueOf(source.getZone().getId()));
            if (target.getLocationClassifications() == null) {
                target.setLocationClassifications((Collection)Lists.newArrayList((Object[])new LocationClassification[]{location.getLocationClassification()}));
            } else {
                target.getLocationClassifications().clear();
                target.getLocationClassifications().add(location.getLocationClassification());
            }
            if (target.getLocations() == null) {
                target.setLocations((Collection)Lists.newArrayList((Object[])new Location[]{location}));
            } else {
                target.getLocations().clear();
                target.getLocations().add(location);
            }
        }
    }

    public int getProgramNameMaxLength() {
        int maxCodeLengthInDatabase = 40;
        if (this.enumeration.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX == null || this.enumeration.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX.trim().isEmpty()) {
            return maxCodeLengthInDatabase;
        }
        return maxCodeLengthInDatabase - this.enumeration.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX.length();
    }
}

