package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.editor.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextEditorUI;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class SpeciesBatchUI extends JPanel implements TuttiUI<SpeciesBatchUIModel, SpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_SPECIES_BATCH_BUTTON_ENABLED = "createSpeciesBatchButton.enabled";
    public static final String BINDING_FILTER_SPECIES_BATCH_ALL_BUTTON_SELECTED = "filterSpeciesBatchAllButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_LEAF_BUTTON_SELECTED = "filterSpeciesBatchLeafButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_SELECTED = "filterSpeciesBatchRootButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_TEXT = "filterSpeciesBatchRootButton.text";
    public static final String BINDING_REMOVE_SPECIES_BATCH_MENU_ENABLED = "removeSpeciesBatchMenu.enabled";
    public static final String BINDING_REMOVE_SPECIES_SUB_BATCH_MENU_ENABLED = "removeSpeciesSubBatchMenu.enabled";
    public static final String BINDING_RENAME_SPECIES_BATCH_MENU_ENABLED = "renameSpeciesBatchMenu.enabled";
    public static final String BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_MODEL = "speciesTotalInertWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalInertWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_MODEL = "speciesTotalLivingNotItemizedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalLivingNotItemizedWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_BEAN = "speciesTotalSortedWeightField.bean";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "speciesTotalSortedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalSortedWeightField.numberPattern";
    public static final String BINDING_SPLIT_SPECIES_BATCH_MENU_ENABLED = "splitSpeciesBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AttachmentEditorUI attachmentEditor;
    protected JButton createSpeciesBatchButton;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected JRadioButton filterSpeciesBatchAllButton;
    protected JLabel filterSpeciesBatchLabel;
    protected JRadioButton filterSpeciesBatchLeafButton;
    protected JAXXButtonGroup filterSpeciesBatchMode;
    protected JRadioButton filterSpeciesBatchRootButton;
    protected JPanel filterTablePane;
    protected Table form;
    protected SpeciesBatchUIHandler handler;
    protected SpeciesBatchUI homePanel = this;
    protected LongTextEditorUI longTextEditor;
    protected SpeciesBatchUIModel model;
    protected JMenuItem removeSpeciesBatchMenu;
    protected JMenuItem removeSpeciesSubBatchMenu;
    protected JMenuItem renameSpeciesBatchMenu;
    protected NumberEditor speciesTotalInertWeightField;
    protected JLabel speciesTotalInertWeightLabel;
    protected NumberEditor speciesTotalLivingNotItemizedWeightField;
    protected JLabel speciesTotalLivingNotItemizedWeightLabel;
    protected JTextField speciesTotalSampleSortedWeightField;
    protected JLabel speciesTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSortedWeight",  editorName = "speciesTotalSortedWeightField")
    protected TuttiComputedOrNotDataEditor speciesTotalSortedWeightField;
    protected JLabel speciesTotalSortedWeightLabel;
    protected JTextField speciesTotalUnsortedWeightField;
    protected JLabel speciesTotalUnsortedWeightLabel;
    protected JTextField speciesTotalWeightField;
    protected JLabel speciesTotalWeightLabel;
    protected JMenuItem splitSpeciesBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<SpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            SpeciesBatchUIHandler handler = new SpeciesBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public SpeciesBatchUI() {
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createSpeciesBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createSpeciesBatch();
    }

    public void doActionPerformed__on__filterSpeciesBatchAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ALL);
    }

    public void doActionPerformed__on__filterSpeciesBatchLeafButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.LEAF);
    }

    public void doActionPerformed__on__filterSpeciesBatchRootButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ROOT);
    }

    public void doActionPerformed__on__splitSpeciesBatchMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.splitSpeciesBatch();
    }

    public void doFocusLost__on__table(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveSelectedRowIfRequired(event);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentEditorUI getAttachmentEditor() {
        return attachmentEditor;
    }

    public JButton getCreateSpeciesBatchButton() {
        return createSpeciesBatchButton;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public JRadioButton getFilterSpeciesBatchAllButton() {
        return filterSpeciesBatchAllButton;
    }

    public JLabel getFilterSpeciesBatchLabel() {
        return filterSpeciesBatchLabel;
    }

    public JRadioButton getFilterSpeciesBatchLeafButton() {
        return filterSpeciesBatchLeafButton;
    }

    public JAXXButtonGroup getFilterSpeciesBatchMode() {
        return filterSpeciesBatchMode;
    }

    public JRadioButton getFilterSpeciesBatchRootButton() {
        return filterSpeciesBatchRootButton;
    }

    public JPanel getFilterTablePane() {
        return filterTablePane;
    }

    public Table getForm() {
        return form;
    }

    public SpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public LongTextEditorUI getLongTextEditor() {
        return longTextEditor;
    }

    public SpeciesBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveSpeciesBatchMenu() {
        return removeSpeciesBatchMenu;
    }

    public JMenuItem getRemoveSpeciesSubBatchMenu() {
        return removeSpeciesSubBatchMenu;
    }

    public JMenuItem getRenameSpeciesBatchMenu() {
        return renameSpeciesBatchMenu;
    }

    public NumberEditor getSpeciesTotalInertWeightField() {
        return speciesTotalInertWeightField;
    }

    public JLabel getSpeciesTotalInertWeightLabel() {
        return speciesTotalInertWeightLabel;
    }

    public NumberEditor getSpeciesTotalLivingNotItemizedWeightField() {
        return speciesTotalLivingNotItemizedWeightField;
    }

    public JLabel getSpeciesTotalLivingNotItemizedWeightLabel() {
        return speciesTotalLivingNotItemizedWeightLabel;
    }

    public JTextField getSpeciesTotalSampleSortedWeightField() {
        return speciesTotalSampleSortedWeightField;
    }

    public JLabel getSpeciesTotalSampleSortedWeightLabel() {
        return speciesTotalSampleSortedWeightLabel;
    }

    public TuttiComputedOrNotDataEditor getSpeciesTotalSortedWeightField() {
        return speciesTotalSortedWeightField;
    }

    public JLabel getSpeciesTotalSortedWeightLabel() {
        return speciesTotalSortedWeightLabel;
    }

    public JTextField getSpeciesTotalUnsortedWeightField() {
        return speciesTotalUnsortedWeightField;
    }

    public JLabel getSpeciesTotalUnsortedWeightLabel() {
        return speciesTotalUnsortedWeightLabel;
    }

    public JTextField getSpeciesTotalWeightField() {
        return speciesTotalWeightField;
    }

    public JLabel getSpeciesTotalWeightLabel() {
        return speciesTotalWeightLabel;
    }

    public JMenuItem getSplitSpeciesBatchMenu() {
        return splitSpeciesBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<SpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFilterSpeciesBatchAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchAllButton); }
    }

    protected void addChildrenToFilterSpeciesBatchLeafButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchLeafButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchLeafButton); }
    }

    protected void addChildrenToFilterSpeciesBatchRootButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchRootButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchRootButton); }
    }

    protected void addChildrenToFilterTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        filterTablePane.add(filterSpeciesBatchLabel);
        filterTablePane.add(filterSpeciesBatchAllButton);
        filterTablePane.add(filterSpeciesBatchLeafButton);
        filterTablePane.add(filterSpeciesBatchRootButton);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(speciesTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSortedWeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSortedWeightField), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSampleSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSampleSortedWeightField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalUnsortedWeightLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalUnsortedWeightField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalInertWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalInertWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalLivingNotItemizedWeightLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalLivingNotItemizedWeightField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(tableToolbar, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(longTextEditor);
        add(attachmentEditor);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(splitSpeciesBatchMenu);
        tablePopup.add(removeSpeciesBatchMenu);
        tablePopup.add(removeSpeciesSubBatchMenu);
        tablePopup.add(renameSpeciesBatchMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add(createSpeciesBatchButton, BorderLayout.WEST);
        tableToolbar.add(filterTablePane, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAttachmentEditor() {
        $objectMap.put("attachmentEditor", attachmentEditor = new AttachmentEditorUI());
        
        attachmentEditor.setName("attachmentEditor");
    }

    protected void createCreateSpeciesBatchButton() {
        $objectMap.put("createSpeciesBatchButton", createSpeciesBatchButton = new JButton());
        
        createSpeciesBatchButton.setName("createSpeciesBatchButton");
        createSpeciesBatchButton.setText(_("tutti.action.createSpeciesBatch"));
        createSpeciesBatchButton.setMnemonic(67);
        createSpeciesBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createSpeciesBatchButton"));
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createFilterSpeciesBatchAllButton() {
        $objectMap.put("filterSpeciesBatchAllButton", filterSpeciesBatchAllButton = new JRadioButton());
        
        filterSpeciesBatchAllButton.setName("filterSpeciesBatchAllButton");
        filterSpeciesBatchAllButton.setText(_("tutti.label.filterSpeciesBatchMode.mode.all"));
        { filterSpeciesBatchAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterSpeciesBatchAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchAllButton.setToolTipText(_("tutti.label.filterSpeciesBatchMode.mode.all.tip"));
        filterSpeciesBatchAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchAllButton"));
    }

    protected void createFilterSpeciesBatchLabel() {
        $objectMap.put("filterSpeciesBatchLabel", filterSpeciesBatchLabel = new JLabel());
        
        filterSpeciesBatchLabel.setName("filterSpeciesBatchLabel");
        filterSpeciesBatchLabel.setText(_("tutti.label.filterSpeciesBatchMode.label"));
        filterSpeciesBatchLabel.setToolTipText(_("tutti.label.filterSpeciesBatchMode.label.tip"));
        filterSpeciesBatchLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterSpeciesBatchLeafButton() {
        $objectMap.put("filterSpeciesBatchLeafButton", filterSpeciesBatchLeafButton = new JRadioButton());
        
        filterSpeciesBatchLeafButton.setName("filterSpeciesBatchLeafButton");
        filterSpeciesBatchLeafButton.setText(_("tutti.label.filterSpeciesBatchMode.mode.leaf"));
        { filterSpeciesBatchLeafButton.putClientProperty("$value", "leaf");  Object $buttonGroup = filterSpeciesBatchLeafButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchLeafButton.setToolTipText(_("tutti.label.filterSpeciesBatchMode.mode.leaf.tip"));
        filterSpeciesBatchLeafButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchLeafButton"));
    }

    protected void createFilterSpeciesBatchMode() {
        $objectMap.put("filterSpeciesBatchMode", filterSpeciesBatchMode = new JAXXButtonGroup());
    }

    protected void createFilterSpeciesBatchRootButton() {
        $objectMap.put("filterSpeciesBatchRootButton", filterSpeciesBatchRootButton = new JRadioButton());
        
        filterSpeciesBatchRootButton.setName("filterSpeciesBatchRootButton");
        { filterSpeciesBatchRootButton.putClientProperty("$value", "root");  Object $buttonGroup = filterSpeciesBatchRootButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchRootButton.setToolTipText(_("tutti.label.filterSpeciesBatchMode.mode.root.tip"));
        filterSpeciesBatchRootButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchRootButton"));
    }

    protected void createFilterTablePane() {
        $objectMap.put("filterTablePane", filterTablePane = new JPanel());
        
        filterTablePane.setName("filterTablePane");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SpeciesBatchUIHandler.class));
    }

    protected void createLongTextEditor() {
        $objectMap.put("longTextEditor", longTextEditor = new LongTextEditorUI());
        
        longTextEditor.setName("longTextEditor");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SpeciesBatchUIModel.class));
    }

    protected void createRemoveSpeciesBatchMenu() {
        $objectMap.put("removeSpeciesBatchMenu", removeSpeciesBatchMenu = new JMenuItem());
        
        removeSpeciesBatchMenu.setName("removeSpeciesBatchMenu");
        removeSpeciesBatchMenu.setMnemonic(82);
        removeSpeciesBatchMenu.putClientProperty("tuttiAction", RemoveSpeciesBatchAction.class);
    }

    protected void createRemoveSpeciesSubBatchMenu() {
        $objectMap.put("removeSpeciesSubBatchMenu", removeSpeciesSubBatchMenu = new JMenuItem());
        
        removeSpeciesSubBatchMenu.setName("removeSpeciesSubBatchMenu");
        removeSpeciesSubBatchMenu.setMnemonic(82);
        removeSpeciesSubBatchMenu.putClientProperty("tuttiAction", RemoveSpeciesSubBatchAction.class);
    }

    protected void createRenameSpeciesBatchMenu() {
        $objectMap.put("renameSpeciesBatchMenu", renameSpeciesBatchMenu = new JMenuItem());
        
        renameSpeciesBatchMenu.setName("renameSpeciesBatchMenu");
        renameSpeciesBatchMenu.putClientProperty("tuttiAction", RenameSpeciesBatchAction.class);
    }

    protected void createSpeciesTotalInertWeightField() {
        $objectMap.put("speciesTotalInertWeightField", speciesTotalInertWeightField = new NumberEditor(this));
        
        speciesTotalInertWeightField.setName("speciesTotalInertWeightField");
        speciesTotalInertWeightField.setProperty("speciesTotalInertWeight");
        speciesTotalInertWeightField.setUseFloat(true);
        speciesTotalInertWeightField.setShowReset(false);
    }

    protected void createSpeciesTotalInertWeightLabel() {
        $objectMap.put("speciesTotalInertWeightLabel", speciesTotalInertWeightLabel = new JLabel());
        
        speciesTotalInertWeightLabel.setName("speciesTotalInertWeightLabel");
        speciesTotalInertWeightLabel.setText(_("tutti.label.catches.speciesTotalInertWeight"));
    }

    protected void createSpeciesTotalLivingNotItemizedWeightField() {
        $objectMap.put("speciesTotalLivingNotItemizedWeightField", speciesTotalLivingNotItemizedWeightField = new NumberEditor(this));
        
        speciesTotalLivingNotItemizedWeightField.setName("speciesTotalLivingNotItemizedWeightField");
        speciesTotalLivingNotItemizedWeightField.setProperty("speciesTotalLivingNotItemizedWeight");
        speciesTotalLivingNotItemizedWeightField.setUseFloat(true);
        speciesTotalLivingNotItemizedWeightField.setShowReset(false);
    }

    protected void createSpeciesTotalLivingNotItemizedWeightLabel() {
        $objectMap.put("speciesTotalLivingNotItemizedWeightLabel", speciesTotalLivingNotItemizedWeightLabel = new JLabel());
        
        speciesTotalLivingNotItemizedWeightLabel.setName("speciesTotalLivingNotItemizedWeightLabel");
        speciesTotalLivingNotItemizedWeightLabel.setText(_("tutti.label.catches.speciesTotalLivingNotItemizedWeight"));
    }

    protected void createSpeciesTotalSampleSortedWeightField() {
        $objectMap.put("speciesTotalSampleSortedWeightField", speciesTotalSampleSortedWeightField = new JTextField());
        
        speciesTotalSampleSortedWeightField.setName("speciesTotalSampleSortedWeightField");
        speciesTotalSampleSortedWeightField.setColumns(15);
        speciesTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalSampleSortedWeightLabel() {
        $objectMap.put("speciesTotalSampleSortedWeightLabel", speciesTotalSampleSortedWeightLabel = new JLabel());
        
        speciesTotalSampleSortedWeightLabel.setName("speciesTotalSampleSortedWeightLabel");
        speciesTotalSampleSortedWeightLabel.setText(_("tutti.label.catches.speciesTotalSampleSortedWeight"));
    }

    protected void createSpeciesTotalSortedWeightField() {
        $objectMap.put("speciesTotalSortedWeightField", speciesTotalSortedWeightField = new TuttiComputedOrNotDataEditor(this));
        
        speciesTotalSortedWeightField.setName("speciesTotalSortedWeightField");
        speciesTotalSortedWeightField.setDecimalNumber(3);
        speciesTotalSortedWeightField.setUseFloat(true);
        speciesTotalSortedWeightField.setShowReset(true);
    }

    protected void createSpeciesTotalSortedWeightLabel() {
        $objectMap.put("speciesTotalSortedWeightLabel", speciesTotalSortedWeightLabel = new JLabel());
        
        speciesTotalSortedWeightLabel.setName("speciesTotalSortedWeightLabel");
        speciesTotalSortedWeightLabel.setText(_("tutti.label.catches.speciesTotalSortedWeight"));
    }

    protected void createSpeciesTotalUnsortedWeightField() {
        $objectMap.put("speciesTotalUnsortedWeightField", speciesTotalUnsortedWeightField = new JTextField());
        
        speciesTotalUnsortedWeightField.setName("speciesTotalUnsortedWeightField");
        speciesTotalUnsortedWeightField.setColumns(15);
        speciesTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalUnsortedWeightLabel() {
        $objectMap.put("speciesTotalUnsortedWeightLabel", speciesTotalUnsortedWeightLabel = new JLabel());
        
        speciesTotalUnsortedWeightLabel.setName("speciesTotalUnsortedWeightLabel");
        speciesTotalUnsortedWeightLabel.setText(_("tutti.label.catches.speciesTotalUnsortedWeight"));
    }

    protected void createSpeciesTotalWeightField() {
        $objectMap.put("speciesTotalWeightField", speciesTotalWeightField = new JTextField());
        
        speciesTotalWeightField.setName("speciesTotalWeightField");
        speciesTotalWeightField.setColumns(15);
        speciesTotalWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalWeightLabel() {
        $objectMap.put("speciesTotalWeightLabel", speciesTotalWeightLabel = new JLabel());
        
        speciesTotalWeightLabel.setName("speciesTotalWeightLabel");
        speciesTotalWeightLabel.setText(_("tutti.label.catches.speciesTotalWeight"));
    }

    protected void createSplitSpeciesBatchMenu() {
        $objectMap.put("splitSpeciesBatchMenu", splitSpeciesBatchMenu = new JMenuItem());
        
        splitSpeciesBatchMenu.setName("splitSpeciesBatchMenu");
        splitSpeciesBatchMenu.setText(_("tutti.action.splitSpeciesBatch"));
        splitSpeciesBatchMenu.setMnemonic(83);
        splitSpeciesBatchMenu.setToolTipText(_("tutti.action.splitSpeciesBatch.tip"));
        splitSpeciesBatchMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__splitSpeciesBatchMenu"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        addChildrenToFilterTablePane();
        addChildrenToFilterSpeciesBatchAllButton();
        addChildrenToFilterSpeciesBatchLeafButton();
        addChildrenToFilterSpeciesBatchRootButton();
        addChildrenToTableScrollPane();
        
        // apply 16 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 23 property setters
        splitSpeciesBatchMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        speciesTotalWeightLabel.setLabelFor(speciesTotalWeightField);
        speciesTotalSortedWeightLabel.setLabelFor(speciesTotalSortedWeightField);
        speciesTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalSampleSortedWeightLabel.setLabelFor(speciesTotalSampleSortedWeightField);
        speciesTotalUnsortedWeightLabel.setLabelFor(speciesTotalUnsortedWeightField);
        speciesTotalInertWeightLabel.setLabelFor(speciesTotalInertWeightField);
        speciesTotalInertWeightField.setBean(model);
        speciesTotalInertWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalInertWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalLivingNotItemizedWeightLabel.setLabelFor(speciesTotalLivingNotItemizedWeightField);
        speciesTotalLivingNotItemizedWeightField.setBean(model);
        speciesTotalLivingNotItemizedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalLivingNotItemizedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        createSpeciesBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        filterTablePane.setBorder(new TitledBorder(null, ""));
        filterSpeciesBatchLabel.setIcon(SwingUtil.createActionIcon("filter"));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createLongTextEditor();
        createAttachmentEditor();
        createTablePopup();
        createSplitSpeciesBatchMenu();
        createRemoveSpeciesBatchMenu();
        createRemoveSpeciesSubBatchMenu();
        createRenameSpeciesBatchMenu();
        createForm();
        createSpeciesTotalWeightLabel();
        createSpeciesTotalWeightField();
        createSpeciesTotalSortedWeightLabel();
        createSpeciesTotalSortedWeightField();
        createSpeciesTotalSampleSortedWeightLabel();
        createSpeciesTotalSampleSortedWeightField();
        createSpeciesTotalUnsortedWeightLabel();
        createSpeciesTotalUnsortedWeightField();
        createSpeciesTotalInertWeightLabel();
        createSpeciesTotalInertWeightField();
        createSpeciesTotalLivingNotItemizedWeightLabel();
        createSpeciesTotalLivingNotItemizedWeightField();
        createTableToolbar();
        createCreateSpeciesBatchButton();
        createFilterTablePane();
        createFilterSpeciesBatchLabel();
        createFilterSpeciesBatchAllButton();
        createFilterSpeciesBatchLeafButton();
        createFilterSpeciesBatchRootButton();
        createTableScrollPane();
        createTable();
        createFilterSpeciesBatchMode();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 16 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 16 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPLIT_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("splitSpeciesBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    splitSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isSplitSpeciesBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("splitSpeciesBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeSpeciesBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveSpeciesBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeSpeciesBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_SUB_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeSpeciesSubBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesSubBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveSpeciesSubBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeSpeciesSubBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RENAME_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("renameSpeciesBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    renameSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRenameSpeciesBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("renameSpeciesBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setModel(model.getSpeciesTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setBean(model.getSpeciesTotalSortedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalSortedWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalInertWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalInertWeightField.setModel(model.getSpeciesTotalInertWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalInertWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalInertWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalLivingNotItemizedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalLivingNotItemizedWeightField.setModel(model.getSpeciesTotalLivingNotItemizedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalLivingNotItemizedWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalLivingNotItemizedWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_SPECIES_BATCH_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("createSpeciesBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    createSpeciesBatchButton.setEnabled(model.isCreateSpeciesBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("createSpeciesBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchAllButton.setSelected(model.isTableViewModeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_LEAF_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchLeafButton.setSelected(model.isTableViewModeLeaf());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rootNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchRootButton.setText(_("tutti.label.filterSpeciesBatchMode.mode.root", model.getRootNumber()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rootNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeRoot", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchRootButton.setSelected(model.isTableViewModeRoot());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeRoot", this);
                }
            }
        });
    }

}