package fr.ifremer.tutti.ui.swing.content.db;

/*
 * #%L
 * Tutti :: UI
 * $Id: InstallDbAction.java 421 2013-02-15 14:49:24Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/db/InstallDbAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.ui.swing.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.MainUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationUpdater;

import java.awt.event.ActionEvent;
import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * To install db when no db is attached to Tutti.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class InstallDbAction extends AbstractMainUITuttiAction {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(InstallDbAction.class);

    public InstallDbAction(MainUIHandler handler) {
        super(handler,
              "installDb",
              "install-db",
              _("tutti.action.installDb"),
              _("tutti.action.installDb.tip"),
              true);
    }

    @Override
    protected void doAction(ActionEvent event) {
        TuttiApplicationConfig config = getContext().getConfig();

        File current = config.getDataDirectory();
        String url = config.getUpdateUrl();

        if (log.isInfoEnabled()) {
            log.info(String.format("Try to install db (current data location: %s), using update url: %s", current, url));
        }
        ApplicationUpdater up = new ApplicationUpdater();

        File dest = new File(config.getTuttiBasedir(), "NEW");
        ProgressionModel progressionModel = new ProgressionModel();
        getContext().getActionUI().getModel().setProgressionModel(progressionModel);
        progressionModel.setMessage("Recherche de mises à jour de base");

        TuttiApplicationUpdaterCallBack callback = new TuttiApplicationUpdaterCallBack(getContext(), progressionModel);
        callback.setTypes(TuttiApplicationUpdaterCallBack.UpdateType.DB);

        up.update(url, current, dest, false, callback);

        sendMessage("Nouvelle base de données installée.");

        String jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();

        progressionModel.setMessage(String.format("Ouverture de la base de données *%s*.", jdbcUrl));

        getContext().setDbExist(true);

        // open db
        new OpenDbAction(getHandler()).actionPerformed(event);
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        super.releaseAction(event);
        getContext().getActionUI().getModel().setProgressionModel(null);
    }
}