package fr.ifremer.tutti.ui.swing.content.operation.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: SpeciesBatchTableModel.java 77 2012-12-15 16:05:45Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/species/SpeciesBatchTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Sets;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;

import javax.swing.table.TableColumnModel;
import java.util.Set;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class SpeciesBatchTableModel extends AbstractTuttiTableModel<SpeciesBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES_TO_CONFIRM = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SPECIES_TO_CONFIRM,
            n_("tutti.table.species.batch.header.toConfirm"),
            n_("tutti.table.species.batch.header.toConfirm"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES_BY_CODE = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SPECIES,
            n_("tutti.table.species.batch.header.speciesByCode"),
            n_("tutti.table.species.batch.header.speciesByCode"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES_BY_GENUS_CODE = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SPECIES,
            n_("tutti.table.species.batch.header.speciesByGenusCode"),
            n_("tutti.table.species.batch.header.speciesByGenusCode"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> SORTED_UNSORTED_CATEGORY = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SORTED_UNSORTED_CATEGORY,
            n_("tutti.table.species.batch.header.sortedUnsortedCategory"),
            n_("tutti.table.species.batch.header.sortedUnsortedCategory"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> WEIGHT_CATEGORY = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_WEIGHT_CATEGORY,
            n_("tutti.table.species.batch.header.weightCategory"),
            n_("tutti.table.species.batch.header.weightCategory"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> SEX = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SEX,
            n_("tutti.table.species.batch.header.sex"),
            n_("tutti.table.species.batch.header.sex"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> MATURITY = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_MATURITY,
            n_("tutti.table.species.batch.header.maturity"),
            n_("tutti.table.species.batch.header.maturity"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> AGE = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_AGE,
            n_("tutti.table.species.batch.header.age"),
            n_("tutti.table.species.batch.header.age"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> WEIGHT = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_WEIGHT,
            n_("tutti.table.species.batch.header.weight"),
            n_("tutti.table.species.batch.header.weight"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> COMPUTED_WEIGHT = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_COMPUTED_WEIGHT,
            n_("tutti.table.species.batch.header.computedWeight"),
            n_("tutti.table.species.batch.header.computedWeight"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> COMPUTED_NUMBER = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_COMPUTED_NUMBER,
            n_("tutti.table.species.batch.header.computedNumber"),
            n_("tutti.table.species.batch.header.computedNumber"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> SAMPLE_WEIGHT = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SAMPLE_WEIGHT,
            n_("tutti.table.species.batch.header.sampleWeight"),
            n_("tutti.table.species.batch.header.sampleWeight"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> SAMPLING_RATIO = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SAMPLING_RATIO,
            n_("tutti.table.species.batch.header.elevationRate"),
            n_("tutti.table.species.batch.header.elevationRate"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> COMMENT = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_COMMENT,
            n_("tutti.table.species.batch.header.comment"),
            n_("tutti.table.species.batch.header.comment"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> ATTACHMENTS = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_ATTACHMENTS,
            n_("tutti.table.species.batch.header.file"),
            n_("tutti.table.species.batch.header.file"));


    protected final Set<ColumnIdentifier<SpeciesBatchRowModel>> noneEditableColIfNoSpecies;

    public SpeciesBatchTableModel(TableColumnModel columnModel) {
        super(columnModel);

        setNoneEditableCols(SAMPLE_WEIGHT, SAMPLING_RATIO);
        noneEditableColIfNoSpecies = Sets.newHashSet();
        noneEditableColIfNoSpecies.add(COMPUTED_NUMBER);
        noneEditableColIfNoSpecies.add(COMPUTED_WEIGHT);
    }

    @Override
    protected SpeciesBatchRowModel createNewRow() {
        SpeciesBatchRowModel result = new SpeciesBatchRowModel();

        // by default empty row is not valid
        result.setValid(false);
        return result;
    }

    @Override
    public void setValueAt(Object aValue,
                           int rowIndex,
                           int columnIndex,
                           ColumnIdentifier<SpeciesBatchRowModel> propertyName,
                           SpeciesBatchRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);

        if (propertyName == SPECIES_BY_CODE) {

            // update also other columns
            fireTableCellUpdated(rowIndex,
                                 SPECIES_BY_GENUS_CODE,
                                 COMPUTED_NUMBER,
                                 COMPUTED_WEIGHT);

        } else if (propertyName == SPECIES_BY_GENUS_CODE) {

            // update also other columns
            fireTableCellUpdated(rowIndex,
                                 SPECIES_BY_CODE,
                                 COMPUTED_NUMBER,
                                 COMPUTED_WEIGHT);
        } else if (propertyName == COMPUTED_NUMBER) {

            // update also other columns
            fireTableCellUpdated(rowIndex, COMPUTED_WEIGHT);

        } else if (propertyName == COMPUTED_WEIGHT) {

            // update also other columns
            fireTableCellUpdated(rowIndex, COMPUTED_NUMBER);
        }
    }

    public void updateSamplingRatio(Set<SpeciesBatchRowModel> rows) {
        for (SpeciesBatchRowModel row : rows) {
            int rowIndex = getRows().indexOf(row);
            fireTableCellUpdated(rowIndex, SAMPLE_WEIGHT, SAMPLING_RATIO);
        }


    }

    @Override
    protected boolean isCellEditable(int rowIndex,
                                     int columnIndex,
                                     ColumnIdentifier<SpeciesBatchRowModel> propertyName) {

        boolean result = super.isCellEditable(rowIndex,
                                              columnIndex,
                                              propertyName);
        if (result) {

            if (noneEditableColIfNoSpecies.contains(propertyName)) {

                // must have filled a species to edit this column
                SpeciesBatchRowModel entry = getEntry(rowIndex);
                result = entry.getSpecies() != null;
            }
        }
        return result;
    }
}
