package fr.ifremer.tutti.ui.swing.content.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.BeaufortScaleBean;
import fr.ifremer.tutti.persistence.entities.SeaStateBean;
import fr.ifremer.tutti.persistence.entities.StrataBean;
import fr.ifremer.tutti.persistence.entities.TraitBean;
import fr.ifremer.tutti.persistence.entities.UserBean;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class TraitTabUI extends JPanel implements TuttiUI<TraitTabUIModel, TraitTabUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_AVERAGE_BOTTOM_SALINITY_FIELD_MODEL = "averageBottomSalinityField.model";
    public static final String BINDING_AVERAGE_BOTTOM_SALINITY_FIELD_NUMBER_PATTERN = "averageBottomSalinityField.numberPattern";
    public static final String BINDING_AVERAGE_BOTTOM_TEMPERATURE_FIELD_MODEL = "averageBottomTemperatureField.model";
    public static final String BINDING_AVERAGE_BOTTOM_TEMPERATURE_FIELD_NUMBER_PATTERN = "averageBottomTemperatureField.numberPattern";
    public static final String BINDING_BEAUFORT_SCALE_COMBO_BOX_SELECTED_ITEM = "beaufortScaleComboBox.selectedItem";
    public static final String BINDING_CANCEL_BUTTON_ENABLED = "cancelButton.enabled";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_DATE_FIELD_DATE = "dateField.date";
    public static final String BINDING_DISTANCE_CHALUTEE_FIELD_MODEL = "distanceChaluteeField.model";
    public static final String BINDING_DISTANCE_CHALUTEE_FIELD_NUMBER_PATTERN = "distanceChaluteeField.numberPattern";
    public static final String BINDING_DUREE_FIELD_MODEL = "dureeField.model";
    public static final String BINDING_DUREE_FIELD_NUMBER_PATTERN = "dureeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_BOTTOM_SALINITY_FIELD_MODEL = "gearShootingEndBottomSalinityField.model";
    public static final String BINDING_GEAR_SHOOTING_END_BOTTOM_SALINITY_FIELD_NUMBER_PATTERN = "gearShootingEndBottomSalinityField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_BOTTOM_TEMPERATURE_FIELD_MODEL = "gearShootingEndBottomTemperatureField.model";
    public static final String BINDING_GEAR_SHOOTING_END_BOTTOM_TEMPERATURE_FIELD_NUMBER_PATTERN = "gearShootingEndBottomTemperatureField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_DEPTH_FIELD_MODEL = "gearShootingEndDepthField.model";
    public static final String BINDING_GEAR_SHOOTING_END_DEPTH_FIELD_NUMBER_PATTERN = "gearShootingEndDepthField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_FIELD_TEXT = "gearShootingEndLatitudeField.text";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_FIELD_TEXT = "gearShootingEndLongitudeField.text";
    public static final String BINDING_GEAR_SHOOTING_END_SURFACE_SALINITY_FIELD_MODEL = "gearShootingEndSurfaceSalinityField.model";
    public static final String BINDING_GEAR_SHOOTING_END_SURFACE_SALINITY_FIELD_NUMBER_PATTERN = "gearShootingEndSurfaceSalinityField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_SURFACE_TEMPERATURE_FIELD_MODEL = "gearShootingEndSurfaceTemperatureField.model";
    public static final String BINDING_GEAR_SHOOTING_END_SURFACE_TEMPERATURE_FIELD_NUMBER_PATTERN = "gearShootingEndSurfaceTemperatureField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_TIME_FIELD_TEXT = "gearShootingEndTimeField.text";
    public static final String BINDING_GEAR_SHOOTING_START_BOTTOM_SALINITY_FIELD_MODEL = "gearShootingStartBottomSalinityField.model";
    public static final String BINDING_GEAR_SHOOTING_START_BOTTOM_SALINITY_FIELD_NUMBER_PATTERN = "gearShootingStartBottomSalinityField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_BOTTOM_TEMPERATURE_FIELD_MODEL = "gearShootingStartBottomTemperatureField.model";
    public static final String BINDING_GEAR_SHOOTING_START_BOTTOM_TEMPERATURE_FIELD_NUMBER_PATTERN = "gearShootingStartBottomTemperatureField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_DEPTH_FIELD_MODEL = "gearShootingStartDepthField.model";
    public static final String BINDING_GEAR_SHOOTING_START_DEPTH_FIELD_NUMBER_PATTERN = "gearShootingStartDepthField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_FIELD_TEXT = "gearShootingStartLatitudeField.text";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_FIELD_TEXT = "gearShootingStartLongitudeField.text";
    public static final String BINDING_GEAR_SHOOTING_START_SURFACE_SALINITY_FIELD_MODEL = "gearShootingStartSurfaceSalinityField.model";
    public static final String BINDING_GEAR_SHOOTING_START_SURFACE_SALINITY_FIELD_NUMBER_PATTERN = "gearShootingStartSurfaceSalinityField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_SURFACE_TEMPERATURE_FIELD_MODEL = "gearShootingStartSurfaceTemperatureField.model";
    public static final String BINDING_GEAR_SHOOTING_START_SURFACE_TEMPERATURE_FIELD_NUMBER_PATTERN = "gearShootingStartSurfaceTemperatureField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_TIME_FIELD_TEXT = "gearShootingStartTimeField.text";
    public static final String BINDING_GEOMETRIE_MESUREE_CHECK_BOX_SELECTED = "geometrieMesureeCheckBox.selected";
    public static final String BINDING_LOCALITE_FIELD_TEXT = "localiteField.text";
    public static final String BINDING_LONGUEUR_BRAS_FIELD_MODEL = "longueurBrasField.model";
    public static final String BINDING_LONGUEUR_BRAS_FIELD_NUMBER_PATTERN = "longueurBrasField.numberPattern";
    public static final String BINDING_LONGUEUR_FUNES_FIELD_MODEL = "longueurFunesField.model";
    public static final String BINDING_LONGUEUR_FUNES_FIELD_NUMBER_PATTERN = "longueurFunesField.numberPattern";
    public static final String BINDING_OUVERTURE_HORIZONTALE_FIELD_MODEL = "ouvertureHorizontaleField.model";
    public static final String BINDING_OUVERTURE_HORIZONTALE_FIELD_NUMBER_PATTERN = "ouvertureHorizontaleField.numberPattern";
    public static final String BINDING_OUVERTURE_VERTICALE_FIELD_MODEL = "ouvertureVerticaleField.model";
    public static final String BINDING_OUVERTURE_VERTICALE_FIELD_NUMBER_PATTERN = "ouvertureVerticaleField.numberPattern";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SEA_STATE_COMBO_BOX_SELECTED_ITEM = "seaStateComboBox.selectedItem";
    public static final String BINDING_STATION_NUMBER_FIELD_MODEL = "stationNumberField.model";
    public static final String BINDING_STATION_NUMBER_FIELD_NUMBER_PATTERN = "stationNumberField.numberPattern";
    public static final String BINDING_STRATA_COMBO_BOX_SELECTED_ITEM = "strataComboBox.selectedItem";
    public static final String BINDING_SYSTEME_FERMETURE_CUL_CHECK_BOX_SELECTED = "systemeFermetureCulCheckBox.selected";
    public static final String BINDING_TRAIT_NUMBER_FIELD_MODEL = "traitNumberField.model";
    public static final String BINDING_TRAIT_NUMBER_FIELD_NUMBER_PATTERN = "traitNumberField.numberPattern";
    public static final String BINDING_TRAIT_RECTILIGNE_CHECK_BOX_SELECTED = "traitRectiligneCheckBox.selected";
    public static final String BINDING_TRAIT_VALID_CHECK_BOX_SELECTED = "traitValidCheckBox.selected";
    public static final String BINDING_WIND_DIRECTION_FIELD_MODEL = "windDirectionField.model";
    public static final String BINDING_WIND_DIRECTION_FIELD_NUMBER_PATTERN = "windDirectionField.numberPattern";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(TraitTabUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected NumberEditor averageBottomSalinityField;
    protected JLabel averageBottomSalinityLabel;
    protected NumberEditor averageBottomTemperatureField;
    protected JLabel averageBottomTemperatureLabel;
    protected BeanComboBox<BeaufortScaleBean> beaufortScaleComboBox;
    protected JLabel beaufortScaleLabel;
    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentField")
    protected JTextArea commentField;
    protected JScrollPane commentPane;
    @ValidatorField( validatorId = "validator",  propertyName = "date",  editorName = "dateField")
    protected JXDatePicker dateField;
    protected JLabel dateLabel;
    protected JLabel distanceChaluteeDureeLabel;
    protected NumberEditor distanceChaluteeField;
    protected NumberEditor dureeField;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected NumberEditor gearShootingEndBottomSalinityField;
    protected JLabel gearShootingEndBottomSalinityLabel;
    protected NumberEditor gearShootingEndBottomTemperatureField;
    protected JLabel gearShootingEndBottomTemperatureLabel;
    protected NumberEditor gearShootingEndDepthField;
    protected JLabel gearShootingEndDepthLabel;
    protected JTextField gearShootingEndLatitudeField;
    protected JLabel gearShootingEndLatitudeLabel;
    protected JTextField gearShootingEndLongitudeField;
    protected JLabel gearShootingEndLongitudeLabel;
    protected NumberEditor gearShootingEndSurfaceSalinityField;
    protected JLabel gearShootingEndSurfaceSalinityLabel;
    protected NumberEditor gearShootingEndSurfaceTemperatureField;
    protected JLabel gearShootingEndSurfaceTemperatureLabel;
    protected JTextField gearShootingEndTimeField;
    protected JLabel gearShootingEndTimeLabel;
    protected Table gearShootingForm;
    protected NumberEditor gearShootingStartBottomSalinityField;
    protected JLabel gearShootingStartBottomSalinityLabel;
    protected NumberEditor gearShootingStartBottomTemperatureField;
    protected JLabel gearShootingStartBottomTemperatureLabel;
    protected NumberEditor gearShootingStartDepthField;
    protected JLabel gearShootingStartDepthLabel;
    protected JTextField gearShootingStartLatitudeField;
    protected JLabel gearShootingStartLatitudeLabel;
    protected JTextField gearShootingStartLongitudeField;
    protected JLabel gearShootingStartLongitudeLabel;
    protected NumberEditor gearShootingStartSurfaceSalinityField;
    protected JLabel gearShootingStartSurfaceSalinityLabel;
    protected NumberEditor gearShootingStartSurfaceTemperatureField;
    protected JLabel gearShootingStartSurfaceTemperatureLabel;
    protected JTextField gearShootingStartTimeField;
    protected JLabel gearShootingStartTimeLabel;
    protected Table generalForm;
    protected JCheckBox geometrieMesureeCheckBox;
    protected TraitTabUIHandler handler;
    protected TraitTabUI homePanel = this;
    protected Table hydrologyForm;
    protected JButton importPupitriButton;
    protected JTextField localiteField;
    protected JLabel localiteLabel;
    protected NumberEditor longueurBrasField;
    protected JLabel longueurFunesBrasLabel;
    protected NumberEditor longueurFunesField;
    protected TraitTabUIModel model;
    protected JLabel noTraitPane;
    protected NumberEditor ouvertureHorizontaleField;
    protected JLabel ouvertureHorizontaleVerticaleLabel;
    protected NumberEditor ouvertureVerticaleField;
    protected BeanListHeader<UserBean> saisisseurHeader;
    protected JList<UserBean> saisisseurList;
    @ValidatorField( validatorId = "validator",  propertyName = "saisisseur",  editorName = "saisisseurPane")
    protected JScrollPane saisisseurPane;
    protected JButton saveButton;
    protected BeanComboBox<SeaStateBean> seaStateComboBox;
    protected JLabel seaStateLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "stationNumber",  editorName = "stationNumberField")
    protected NumberEditor stationNumberField;
    protected JLabel stationNumberTraitNumberLabel;
    protected BeanComboBox<StrataBean> strataComboBox;
    protected JLabel strataLabel;
    protected JCheckBox systemeFermetureCulCheckBox;
    protected TabInfo traitGearShootingTab;
    protected TabInfo traitGeneralTab;
    protected TabInfo traitHydrologyTabContent;
    @ValidatorField( validatorId = "validator",  propertyName = "traitNumber",  editorName = "traitNumberField")
    protected NumberEditor traitNumberField;
    protected JPanel traitPane;
    protected JCheckBox traitRectiligneCheckBox;
    protected JTabbedPane traitTabPane;
    protected JCheckBox traitValidCheckBox;
    @Validator( validatorId = "validator")
    protected SwingValidator<TraitTabUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected NumberEditor windDirectionField;
    protected JLabel windDirectionLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;
    private JPanel $JPanel5;
    private JPanel $JPanel6;
    private JPanel $JPanel7;
    private JPanel $JPanel8;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void selectTrait(TraitBean trait) { handler.selectTrait(trait); }
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TraitTabUI(CatchesUI parentUI) {
        TraitTabUIHandler handler = new TraitTabUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public TraitTabUI() {
        $initialize();
    }

    public TraitTabUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TraitTabUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public TraitTabUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TraitTabUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public TraitTabUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TraitTabUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TraitTabUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__dateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setDate(((JXDatePicker)event.getSource()).getDate());
    }

    public void doActionPerformed__on__importPupitriButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importPupitri();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doFocusGained__on__saisisseurPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        saisisseurList.requestFocus();
    }

    public void doItemStateChanged__on__geometrieMesureeCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "geometrieMesuree");
    }

    public void doItemStateChanged__on__systemeFermetureCulCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "systemeFermetureCul");
    }

    public void doItemStateChanged__on__traitRectiligneCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "traitRectiligne");
    }

    public void doItemStateChanged__on__traitValidCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "traitValid");
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__gearShootingEndLatitudeField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setGearShootingEndLatitude(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__gearShootingEndLongitudeField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setGearShootingEndLongitude(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__gearShootingEndTimeField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setGearShootingEndTime(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__gearShootingStartLatitudeField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setGearShootingStartLatitude(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__gearShootingStartLongitudeField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setGearShootingStartLongitude(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__gearShootingStartTimeField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setGearShootingStartTime(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__localiteField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "localite");
    }

    public void doValueChanged__on__saisisseurList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.selectListData(event, "saisisseur");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditor getAverageBottomSalinityField() {
        return averageBottomSalinityField;
    }

    public JLabel getAverageBottomSalinityLabel() {
        return averageBottomSalinityLabel;
    }

    public NumberEditor getAverageBottomTemperatureField() {
        return averageBottomTemperatureField;
    }

    public JLabel getAverageBottomTemperatureLabel() {
        return averageBottomTemperatureLabel;
    }

    public BeanComboBox<BeaufortScaleBean> getBeaufortScaleComboBox() {
        return beaufortScaleComboBox;
    }

    public JLabel getBeaufortScaleLabel() {
        return beaufortScaleLabel;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JXDatePicker getDateField() {
        return dateField;
    }

    public JLabel getDateLabel() {
        return dateLabel;
    }

    public JLabel getDistanceChaluteeDureeLabel() {
        return distanceChaluteeDureeLabel;
    }

    public NumberEditor getDistanceChaluteeField() {
        return distanceChaluteeField;
    }

    public NumberEditor getDureeField() {
        return dureeField;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public NumberEditor getGearShootingEndBottomSalinityField() {
        return gearShootingEndBottomSalinityField;
    }

    public JLabel getGearShootingEndBottomSalinityLabel() {
        return gearShootingEndBottomSalinityLabel;
    }

    public NumberEditor getGearShootingEndBottomTemperatureField() {
        return gearShootingEndBottomTemperatureField;
    }

    public JLabel getGearShootingEndBottomTemperatureLabel() {
        return gearShootingEndBottomTemperatureLabel;
    }

    public NumberEditor getGearShootingEndDepthField() {
        return gearShootingEndDepthField;
    }

    public JLabel getGearShootingEndDepthLabel() {
        return gearShootingEndDepthLabel;
    }

    public JTextField getGearShootingEndLatitudeField() {
        return gearShootingEndLatitudeField;
    }

    public JLabel getGearShootingEndLatitudeLabel() {
        return gearShootingEndLatitudeLabel;
    }

    public JTextField getGearShootingEndLongitudeField() {
        return gearShootingEndLongitudeField;
    }

    public JLabel getGearShootingEndLongitudeLabel() {
        return gearShootingEndLongitudeLabel;
    }

    public NumberEditor getGearShootingEndSurfaceSalinityField() {
        return gearShootingEndSurfaceSalinityField;
    }

    public JLabel getGearShootingEndSurfaceSalinityLabel() {
        return gearShootingEndSurfaceSalinityLabel;
    }

    public NumberEditor getGearShootingEndSurfaceTemperatureField() {
        return gearShootingEndSurfaceTemperatureField;
    }

    public JLabel getGearShootingEndSurfaceTemperatureLabel() {
        return gearShootingEndSurfaceTemperatureLabel;
    }

    public JTextField getGearShootingEndTimeField() {
        return gearShootingEndTimeField;
    }

    public JLabel getGearShootingEndTimeLabel() {
        return gearShootingEndTimeLabel;
    }

    public Table getGearShootingForm() {
        return gearShootingForm;
    }

    public NumberEditor getGearShootingStartBottomSalinityField() {
        return gearShootingStartBottomSalinityField;
    }

    public JLabel getGearShootingStartBottomSalinityLabel() {
        return gearShootingStartBottomSalinityLabel;
    }

    public NumberEditor getGearShootingStartBottomTemperatureField() {
        return gearShootingStartBottomTemperatureField;
    }

    public JLabel getGearShootingStartBottomTemperatureLabel() {
        return gearShootingStartBottomTemperatureLabel;
    }

    public NumberEditor getGearShootingStartDepthField() {
        return gearShootingStartDepthField;
    }

    public JLabel getGearShootingStartDepthLabel() {
        return gearShootingStartDepthLabel;
    }

    public JTextField getGearShootingStartLatitudeField() {
        return gearShootingStartLatitudeField;
    }

    public JLabel getGearShootingStartLatitudeLabel() {
        return gearShootingStartLatitudeLabel;
    }

    public JTextField getGearShootingStartLongitudeField() {
        return gearShootingStartLongitudeField;
    }

    public JLabel getGearShootingStartLongitudeLabel() {
        return gearShootingStartLongitudeLabel;
    }

    public NumberEditor getGearShootingStartSurfaceSalinityField() {
        return gearShootingStartSurfaceSalinityField;
    }

    public JLabel getGearShootingStartSurfaceSalinityLabel() {
        return gearShootingStartSurfaceSalinityLabel;
    }

    public NumberEditor getGearShootingStartSurfaceTemperatureField() {
        return gearShootingStartSurfaceTemperatureField;
    }

    public JLabel getGearShootingStartSurfaceTemperatureLabel() {
        return gearShootingStartSurfaceTemperatureLabel;
    }

    public JTextField getGearShootingStartTimeField() {
        return gearShootingStartTimeField;
    }

    public JLabel getGearShootingStartTimeLabel() {
        return gearShootingStartTimeLabel;
    }

    public Table getGeneralForm() {
        return generalForm;
    }

    public JCheckBox getGeometrieMesureeCheckBox() {
        return geometrieMesureeCheckBox;
    }

    public TraitTabUIHandler getHandler() {
        return handler;
    }

    public Table getHydrologyForm() {
        return hydrologyForm;
    }

    public JButton getImportPupitriButton() {
        return importPupitriButton;
    }

    public JTextField getLocaliteField() {
        return localiteField;
    }

    public JLabel getLocaliteLabel() {
        return localiteLabel;
    }

    public NumberEditor getLongueurBrasField() {
        return longueurBrasField;
    }

    public JLabel getLongueurFunesBrasLabel() {
        return longueurFunesBrasLabel;
    }

    public NumberEditor getLongueurFunesField() {
        return longueurFunesField;
    }

    public TraitTabUIModel getModel() {
        return model;
    }

    public JLabel getNoTraitPane() {
        return noTraitPane;
    }

    public NumberEditor getOuvertureHorizontaleField() {
        return ouvertureHorizontaleField;
    }

    public JLabel getOuvertureHorizontaleVerticaleLabel() {
        return ouvertureHorizontaleVerticaleLabel;
    }

    public NumberEditor getOuvertureVerticaleField() {
        return ouvertureVerticaleField;
    }

    public BeanListHeader<UserBean> getSaisisseurHeader() {
        return saisisseurHeader;
    }

    public JList<UserBean> getSaisisseurList() {
        return saisisseurList;
    }

    public JScrollPane getSaisisseurPane() {
        return saisisseurPane;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public BeanComboBox<SeaStateBean> getSeaStateComboBox() {
        return seaStateComboBox;
    }

    public JLabel getSeaStateLabel() {
        return seaStateLabel;
    }

    public NumberEditor getStationNumberField() {
        return stationNumberField;
    }

    public JLabel getStationNumberTraitNumberLabel() {
        return stationNumberTraitNumberLabel;
    }

    public BeanComboBox<StrataBean> getStrataComboBox() {
        return strataComboBox;
    }

    public JLabel getStrataLabel() {
        return strataLabel;
    }

    public JCheckBox getSystemeFermetureCulCheckBox() {
        return systemeFermetureCulCheckBox;
    }

    public TabInfo getTraitGearShootingTab() {
        return traitGearShootingTab;
    }

    public TabInfo getTraitGeneralTab() {
        return traitGeneralTab;
    }

    public TabInfo getTraitHydrologyTabContent() {
        return traitHydrologyTabContent;
    }

    public NumberEditor getTraitNumberField() {
        return traitNumberField;
    }

    public JPanel getTraitPane() {
        return traitPane;
    }

    public JCheckBox getTraitRectiligneCheckBox() {
        return traitRectiligneCheckBox;
    }

    public JTabbedPane getTraitTabPane() {
        return traitTabPane;
    }

    public JCheckBox getTraitValidCheckBox() {
        return traitValidCheckBox;
    }

    public SwingValidator<TraitTabUIModel> getValidator() {
        return validator;
    }

    public NumberEditor getWindDirectionField() {
        return windDirectionField;
    }

    public JLabel getWindDirectionLabel() {
        return windDirectionLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected JPanel get$JPanel6() {
        return $JPanel6;
    }

    protected JPanel get$JPanel7() {
        return $JPanel7;
    }

    protected JPanel get$JPanel8() {
        return $JPanel8;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(SwingUtil.boxComponentWithJxLayer(commentField));
    }

    protected void addChildrenToGearShootingForm() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingForm.add(gearShootingStartLongitudeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingStartLongitudeField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingStartLatitudeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingStartLatitudeField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingStartTimeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingStartTimeField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingStartDepthLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingStartDepthField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingEndLongitudeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingEndLongitudeField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingEndLatitudeLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingEndLatitudeField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingEndTimeLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingEndTimeField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingEndDepthLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingEndDepthField, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToGeneralForm() {
        if (!allComponentsCreated) {
            return;
        }
        generalForm.add(stationNumberTraitNumberLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(dateLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(dateField), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(strataLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(strataComboBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(beaufortScaleLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(beaufortScaleComboBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(windDirectionLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(windDirectionField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(seaStateLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(seaStateComboBox, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(ouvertureHorizontaleVerticaleLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel1, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(longueurFunesBrasLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel2, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(distanceChaluteeDureeLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel3, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(localiteLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(localiteField, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel4, new GridBagConstraints(0, 10, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel5, new GridBagConstraints(0, 11, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(saisisseurPane), new GridBagConstraints(0, 12, 2, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(commentPane, new GridBagConstraints(0, 13, 2, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(traitPane, BorderLayout.CENTER);
        add(noTraitPane);
    }

    protected void addChildrenToHydrologyForm() {
        if (!allComponentsCreated) {
            return;
        }
        hydrologyForm.add(gearShootingStartSurfaceTemperatureLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingStartSurfaceTemperatureField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndSurfaceTemperatureLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndSurfaceTemperatureField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingStartBottomTemperatureLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingStartBottomTemperatureField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndBottomTemperatureLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndBottomTemperatureField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(averageBottomTemperatureLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(averageBottomTemperatureField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingStartSurfaceSalinityLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingStartSurfaceSalinityField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndSurfaceSalinityLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndSurfaceSalinityField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingStartBottomSalinityLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingStartBottomSalinityField, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndBottomSalinityLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndBottomSalinityField, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(averageBottomSalinityLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(averageBottomSalinityField, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSaisisseurPane() {
        if (!allComponentsCreated) {
            return;
        }
        saisisseurPane.getViewport().add(saisisseurList);
    }

    protected void addChildrenToTraitPane() {
        if (!allComponentsCreated) {
            return;
        }
        traitPane.add(traitTabPane, BorderLayout.CENTER);
        traitPane.add($JPanel6, BorderLayout.SOUTH);
    }

    protected void addChildrenToTraitTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        traitTabPane.add(generalForm);
        traitTabPane.add(gearShootingForm);
        traitTabPane.add(hydrologyForm);
        traitGeneralTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(traitTabPane, 0));
        traitTabPane.setTitleAt(0, _("tutti.label.tab.trait.general"));
        traitGearShootingTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(traitTabPane, 1));
        traitTabPane.setTitleAt(1, _("tutti.label.tab.trait.gearShooting"));
        traitHydrologyTabContent.addPropertyChangeListener(new TabInfoPropertyChangeListener(traitTabPane, 2));
        traitTabPane.setTitleAt(2, _("tutti.label.tab.trait.hydrology"));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAverageBottomSalinityField() {
        $objectMap.put("averageBottomSalinityField", averageBottomSalinityField = new NumberEditor(this));
        
        averageBottomSalinityField.setName("averageBottomSalinityField");
        averageBottomSalinityField.setProperty("averageBottomSalinity");
        averageBottomSalinityField.setUseFloat(false);
        averageBottomSalinityField.setShowReset(true);
    }

    protected void createAverageBottomSalinityLabel() {
        $objectMap.put("averageBottomSalinityLabel", averageBottomSalinityLabel = new JLabel());
        
        averageBottomSalinityLabel.setName("averageBottomSalinityLabel");
        averageBottomSalinityLabel.setText(_("tutti.label.trait.averageBottomSalinity"));
    }

    protected void createAverageBottomTemperatureField() {
        $objectMap.put("averageBottomTemperatureField", averageBottomTemperatureField = new NumberEditor(this));
        
        averageBottomTemperatureField.setName("averageBottomTemperatureField");
        averageBottomTemperatureField.setProperty("averageBottomTemperature");
        averageBottomTemperatureField.setUseFloat(false);
        averageBottomTemperatureField.setShowReset(true);
    }

    protected void createAverageBottomTemperatureLabel() {
        $objectMap.put("averageBottomTemperatureLabel", averageBottomTemperatureLabel = new JLabel());
        
        averageBottomTemperatureLabel.setName("averageBottomTemperatureLabel");
        averageBottomTemperatureLabel.setText(_("tutti.label.trait.averageBottomTemperature"));
    }

    protected void createBeaufortScaleComboBox() {
        $objectMap.put("beaufortScaleComboBox", beaufortScaleComboBox = new BeanComboBox<BeaufortScaleBean>(this));
        
        beaufortScaleComboBox.setName("beaufortScaleComboBox");
        beaufortScaleComboBox.setI18nPrefix("tutti.property.");
        beaufortScaleComboBox.setProperty("beaufortScale");
        beaufortScaleComboBox.setShowReset(true);
    }

    protected void createBeaufortScaleLabel() {
        $objectMap.put("beaufortScaleLabel", beaufortScaleLabel = new JLabel());
        
        beaufortScaleLabel.setName("beaufortScaleLabel");
        beaufortScaleLabel.setText(_("tutti.label.trait.beaufortScale"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.action.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
    }

    protected void createDateField() {
        $objectMap.put("dateField", dateField = new JXDatePicker());
        
        dateField.setName("dateField");
        dateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dateField"));
    }

    protected void createDateLabel() {
        $objectMap.put("dateLabel", dateLabel = new JLabel());
        
        dateLabel.setName("dateLabel");
        dateLabel.setText(_("tutti.label.trait.date"));
    }

    protected void createDistanceChaluteeDureeLabel() {
        $objectMap.put("distanceChaluteeDureeLabel", distanceChaluteeDureeLabel = new JLabel());
        
        distanceChaluteeDureeLabel.setName("distanceChaluteeDureeLabel");
        distanceChaluteeDureeLabel.setText(_("tutti.label.trait.distanceChaluteeDuree"));
    }

    protected void createDistanceChaluteeField() {
        $objectMap.put("distanceChaluteeField", distanceChaluteeField = new NumberEditor(this));
        
        distanceChaluteeField.setName("distanceChaluteeField");
        distanceChaluteeField.setProperty("distanceChalutee");
        distanceChaluteeField.setUseFloat(false);
        distanceChaluteeField.setShowReset(true);
    }

    protected void createDureeField() {
        $objectMap.put("dureeField", dureeField = new NumberEditor(this));
        
        dureeField.setName("dureeField");
        dureeField.setProperty("duree");
        dureeField.setUseFloat(false);
        dureeField.setShowReset(true);
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createGearShootingEndBottomSalinityField() {
        $objectMap.put("gearShootingEndBottomSalinityField", gearShootingEndBottomSalinityField = new NumberEditor(this));
        
        gearShootingEndBottomSalinityField.setName("gearShootingEndBottomSalinityField");
        gearShootingEndBottomSalinityField.setProperty("gearShootingEndBottomSalinity");
        gearShootingEndBottomSalinityField.setUseFloat(false);
        gearShootingEndBottomSalinityField.setShowReset(true);
    }

    protected void createGearShootingEndBottomSalinityLabel() {
        $objectMap.put("gearShootingEndBottomSalinityLabel", gearShootingEndBottomSalinityLabel = new JLabel());
        
        gearShootingEndBottomSalinityLabel.setName("gearShootingEndBottomSalinityLabel");
        gearShootingEndBottomSalinityLabel.setText(_("tutti.label.trait.gearShootingEndBottomSalinity"));
    }

    protected void createGearShootingEndBottomTemperatureField() {
        $objectMap.put("gearShootingEndBottomTemperatureField", gearShootingEndBottomTemperatureField = new NumberEditor(this));
        
        gearShootingEndBottomTemperatureField.setName("gearShootingEndBottomTemperatureField");
        gearShootingEndBottomTemperatureField.setProperty("gearShootingEndBottomTemperature");
        gearShootingEndBottomTemperatureField.setUseFloat(false);
        gearShootingEndBottomTemperatureField.setShowReset(true);
    }

    protected void createGearShootingEndBottomTemperatureLabel() {
        $objectMap.put("gearShootingEndBottomTemperatureLabel", gearShootingEndBottomTemperatureLabel = new JLabel());
        
        gearShootingEndBottomTemperatureLabel.setName("gearShootingEndBottomTemperatureLabel");
        gearShootingEndBottomTemperatureLabel.setText(_("tutti.label.trait.gearShootingEndBottomTemperature"));
    }

    protected void createGearShootingEndDepthField() {
        $objectMap.put("gearShootingEndDepthField", gearShootingEndDepthField = new NumberEditor(this));
        
        gearShootingEndDepthField.setName("gearShootingEndDepthField");
        gearShootingEndDepthField.setProperty("gearShootingEndDepth");
        gearShootingEndDepthField.setUseFloat(false);
        gearShootingEndDepthField.setShowReset(true);
    }

    protected void createGearShootingEndDepthLabel() {
        $objectMap.put("gearShootingEndDepthLabel", gearShootingEndDepthLabel = new JLabel());
        
        gearShootingEndDepthLabel.setName("gearShootingEndDepthLabel");
        gearShootingEndDepthLabel.setText(_("tutti.label.trait.gearShootingEndDepth"));
    }

    protected void createGearShootingEndLatitudeField() {
        $objectMap.put("gearShootingEndLatitudeField", gearShootingEndLatitudeField = new JTextField());
        
        gearShootingEndLatitudeField.setName("gearShootingEndLatitudeField");
        gearShootingEndLatitudeField.setColumns(15);
        gearShootingEndLatitudeField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__gearShootingEndLatitudeField"));
    }

    protected void createGearShootingEndLatitudeLabel() {
        $objectMap.put("gearShootingEndLatitudeLabel", gearShootingEndLatitudeLabel = new JLabel());
        
        gearShootingEndLatitudeLabel.setName("gearShootingEndLatitudeLabel");
        gearShootingEndLatitudeLabel.setText(_("tutti.label.trait.gearShootingEndLatitude"));
    }

    protected void createGearShootingEndLongitudeField() {
        $objectMap.put("gearShootingEndLongitudeField", gearShootingEndLongitudeField = new JTextField());
        
        gearShootingEndLongitudeField.setName("gearShootingEndLongitudeField");
        gearShootingEndLongitudeField.setColumns(15);
        gearShootingEndLongitudeField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__gearShootingEndLongitudeField"));
    }

    protected void createGearShootingEndLongitudeLabel() {
        $objectMap.put("gearShootingEndLongitudeLabel", gearShootingEndLongitudeLabel = new JLabel());
        
        gearShootingEndLongitudeLabel.setName("gearShootingEndLongitudeLabel");
        gearShootingEndLongitudeLabel.setText(_("tutti.label.trait.gearShootingEndLongitude"));
    }

    protected void createGearShootingEndSurfaceSalinityField() {
        $objectMap.put("gearShootingEndSurfaceSalinityField", gearShootingEndSurfaceSalinityField = new NumberEditor(this));
        
        gearShootingEndSurfaceSalinityField.setName("gearShootingEndSurfaceSalinityField");
        gearShootingEndSurfaceSalinityField.setProperty("gearShootingEndSurfaceSalinity");
        gearShootingEndSurfaceSalinityField.setUseFloat(false);
        gearShootingEndSurfaceSalinityField.setShowReset(true);
    }

    protected void createGearShootingEndSurfaceSalinityLabel() {
        $objectMap.put("gearShootingEndSurfaceSalinityLabel", gearShootingEndSurfaceSalinityLabel = new JLabel());
        
        gearShootingEndSurfaceSalinityLabel.setName("gearShootingEndSurfaceSalinityLabel");
        gearShootingEndSurfaceSalinityLabel.setText(_("tutti.label.trait.gearShootingEndSurfaceSalinity"));
    }

    protected void createGearShootingEndSurfaceTemperatureField() {
        $objectMap.put("gearShootingEndSurfaceTemperatureField", gearShootingEndSurfaceTemperatureField = new NumberEditor(this));
        
        gearShootingEndSurfaceTemperatureField.setName("gearShootingEndSurfaceTemperatureField");
        gearShootingEndSurfaceTemperatureField.setProperty("gearShootingEndSurfaceTemperature");
        gearShootingEndSurfaceTemperatureField.setUseFloat(false);
        gearShootingEndSurfaceTemperatureField.setShowReset(true);
    }

    protected void createGearShootingEndSurfaceTemperatureLabel() {
        $objectMap.put("gearShootingEndSurfaceTemperatureLabel", gearShootingEndSurfaceTemperatureLabel = new JLabel());
        
        gearShootingEndSurfaceTemperatureLabel.setName("gearShootingEndSurfaceTemperatureLabel");
        gearShootingEndSurfaceTemperatureLabel.setText(_("tutti.label.trait.gearShootingEndSurfaceTemperature"));
    }

    protected void createGearShootingEndTimeField() {
        $objectMap.put("gearShootingEndTimeField", gearShootingEndTimeField = new JTextField());
        
        gearShootingEndTimeField.setName("gearShootingEndTimeField");
        gearShootingEndTimeField.setColumns(15);
        gearShootingEndTimeField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__gearShootingEndTimeField"));
    }

    protected void createGearShootingEndTimeLabel() {
        $objectMap.put("gearShootingEndTimeLabel", gearShootingEndTimeLabel = new JLabel());
        
        gearShootingEndTimeLabel.setName("gearShootingEndTimeLabel");
        gearShootingEndTimeLabel.setText(_("tutti.label.trait.gearShootingEndTime"));
    }

    protected void createGearShootingForm() {
        $objectMap.put("gearShootingForm", gearShootingForm = new Table());
        
        gearShootingForm.setName("gearShootingForm");
    }

    protected void createGearShootingStartBottomSalinityField() {
        $objectMap.put("gearShootingStartBottomSalinityField", gearShootingStartBottomSalinityField = new NumberEditor(this));
        
        gearShootingStartBottomSalinityField.setName("gearShootingStartBottomSalinityField");
        gearShootingStartBottomSalinityField.setProperty("gearShootingStartBottomSalinity");
        gearShootingStartBottomSalinityField.setUseFloat(false);
        gearShootingStartBottomSalinityField.setShowReset(true);
    }

    protected void createGearShootingStartBottomSalinityLabel() {
        $objectMap.put("gearShootingStartBottomSalinityLabel", gearShootingStartBottomSalinityLabel = new JLabel());
        
        gearShootingStartBottomSalinityLabel.setName("gearShootingStartBottomSalinityLabel");
        gearShootingStartBottomSalinityLabel.setText(_("tutti.label.trait.gearShootingStartBottomSalinity"));
    }

    protected void createGearShootingStartBottomTemperatureField() {
        $objectMap.put("gearShootingStartBottomTemperatureField", gearShootingStartBottomTemperatureField = new NumberEditor(this));
        
        gearShootingStartBottomTemperatureField.setName("gearShootingStartBottomTemperatureField");
        gearShootingStartBottomTemperatureField.setProperty("gearShootingStartBottomTemperature");
        gearShootingStartBottomTemperatureField.setUseFloat(false);
        gearShootingStartBottomTemperatureField.setShowReset(true);
    }

    protected void createGearShootingStartBottomTemperatureLabel() {
        $objectMap.put("gearShootingStartBottomTemperatureLabel", gearShootingStartBottomTemperatureLabel = new JLabel());
        
        gearShootingStartBottomTemperatureLabel.setName("gearShootingStartBottomTemperatureLabel");
        gearShootingStartBottomTemperatureLabel.setText(_("tutti.label.trait.gearShootingStartBottomTemperature"));
    }

    protected void createGearShootingStartDepthField() {
        $objectMap.put("gearShootingStartDepthField", gearShootingStartDepthField = new NumberEditor(this));
        
        gearShootingStartDepthField.setName("gearShootingStartDepthField");
        gearShootingStartDepthField.setProperty("gearShootingStartDepth");
        gearShootingStartDepthField.setUseFloat(false);
        gearShootingStartDepthField.setShowReset(true);
    }

    protected void createGearShootingStartDepthLabel() {
        $objectMap.put("gearShootingStartDepthLabel", gearShootingStartDepthLabel = new JLabel());
        
        gearShootingStartDepthLabel.setName("gearShootingStartDepthLabel");
        gearShootingStartDepthLabel.setText(_("tutti.label.trait.gearShootingStartDepth"));
    }

    protected void createGearShootingStartLatitudeField() {
        $objectMap.put("gearShootingStartLatitudeField", gearShootingStartLatitudeField = new JTextField());
        
        gearShootingStartLatitudeField.setName("gearShootingStartLatitudeField");
        gearShootingStartLatitudeField.setColumns(15);
        gearShootingStartLatitudeField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__gearShootingStartLatitudeField"));
    }

    protected void createGearShootingStartLatitudeLabel() {
        $objectMap.put("gearShootingStartLatitudeLabel", gearShootingStartLatitudeLabel = new JLabel());
        
        gearShootingStartLatitudeLabel.setName("gearShootingStartLatitudeLabel");
        gearShootingStartLatitudeLabel.setText(_("tutti.label.trait.gearShootingStartLatitude"));
    }

    protected void createGearShootingStartLongitudeField() {
        $objectMap.put("gearShootingStartLongitudeField", gearShootingStartLongitudeField = new JTextField());
        
        gearShootingStartLongitudeField.setName("gearShootingStartLongitudeField");
        gearShootingStartLongitudeField.setColumns(15);
        gearShootingStartLongitudeField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__gearShootingStartLongitudeField"));
    }

    protected void createGearShootingStartLongitudeLabel() {
        $objectMap.put("gearShootingStartLongitudeLabel", gearShootingStartLongitudeLabel = new JLabel());
        
        gearShootingStartLongitudeLabel.setName("gearShootingStartLongitudeLabel");
        gearShootingStartLongitudeLabel.setText(_("tutti.label.trait.gearShootingStartLongitude"));
    }

    protected void createGearShootingStartSurfaceSalinityField() {
        $objectMap.put("gearShootingStartSurfaceSalinityField", gearShootingStartSurfaceSalinityField = new NumberEditor(this));
        
        gearShootingStartSurfaceSalinityField.setName("gearShootingStartSurfaceSalinityField");
        gearShootingStartSurfaceSalinityField.setProperty("gearShootingStartSurfaceSalinity");
        gearShootingStartSurfaceSalinityField.setUseFloat(false);
        gearShootingStartSurfaceSalinityField.setShowReset(true);
    }

    protected void createGearShootingStartSurfaceSalinityLabel() {
        $objectMap.put("gearShootingStartSurfaceSalinityLabel", gearShootingStartSurfaceSalinityLabel = new JLabel());
        
        gearShootingStartSurfaceSalinityLabel.setName("gearShootingStartSurfaceSalinityLabel");
        gearShootingStartSurfaceSalinityLabel.setText(_("tutti.label.trait.gearShootingStartSurfaceSalinity"));
    }

    protected void createGearShootingStartSurfaceTemperatureField() {
        $objectMap.put("gearShootingStartSurfaceTemperatureField", gearShootingStartSurfaceTemperatureField = new NumberEditor(this));
        
        gearShootingStartSurfaceTemperatureField.setName("gearShootingStartSurfaceTemperatureField");
        gearShootingStartSurfaceTemperatureField.setProperty("gearShootingStartSurfaceTemperature");
        gearShootingStartSurfaceTemperatureField.setUseFloat(false);
        gearShootingStartSurfaceTemperatureField.setShowReset(true);
    }

    protected void createGearShootingStartSurfaceTemperatureLabel() {
        $objectMap.put("gearShootingStartSurfaceTemperatureLabel", gearShootingStartSurfaceTemperatureLabel = new JLabel());
        
        gearShootingStartSurfaceTemperatureLabel.setName("gearShootingStartSurfaceTemperatureLabel");
        gearShootingStartSurfaceTemperatureLabel.setText(_("tutti.label.trait.gearShootingStartSurfaceTemperature"));
    }

    protected void createGearShootingStartTimeField() {
        $objectMap.put("gearShootingStartTimeField", gearShootingStartTimeField = new JTextField());
        
        gearShootingStartTimeField.setName("gearShootingStartTimeField");
        gearShootingStartTimeField.setColumns(15);
        gearShootingStartTimeField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__gearShootingStartTimeField"));
    }

    protected void createGearShootingStartTimeLabel() {
        $objectMap.put("gearShootingStartTimeLabel", gearShootingStartTimeLabel = new JLabel());
        
        gearShootingStartTimeLabel.setName("gearShootingStartTimeLabel");
        gearShootingStartTimeLabel.setText(_("tutti.label.trait.gearShootingStartTime"));
    }

    protected void createGeneralForm() {
        $objectMap.put("generalForm", generalForm = new Table());
        
        generalForm.setName("generalForm");
    }

    protected void createGeometrieMesureeCheckBox() {
        $objectMap.put("geometrieMesureeCheckBox", geometrieMesureeCheckBox = new JCheckBox());
        
        geometrieMesureeCheckBox.setName("geometrieMesureeCheckBox");
        geometrieMesureeCheckBox.setText(_("tutti.label.trait.geometrieMesuree"));
        geometrieMesureeCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__geometrieMesureeCheckBox"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(TraitTabUIHandler.class));
    }

    protected void createHydrologyForm() {
        $objectMap.put("hydrologyForm", hydrologyForm = new Table());
        
        hydrologyForm.setName("hydrologyForm");
    }

    protected void createImportPupitriButton() {
        $objectMap.put("importPupitriButton", importPupitriButton = new JButton());
        
        importPupitriButton.setName("importPupitriButton");
        importPupitriButton.setText(_("tutti.action.pupitri-import"));
        importPupitriButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importPupitriButton"));
    }

    protected void createLocaliteField() {
        $objectMap.put("localiteField", localiteField = new JTextField());
        
        localiteField.setName("localiteField");
        localiteField.setColumns(15);
        localiteField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__localiteField"));
    }

    protected void createLocaliteLabel() {
        $objectMap.put("localiteLabel", localiteLabel = new JLabel());
        
        localiteLabel.setName("localiteLabel");
        localiteLabel.setText(_("tutti.label.trait.localite"));
    }

    protected void createLongueurBrasField() {
        $objectMap.put("longueurBrasField", longueurBrasField = new NumberEditor(this));
        
        longueurBrasField.setName("longueurBrasField");
        longueurBrasField.setProperty("longueurBras");
        longueurBrasField.setUseFloat(false);
        longueurBrasField.setShowReset(true);
    }

    protected void createLongueurFunesBrasLabel() {
        $objectMap.put("longueurFunesBrasLabel", longueurFunesBrasLabel = new JLabel());
        
        longueurFunesBrasLabel.setName("longueurFunesBrasLabel");
        longueurFunesBrasLabel.setText(_("tutti.label.trait.longueurFunesBras"));
    }

    protected void createLongueurFunesField() {
        $objectMap.put("longueurFunesField", longueurFunesField = new NumberEditor(this));
        
        longueurFunesField.setName("longueurFunesField");
        longueurFunesField.setProperty("longueurFunes");
        longueurFunesField.setUseFloat(false);
        longueurFunesField.setShowReset(true);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TraitTabUIModel.class));
    }

    protected void createNoTraitPane() {
        $objectMap.put("noTraitPane", noTraitPane = new JLabel());
        
        noTraitPane.setName("noTraitPane");
        noTraitPane.setText(_("tutti.label.no.trait.selected"));
    }

    protected void createOuvertureHorizontaleField() {
        $objectMap.put("ouvertureHorizontaleField", ouvertureHorizontaleField = new NumberEditor(this));
        
        ouvertureHorizontaleField.setName("ouvertureHorizontaleField");
        ouvertureHorizontaleField.setProperty("ouvertureHorizontale");
        ouvertureHorizontaleField.setUseFloat(false);
        ouvertureHorizontaleField.setShowReset(true);
    }

    protected void createOuvertureHorizontaleVerticaleLabel() {
        $objectMap.put("ouvertureHorizontaleVerticaleLabel", ouvertureHorizontaleVerticaleLabel = new JLabel());
        
        ouvertureHorizontaleVerticaleLabel.setName("ouvertureHorizontaleVerticaleLabel");
        ouvertureHorizontaleVerticaleLabel.setText(_("tutti.label.trait.ouvertureHorizontaleVerticale"));
    }

    protected void createOuvertureVerticaleField() {
        $objectMap.put("ouvertureVerticaleField", ouvertureVerticaleField = new NumberEditor(this));
        
        ouvertureVerticaleField.setName("ouvertureVerticaleField");
        ouvertureVerticaleField.setProperty("ouvertureVerticale");
        ouvertureVerticaleField.setUseFloat(false);
        ouvertureVerticaleField.setShowReset(true);
    }

    protected void createSaisisseurHeader() {
        $objectMap.put("saisisseurHeader", saisisseurHeader = new BeanListHeader<UserBean>());
        
        saisisseurHeader.setName("saisisseurHeader");
        saisisseurHeader.setI18nPrefix("tutti.property.");
        saisisseurHeader.setShowReset(true);
    }

    protected void createSaisisseurList() {
        $objectMap.put("saisisseurList", saisisseurList = new JList<UserBean>());
        
        saisisseurList.setName("saisisseurList");
        saisisseurList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__saisisseurList"));
    }

    protected void createSaisisseurPane() {
        $objectMap.put("saisisseurPane", saisisseurPane = new JScrollPane());
        
        saisisseurPane.setName("saisisseurPane");
        saisisseurPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__saisisseurPane"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.action.save"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createSeaStateComboBox() {
        $objectMap.put("seaStateComboBox", seaStateComboBox = new BeanComboBox<SeaStateBean>(this));
        
        seaStateComboBox.setName("seaStateComboBox");
        seaStateComboBox.setI18nPrefix("tutti.property.");
        seaStateComboBox.setProperty("seaState");
        seaStateComboBox.setShowReset(true);
    }

    protected void createSeaStateLabel() {
        $objectMap.put("seaStateLabel", seaStateLabel = new JLabel());
        
        seaStateLabel.setName("seaStateLabel");
        seaStateLabel.setText(_("tutti.label.trait.seaState"));
    }

    protected void createStationNumberField() {
        $objectMap.put("stationNumberField", stationNumberField = new NumberEditor(this));
        
        stationNumberField.setName("stationNumberField");
        stationNumberField.setProperty("stationNumber");
        stationNumberField.setUseFloat(false);
        stationNumberField.setShowReset(true);
    }

    protected void createStationNumberTraitNumberLabel() {
        $objectMap.put("stationNumberTraitNumberLabel", stationNumberTraitNumberLabel = new JLabel());
        
        stationNumberTraitNumberLabel.setName("stationNumberTraitNumberLabel");
        stationNumberTraitNumberLabel.setText(_("tutti.label.trait.stationNumberTraitNumber"));
    }

    protected void createStrataComboBox() {
        $objectMap.put("strataComboBox", strataComboBox = new BeanComboBox<StrataBean>(this));
        
        strataComboBox.setName("strataComboBox");
        strataComboBox.setI18nPrefix("tutti.property.");
        strataComboBox.setProperty("strata");
        strataComboBox.setShowReset(true);
    }

    protected void createStrataLabel() {
        $objectMap.put("strataLabel", strataLabel = new JLabel());
        
        strataLabel.setName("strataLabel");
        strataLabel.setText(_("tutti.label.trait.strata"));
    }

    protected void createSystemeFermetureCulCheckBox() {
        $objectMap.put("systemeFermetureCulCheckBox", systemeFermetureCulCheckBox = new JCheckBox());
        
        systemeFermetureCulCheckBox.setName("systemeFermetureCulCheckBox");
        systemeFermetureCulCheckBox.setText(_("tutti.label.trait.systemeFermetureCul"));
        systemeFermetureCulCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__systemeFermetureCulCheckBox"));
    }

    protected void createTraitGearShootingTab() {
        $objectMap.put("traitGearShootingTab", traitGearShootingTab = new TabInfo());
        
        traitGearShootingTab.setTitle(_("tutti.label.tab.trait.gearShooting"));
    }

    protected void createTraitGeneralTab() {
        $objectMap.put("traitGeneralTab", traitGeneralTab = new TabInfo());
        
        traitGeneralTab.setTitle(_("tutti.label.tab.trait.general"));
    }

    protected void createTraitHydrologyTabContent() {
        $objectMap.put("traitHydrologyTabContent", traitHydrologyTabContent = new TabInfo());
        
        traitHydrologyTabContent.setTitle(_("tutti.label.tab.trait.hydrology"));
    }

    protected void createTraitNumberField() {
        $objectMap.put("traitNumberField", traitNumberField = new NumberEditor(this));
        
        traitNumberField.setName("traitNumberField");
        traitNumberField.setProperty("traitNumber");
        traitNumberField.setUseFloat(false);
        traitNumberField.setShowReset(true);
    }

    protected void createTraitPane() {
        $objectMap.put("traitPane", traitPane = new JPanel());
        
        traitPane.setName("traitPane");
        traitPane.setLayout(new BorderLayout());
    }

    protected void createTraitRectiligneCheckBox() {
        $objectMap.put("traitRectiligneCheckBox", traitRectiligneCheckBox = new JCheckBox());
        
        traitRectiligneCheckBox.setName("traitRectiligneCheckBox");
        traitRectiligneCheckBox.setText(_("tutti.label.trait.traitRectiligne"));
        traitRectiligneCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__traitRectiligneCheckBox"));
    }

    protected void createTraitTabPane() {
        $objectMap.put("traitTabPane", traitTabPane = new JTabbedPane());
        
        traitTabPane.setName("traitTabPane");
    }

    protected void createTraitValidCheckBox() {
        $objectMap.put("traitValidCheckBox", traitValidCheckBox = new JCheckBox());
        
        traitValidCheckBox.setName("traitValidCheckBox");
        traitValidCheckBox.setText(_("tutti.label.trait.traitValid"));
        traitValidCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__traitValidCheckBox"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(TraitTabUIModel.class, null));
    }

    protected void createWindDirectionField() {
        $objectMap.put("windDirectionField", windDirectionField = new NumberEditor(this));
        
        windDirectionField.setName("windDirectionField");
        windDirectionField.setProperty("windDirection");
        windDirectionField.setUseFloat(false);
        windDirectionField.setShowReset(true);
    }

    protected void createWindDirectionLabel() {
        $objectMap.put("windDirectionLabel", windDirectionLabel = new JLabel());
        
        windDirectionLabel.setName("windDirectionLabel");
        windDirectionLabel.setText(_("tutti.label.trait.windDirection"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToTraitPane();
        addChildrenToTraitTabPane();
        addChildrenToGeneralForm();
        // inline complete setup of $JPanel0
        $JPanel0.add(SwingUtil.boxComponentWithJxLayer(stationNumberField));
        $JPanel0.add(SwingUtil.boxComponentWithJxLayer(traitNumberField));
        // inline complete setup of $JPanel1
        $JPanel1.add(ouvertureHorizontaleField);
        $JPanel1.add(ouvertureVerticaleField);
        // inline complete setup of $JPanel2
        $JPanel2.add(longueurFunesField);
        $JPanel2.add(longueurBrasField);
        // inline complete setup of $JPanel3
        $JPanel3.add(distanceChaluteeField);
        $JPanel3.add(dureeField);
        // inline complete setup of $JPanel4
        $JPanel4.add(traitValidCheckBox);
        $JPanel4.add(traitRectiligneCheckBox);
        // inline complete setup of $JPanel5
        $JPanel5.add(systemeFermetureCulCheckBox);
        $JPanel5.add(geometrieMesureeCheckBox);
        addChildrenToSaisisseurPane();
        addChildrenToCommentPane();
        addChildrenToGearShootingForm();
        addChildrenToHydrologyForm();
        // inline complete setup of $JPanel6
        $JPanel6.add($JPanel7, BorderLayout.NORTH);
        $JPanel6.add($JPanel8, BorderLayout.CENTER);
        // inline complete setup of $JPanel7
        $JPanel7.add(importPupitriButton);
        // inline complete setup of $JPanel8
        $JPanel8.add(cancelButton);
        $JPanel8.add(saveButton);
        
        // apply 60 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 116 property setters
        saisisseurPane.setColumnHeaderView(saisisseurHeader);
        stationNumberField.setBean(model);
        stationNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        stationNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        traitNumberField.setBean(model);
        traitNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        traitNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        dateLabel.setLabelFor(dateField);
        dateField.setFormats("dd/MM/yyyy");
        strataLabel.setLabelFor(strataComboBox);
        strataComboBox.setBean(model);
        beaufortScaleLabel.setLabelFor(beaufortScaleComboBox);
        beaufortScaleComboBox.setBean(model);
        windDirectionLabel.setLabelFor(windDirectionField);
        windDirectionField.setBean(model);
        windDirectionField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        windDirectionField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        seaStateLabel.setLabelFor(seaStateComboBox);
        seaStateComboBox.setBean(model);
        ouvertureHorizontaleField.setBean(model);
        ouvertureHorizontaleField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        ouvertureHorizontaleField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        ouvertureVerticaleField.setBean(model);
        ouvertureVerticaleField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        ouvertureVerticaleField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        longueurFunesField.setBean(model);
        longueurFunesField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        longueurFunesField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        longueurBrasField.setBean(model);
        longueurBrasField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        longueurBrasField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        distanceChaluteeField.setBean(model);
        distanceChaluteeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        distanceChaluteeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        dureeField.setBean(model);
        dureeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        dureeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        localiteLabel.setLabelFor(localiteField);
        saisisseurPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        saisisseurPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        saisisseurList.setModel(new DefaultListModel());
        saisisseurList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        saisisseurHeader.setLabelText(_("tutti.label.list.saisisseur"));
        saisisseurHeader.setBeanType(UserBean.class);
        saisisseurHeader.setList(saisisseurList);
        commentPane.setColumnHeaderView(new JLabel(_("tutti.label.comment")));
        commentPane.setMinimumSize(new Dimension(10,50));
        gearShootingStartLongitudeLabel.setLabelFor(gearShootingStartLongitudeField);
        gearShootingStartLatitudeLabel.setLabelFor(gearShootingStartLatitudeField);
        gearShootingStartTimeLabel.setLabelFor(gearShootingStartTimeField);
        gearShootingStartDepthLabel.setLabelFor(gearShootingStartDepthField);
        gearShootingStartDepthField.setBean(model);
        gearShootingStartDepthField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartDepthField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeLabel.setLabelFor(gearShootingEndLongitudeField);
        gearShootingEndLatitudeLabel.setLabelFor(gearShootingEndLatitudeField);
        gearShootingEndTimeLabel.setLabelFor(gearShootingEndTimeField);
        gearShootingEndDepthLabel.setLabelFor(gearShootingEndDepthField);
        gearShootingEndDepthField.setBean(model);
        gearShootingEndDepthField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndDepthField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartSurfaceTemperatureLabel.setLabelFor(gearShootingStartSurfaceTemperatureField);
        gearShootingStartSurfaceTemperatureField.setBean(model);
        gearShootingStartSurfaceTemperatureField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartSurfaceTemperatureField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndSurfaceTemperatureLabel.setLabelFor(gearShootingEndSurfaceTemperatureField);
        gearShootingEndSurfaceTemperatureField.setBean(model);
        gearShootingEndSurfaceTemperatureField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndSurfaceTemperatureField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartBottomTemperatureLabel.setLabelFor(gearShootingStartBottomTemperatureField);
        gearShootingStartBottomTemperatureField.setBean(model);
        gearShootingStartBottomTemperatureField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartBottomTemperatureField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndBottomTemperatureLabel.setLabelFor(gearShootingEndBottomTemperatureField);
        gearShootingEndBottomTemperatureField.setBean(model);
        gearShootingEndBottomTemperatureField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndBottomTemperatureField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        averageBottomTemperatureLabel.setLabelFor(averageBottomTemperatureField);
        averageBottomTemperatureField.setBean(model);
        averageBottomTemperatureField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        averageBottomTemperatureField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartSurfaceSalinityLabel.setLabelFor(gearShootingStartSurfaceSalinityField);
        gearShootingStartSurfaceSalinityField.setBean(model);
        gearShootingStartSurfaceSalinityField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartSurfaceSalinityField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndSurfaceSalinityLabel.setLabelFor(gearShootingEndSurfaceSalinityField);
        gearShootingEndSurfaceSalinityField.setBean(model);
        gearShootingEndSurfaceSalinityField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndSurfaceSalinityField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartBottomSalinityLabel.setLabelFor(gearShootingStartBottomSalinityField);
        gearShootingStartBottomSalinityField.setBean(model);
        gearShootingStartBottomSalinityField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartBottomSalinityField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndBottomSalinityLabel.setLabelFor(gearShootingEndBottomSalinityField);
        gearShootingEndBottomSalinityField.setBean(model);
        gearShootingEndBottomSalinityField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndBottomSalinityField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        averageBottomSalinityLabel.setLabelFor(averageBottomSalinityField);
        averageBottomSalinityField.setBean(model);
        averageBottomSalinityField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        averageBottomSalinityField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        importPupitriButton.setIcon(SwingUtil.createActionIcon("pupitri-import"));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        noTraitPane.setHorizontalAlignment(JLabel.CENTER);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createTraitPane();
        createTraitTabPane();
        createGeneralForm();
        createStationNumberTraitNumberLabel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createStationNumberField();
        createTraitNumberField();
        createDateLabel();
        createDateField();
        createStrataLabel();
        createStrataComboBox();
        createBeaufortScaleLabel();
        createBeaufortScaleComboBox();
        createWindDirectionLabel();
        createWindDirectionField();
        createSeaStateLabel();
        createSeaStateComboBox();
        createOuvertureHorizontaleVerticaleLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createOuvertureHorizontaleField();
        createOuvertureVerticaleField();
        createLongueurFunesBrasLabel();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createLongueurFunesField();
        createLongueurBrasField();
        createDistanceChaluteeDureeLabel();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createDistanceChaluteeField();
        createDureeField();
        createLocaliteLabel();
        createLocaliteField();
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout(new GridLayout(1,0));
        createTraitValidCheckBox();
        createTraitRectiligneCheckBox();
        // inline creation of $JPanel5
        $objectMap.put("$JPanel5", $JPanel5 = new JPanel());
        
        $JPanel5.setName("$JPanel5");
        $JPanel5.setLayout(new GridLayout(1,0));
        createSystemeFermetureCulCheckBox();
        createGeometrieMesureeCheckBox();
        createSaisisseurPane();
        createSaisisseurList();
        createSaisisseurHeader();
        createCommentPane();
        createCommentField();
        createGearShootingForm();
        createGearShootingStartLongitudeLabel();
        createGearShootingStartLongitudeField();
        createGearShootingStartLatitudeLabel();
        createGearShootingStartLatitudeField();
        createGearShootingStartTimeLabel();
        createGearShootingStartTimeField();
        createGearShootingStartDepthLabel();
        createGearShootingStartDepthField();
        createGearShootingEndLongitudeLabel();
        createGearShootingEndLongitudeField();
        createGearShootingEndLatitudeLabel();
        createGearShootingEndLatitudeField();
        createGearShootingEndTimeLabel();
        createGearShootingEndTimeField();
        createGearShootingEndDepthLabel();
        createGearShootingEndDepthField();
        createHydrologyForm();
        createGearShootingStartSurfaceTemperatureLabel();
        createGearShootingStartSurfaceTemperatureField();
        createGearShootingEndSurfaceTemperatureLabel();
        createGearShootingEndSurfaceTemperatureField();
        createGearShootingStartBottomTemperatureLabel();
        createGearShootingStartBottomTemperatureField();
        createGearShootingEndBottomTemperatureLabel();
        createGearShootingEndBottomTemperatureField();
        createAverageBottomTemperatureLabel();
        createAverageBottomTemperatureField();
        createGearShootingStartSurfaceSalinityLabel();
        createGearShootingStartSurfaceSalinityField();
        createGearShootingEndSurfaceSalinityLabel();
        createGearShootingEndSurfaceSalinityField();
        createGearShootingStartBottomSalinityLabel();
        createGearShootingStartBottomSalinityField();
        createGearShootingEndBottomSalinityLabel();
        createGearShootingEndBottomSalinityField();
        createAverageBottomSalinityLabel();
        createAverageBottomSalinityField();
        // inline creation of $JPanel6
        $objectMap.put("$JPanel6", $JPanel6 = new JPanel());
        
        $JPanel6.setName("$JPanel6");
        $JPanel6.setLayout(new BorderLayout());
        // inline creation of $JPanel7
        $objectMap.put("$JPanel7", $JPanel7 = new JPanel());
        
        $JPanel7.setName("$JPanel7");
        $JPanel7.setLayout(new GridLayout(1,0));
        createImportPupitriButton();
        // inline creation of $JPanel8
        $objectMap.put("$JPanel8", $JPanel8 = new JPanel());
        
        $JPanel8.setName("$JPanel8");
        $JPanel8.setLayout(new GridLayout(1,0));
        createCancelButton();
        createSaveButton();
        createNoTraitPane();
        createTraitGeneralTab();
        createTraitGearShootingTab();
        createTraitHydrologyTabContent();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 60 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 60 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATION_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("stationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stationNumberField.setModel(model.getStationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("stationNumber", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STATION_NUMBER_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                stationNumberField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAIT_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("traitNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    traitNumberField.setModel(model.getTraitNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("traitNumber", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TRAIT_NUMBER_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                traitNumberField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("date", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dateField.setDate(model.getDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("date", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("strata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    strataComboBox.setSelectedItem(model.getStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("strata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BEAUFORT_SCALE_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("beaufortScale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    beaufortScaleComboBox.setSelectedItem(model.getBeaufortScale());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("beaufortScale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WIND_DIRECTION_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("windDirection", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    windDirectionField.setModel(model.getWindDirection());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("windDirection", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_WIND_DIRECTION_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                windDirectionField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SEA_STATE_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("seaState", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    seaStateComboBox.setSelectedItem(model.getSeaState());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("seaState", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OUVERTURE_HORIZONTALE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ouvertureHorizontale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ouvertureHorizontaleField.setModel(model.getOuvertureHorizontale());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ouvertureHorizontale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OUVERTURE_HORIZONTALE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                ouvertureHorizontaleField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OUVERTURE_VERTICALE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ouvertureVerticale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ouvertureVerticaleField.setModel(model.getOuvertureVerticale());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ouvertureVerticale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OUVERTURE_VERTICALE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                ouvertureVerticaleField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGUEUR_FUNES_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("longueurFunes", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longueurFunesField.setModel(model.getLongueurFunes());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("longueurFunes", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LONGUEUR_FUNES_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                longueurFunesField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGUEUR_BRAS_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("longueurBras", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longueurBrasField.setModel(model.getLongueurBras());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("longueurBras", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LONGUEUR_BRAS_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                longueurBrasField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISTANCE_CHALUTEE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("distanceChalutee", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    distanceChaluteeField.setModel(model.getDistanceChalutee());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("distanceChalutee", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DISTANCE_CHALUTEE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                distanceChaluteeField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DUREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("duree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dureeField.setModel(model.getDuree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("duree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DUREE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                dureeField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LOCALITE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("localite", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(localiteField, model.getLocalite());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("localite", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAIT_VALID_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("traitValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    traitValidCheckBox.setSelected(model.isTraitValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("traitValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAIT_RECTILIGNE_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("traitRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    traitRectiligneCheckBox.setSelected(model.isTraitRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("traitRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SYSTEME_FERMETURE_CUL_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("systemeFermetureCul", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    systemeFermetureCulCheckBox.setSelected(model.isSystemeFermetureCul());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("systemeFermetureCul", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEOMETRIE_MESUREE_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("geometrieMesuree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    geometrieMesureeCheckBox.setSelected(model.isGeometrieMesuree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("geometrieMesuree", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(gearShootingStartLongitudeField, getStringValue(model.getGearShootingStartLongitude()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(gearShootingStartLatitudeField, getStringValue(model.getGearShootingStartLatitude()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_TIME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartTime", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(gearShootingStartTimeField, getStringValue(model.getGearShootingStartTime()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartTime", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_DEPTH_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDepth", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartDepthField.setModel(model.getGearShootingStartDepth());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDepth", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_DEPTH_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartDepthField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(gearShootingEndLongitudeField, getStringValue(model.getGearShootingEndLongitude()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(gearShootingEndLatitudeField, getStringValue(model.getGearShootingEndLatitude()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_TIME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndTime", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(gearShootingEndTimeField, getStringValue(model.getGearShootingEndTime()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndTime", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_DEPTH_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDepth", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndDepthField.setModel(model.getGearShootingEndDepth());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDepth", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_DEPTH_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndDepthField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_SURFACE_TEMPERATURE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartSurfaceTemperature", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartSurfaceTemperatureField.setModel(model.getGearShootingStartSurfaceTemperature());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartSurfaceTemperature", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_SURFACE_TEMPERATURE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartSurfaceTemperatureField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_SURFACE_TEMPERATURE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndSurfaceTemperature", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndSurfaceTemperatureField.setModel(model.getGearShootingEndSurfaceTemperature());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndSurfaceTemperature", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_SURFACE_TEMPERATURE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndSurfaceTemperatureField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_BOTTOM_TEMPERATURE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartBottomTemperature", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartBottomTemperatureField.setModel(model.getGearShootingStartBottomTemperature());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartBottomTemperature", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_BOTTOM_TEMPERATURE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartBottomTemperatureField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_BOTTOM_TEMPERATURE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndBottomTemperature", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndBottomTemperatureField.setModel(model.getGearShootingEndBottomTemperature());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndBottomTemperature", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_BOTTOM_TEMPERATURE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndBottomTemperatureField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AVERAGE_BOTTOM_TEMPERATURE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("averageBottomTemperature", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    averageBottomTemperatureField.setModel(model.getAverageBottomTemperature());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("averageBottomTemperature", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_AVERAGE_BOTTOM_TEMPERATURE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                averageBottomTemperatureField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_SURFACE_SALINITY_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartSurfaceSalinity", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartSurfaceSalinityField.setModel(model.getGearShootingStartSurfaceSalinity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartSurfaceSalinity", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_SURFACE_SALINITY_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartSurfaceSalinityField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_SURFACE_SALINITY_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndSurfaceSalinity", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndSurfaceSalinityField.setModel(model.getGearShootingEndSurfaceSalinity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndSurfaceSalinity", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_SURFACE_SALINITY_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndSurfaceSalinityField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_BOTTOM_SALINITY_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartBottomSalinity", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartBottomSalinityField.setModel(model.getGearShootingStartBottomSalinity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartBottomSalinity", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_BOTTOM_SALINITY_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartBottomSalinityField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_BOTTOM_SALINITY_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndBottomSalinity", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndBottomSalinityField.setModel(model.getGearShootingEndBottomSalinity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndBottomSalinity", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_BOTTOM_SALINITY_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndBottomSalinityField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AVERAGE_BOTTOM_SALINITY_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("averageBottomSalinity", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    averageBottomSalinityField.setModel(model.getAverageBottomSalinity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("averageBottomSalinity", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_AVERAGE_BOTTOM_SALINITY_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                averageBottomSalinityField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cancelButton.setEnabled(model.isModify());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}