package fr.ifremer.tutti.ui.swing.content.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.BeaufortScaleBean;
import fr.ifremer.tutti.persistence.entities.SeaStateBean;
import fr.ifremer.tutti.persistence.entities.StrataBean;
import fr.ifremer.tutti.persistence.entities.TraitBean;
import fr.ifremer.tutti.persistence.entities.UserBean;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class BenthosTabUI extends JPanel implements TuttiUI<BenthosTabUIModel, BenthosTabUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SAMPLE_TOTAL_WEIGHT_FIELD_MODEL = "sampleTotalWeightField.model";
    public static final String BINDING_SAMPLE_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "sampleTotalWeightField.numberPattern";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_MODEL = "totalWeightField.model";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "totalWeightField.numberPattern";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VTW8bRRh+7dpJnKSkTUUIooXQqihRpXUPqJeUkjStqSsnRLELFT6EsXdsTzW7s8zMNhtZRfwEfgLcuSBx44Q4cObABfEXEOLAFfHO7NprOxs5iYiUVTLzPs+8H/M8892fUFQS3n1BosiRoa+ZR52n28+ff9x6Qdv6EVVtyQItJMQ/uTzkm7DgDteVhlvNmoGXE3h5R3iB8Kk/gt6swbzSx5yqHqVaw41xRFupcn24vRkFoRywDpPKYv3m77/yX7tffZsHiALMbhFLWZuGSisp1CDPXA3LeNJLUubE72IakvldzPeyWdvhRKk94tEv4EuYrcFMQCSSabh59pIth8VHgYZST3h0n/iUa7jXkQ7rSOpR6ehQa+aEzFFHeL7TFr5GOqdNdLtHlfMQ/+kJ1SCtZ9UgsHQzGmZ7xHc5lRo+uBjVkxifMhY94ZrUNi/Gt2vQKdsSlVJI3OF0N+a9Pzadl4Qzl2CzEuq6+X4yWNylSpEuTeEpcWmI1HDnHJQpQ6EjpKdhdQwcQ+yBJqw0jL6ihSb8U8q6PV0jLVPJsrkfUQJ5ahdN8GompsIox4v2XsZp1GUm273Qa1H52P4zzrOiiBdw2pjIwOzemBZpzzW7a+ORS9rUWG9Lwbm5jBreGCsn3RnvQ9HiJosfNux2gAJ8a6xIlLaTSjvVXq4JRRniMs6gedINDnAr9oHVCR8whHb335Vrv/34xw+Vgfhn8ezXM0NHvAtFGUgRoGSYOXopVn6oGS/vkmCzCSVFORqfNbbrGYnVk21MDs+7auCOgTtPiOohRXH2959+Xvn810uQr8A8F8StEBNfhZLuSeyC4G4UfLhlM1o8msPvFfwt4I1sUeKjpvtWgq/wkpNQi30RhGgb5X4idadL9Y7wO6y7vuEwtT0IGb0/6xsGjUcdHVBl7LagZYjNXzJLNvohShplDHdPoa1j4ChjHI+8EU7kesZEhm1plX7551r9+63BVHLYpTdPDU8nU/wMZpjPmU+tKSd+m2nCC4GioStSX81yWsCmLY6WkEj/rv2+f2IAeQ1z3OiqYjxluT8p3lemizTCZr4T+6ENdlqx+Tkj4VFoTnhgazd/bUGGfwRT0imkVrwaXwgzoRFl2xlf9m2B+0RrKnGcK/3qXuPw3uGj6kfVRv1wf7vReHywh4FzoaIVvIyYfrFDOF4KmEt0cKxh4RzZ22ZMy/7szbyd1cwTNpaV1Cm2eI7Gvp02tj7J9X+29+oF6zlrqwf13OrHIjadxRcvpOvp0+m0jTZMUQttwUPPT97jjWzMThozQGblHD8H01LMaZjh5FjgpOG1+/gOk7UW8118Oh6cIM2Z7zwy/gcKEcQnmQoAAA==";
    private static final Log log = LogFactory.getLog(BenthosTabUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SwingValidatorMessageTableModel errorTableModel;
    protected Table form;
    protected BenthosTabUIHandler handler;
    protected BenthosTabUI homePanel = this;
    protected BenthosTabUIModel model;
    protected NumberEditor sampleTotalWeightField;
    protected JLabel sampleTotalWeightLabel;
    protected JTable table;
    protected JScrollPane tableScrollPane;
    protected NumberEditor totalWeightField;
    protected JLabel totalWeightLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<BenthosTabUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void selectTrait(TraitBean trait) { handler.selectTrait(trait); }
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BenthosTabUI(CatchesUI parentUI) {
        BenthosTabUIHandler handler = new BenthosTabUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public BenthosTabUI() {
        $initialize();
    }

    public BenthosTabUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosTabUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public BenthosTabUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosTabUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BenthosTabUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosTabUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BenthosTabUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public Table getForm() {
        return form;
    }

    public BenthosTabUIHandler getHandler() {
        return handler;
    }

    public BenthosTabUIModel getModel() {
        return model;
    }

    public NumberEditor getSampleTotalWeightField() {
        return sampleTotalWeightField;
    }

    public JLabel getSampleTotalWeightLabel() {
        return sampleTotalWeightLabel;
    }

    public JTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public NumberEditor getTotalWeightField() {
        return totalWeightField;
    }

    public JLabel getTotalWeightLabel() {
        return totalWeightLabel;
    }

    public SwingValidator<BenthosTabUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(totalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(totalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(sampleTotalWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(sampleTotalWeightField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(BenthosTabUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(BenthosTabUIModel.class));
    }

    protected void createSampleTotalWeightField() {
        $objectMap.put("sampleTotalWeightField", sampleTotalWeightField = new NumberEditor(this));
        
        sampleTotalWeightField.setName("sampleTotalWeightField");
        sampleTotalWeightField.setProperty("sampleTotalWeight");
        sampleTotalWeightField.setUseFloat(false);
        sampleTotalWeightField.setShowReset(true);
    }

    protected void createSampleTotalWeightLabel() {
        $objectMap.put("sampleTotalWeightLabel", sampleTotalWeightLabel = new JLabel());
        
        sampleTotalWeightLabel.setName("sampleTotalWeightLabel");
        sampleTotalWeightLabel.setText(_("tutti.label.benthos.sampleTotalWeight"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JTable());
        
        table.setName("table");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTotalWeightField() {
        $objectMap.put("totalWeightField", totalWeightField = new NumberEditor(this));
        
        totalWeightField.setName("totalWeightField");
        totalWeightField.setProperty("totalWeight");
        totalWeightField.setUseFloat(false);
        totalWeightField.setShowReset(true);
    }

    protected void createTotalWeightLabel() {
        $objectMap.put("totalWeightLabel", totalWeightLabel = new JLabel());
        
        totalWeightLabel.setName("totalWeightLabel");
        totalWeightLabel.setText(_("tutti.label.benthos.totalWeight"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(BenthosTabUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToForm();
        addChildrenToTableScrollPane();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 11 property setters
        totalWeightLabel.setLabelFor(totalWeightField);
        totalWeightField.setBean(model);
        totalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        totalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        sampleTotalWeightLabel.setLabelFor(totalWeightField);
        sampleTotalWeightField.setBean(model);
        sampleTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        sampleTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        table.setModel(getContextValue(TableModel.class));
        table.setColumnModel(getContextValue(TableColumnModel.class));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createForm();
        createTotalWeightLabel();
        createTotalWeightField();
        createSampleTotalWeightLabel();
        createSampleTotalWeightField();
        createTableScrollPane();
        createTable();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightField.setModel(model.getTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                totalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sampleTotalWeightField.setModel(model.getSampleTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleTotalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAMPLE_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                sampleTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
    }

}