package fr.ifremer.tutti.ui.swing.launcher;

/*
 * #%L
 * Tutti :: Launcher
 * %%
 * Copyright (C) 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

/**
 * Created on 1/3/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 1.0
 */
public enum ExitCode {

    NORMAL(0, false), // Normal exist code, always quit program
    UPDATE(88, true), // When an update was found, will relaunch application
    DELETE_DB(89, true), // When a db deletion is required, will relaunch application
    RUNTIME_UPDATE(90, false), // When a runtime update found, quit program to update runtime
    UNKNOWN(-1, false); // For any other exit code, will always quit program

    private final int exitCode;

    private final boolean relaunch;

    ExitCode(int exitCode, boolean relaunch) {
        this.exitCode = exitCode;
        this.relaunch = relaunch;
    }

    public int getExitCode() {
        return exitCode;
    }

    public boolean isRelaunch() {
        return relaunch;
    }

    public static ExitCode valueOf(int code) {

        ExitCode result = UNKNOWN;

        for (ExitCode exitCode : ExitCode.values()) {
            if (code == exitCode.getExitCode()) {
                result = exitCode;
            }
        }

        return result;

    }
    
}
