/*
 * *##% 
 * SuiviObsmer :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.entity.SampleRow;
import fr.ifremer.suiviobsmer.entity.SampleRowLog;
import fr.ifremer.suiviobsmer.services.ServiceSampling;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

/**
 * SampleRowHistoric
 *
 * Created: 12 janv. 2010
 *
 * @author fdesbois
 * @version $Revision: 330 $
 *
 * Mise a jour: $Date: 2010-02-05 15:04:29 +0100 (ven. 05 févr. 2010) $
 * par : $Author$
 */
@IncludeStylesheet("context:css/sampling.css")
public class SampleRowHistoric implements SuiviObsmerPage {

    @Override
    public boolean isOnlyForAdmin() {
        return true;
    }

    @Inject
    private Logger log;

    @Inject
    private ServiceSampling serviceSampling;
    
    private String sampleRowId;
    
    @Persist
    private SampleRow sampleRow;

    @Property
    private SampleRowLog sampleRowLog;

    void onActivate(String id) {
        sampleRowId = id;
    }

    String onPassivate() {
        return sampleRowId;
    }

    void setupRender() throws SuiviObsmerException {
        sampleRow = null;
        getSampleRow();
    }

    public SampleRow getSampleRow() throws SuiviObsmerException {
        if (sampleRow == null) {
            if (log.isInfoEnabled()) {
                log.info("BUSINESS REQUEST [getSampleRow]");
            }
            sampleRow = serviceSampling.getSampleRow(sampleRowId);
        }
        return sampleRow;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.FRENCH);
    }

    public String getContent() {
        String content = sampleRowLog.getLogText();
        if (content == null) {
            content = "Aucun changement enregistré.";
        } else {
            content = content.replaceAll("\\n", "<br />");
        }
        return content;
    }
        
}
