/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerBusinessException;
import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.entity.Boat;
import fr.ifremer.suiviobsmer.entity.Company;
import fr.ifremer.suiviobsmer.entity.FishingZone;
import fr.ifremer.suiviobsmer.entity.Profession;
import fr.ifremer.suiviobsmer.entity.ProfessionImpl;
import fr.ifremer.suiviobsmer.entity.SampleMonth;
import fr.ifremer.suiviobsmer.entity.SampleRow;
import fr.ifremer.suiviobsmer.entity.SampleRowLog;
import fr.ifremer.suiviobsmer.entity.SampleRowLogImpl;
import fr.ifremer.suiviobsmer.entity.User;
import fr.ifremer.suiviobsmer.services.ServiceBoat;
import fr.ifremer.suiviobsmer.services.ServiceReferential;
import fr.ifremer.suiviobsmer.services.ServiceSampling;
import fr.ifremer.suiviobsmer.services.ServiceUser;
import fr.ifremer.suiviobsmer.ui.base.GenericSelectModel;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import fr.ifremer.suiviobsmer.ui.pages.SamplingPlan;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.BeanModelSource;
import org.nuiton.util.PeriodDates;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/sampling.css"})
public class SampleRowForm
implements SuiviObsmerPage {
    @Inject
    private Logger log;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private ServiceBoat serviceBoat;
    @SessionState
    @Property
    private User user;
    @Inject
    private PropertyAccess propertyAccess;
    private boolean edited;
    @Persist
    private GenericSelectModel<Profession> professionSelectModel;
    @Property
    private String professionId;
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private ComponentResources resources;
    @Persist
    private GenericSelectModel<FishingZone> fishingZoneSelectModel;
    @Property
    private String fishingZoneId;
    @Property
    private FishingZone fishingZone;
    @Property
    private int indexFishingZone;
    @InjectComponent
    private Field fishingZoneSelect;
    @Persist
    private SelectModel programSelectModel;
    @Property
    private String programName;
    @Property
    private String programId;
    private PeriodDates period;
    @Persist
    private List<SampleMonth> sampleMonths;
    @Property
    private int monthIndex;
    @Property
    private SampleMonth sampleMonth;
    @InjectComponent
    private Field programPeriodBegin;
    @InjectComponent
    private Field programPeriodEnd;
    @InjectComponent
    private Field program;
    private boolean periodChanged;
    private String sampleRowId;
    @Persist
    private SampleRow sampleRow;
    private BeanModel<SampleRow> sampleRowModel;
    @InjectComponent
    private Form sampleRowForm;
    @InjectComponent
    private Field updateComment;
    @Persist
    private SampleRowLog sampleRowLog;
    @Property
    private String immatriculations;
    @Property
    private String companyId;
    private List<Boat> boats;
    private GenericSelectModel<Company> companySelectModel;
    private boolean cancel;

    public boolean isOnlyForAdmin() {
        return true;
    }

    void onActivate(EventContext ec) {
        if (ec.getCount() > 0) {
            this.sampleRowId = (String)ec.get(String.class, 0);
        }
    }

    String onPassivate() {
        return this.sampleRowId;
    }

    void setupRender() throws SuiviObsmerException {
        this.sampleRow = null;
        this.getSampleRow();
        this.sampleMonths = null;
        this.getSampleMonths();
        this.sampleRowLog = null;
        this.getSampleRowLog();
        this.professionSelectModel = null;
        this.getProfessionSelectModel();
        this.programSelectModel = null;
        this.getProgramSelectModel();
        this.fishingZoneSelectModel = null;
        this.getFishingZoneSelectModel();
        this.companySelectModel = null;
        this.getCompanySelectModel();
        this.professionId = null;
        this.sampleRowForm.clearErrors();
        this.programId = !this.isCreateMode() ? this.getSampleRow().getProgramName() : null;
        Company company = this.getSampleRow().getCompany();
        if (company != null) {
            this.companyId = company.getTopiaId();
        }
        this.immatriculations = this.getSampleRow().getMainElligibleBoatsAsString();
    }

    public GenericSelectModel<Profession> getProfessionSelectModel() throws SuiviObsmerException {
        if (this.professionSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getProfessions]");
            }
            List professions = this.serviceReferential.getProfessions();
            this.professionSelectModel = new GenericSelectModel(professions, Profession.class, "code", "topiaId", this.propertyAccess);
        }
        return this.professionSelectModel;
    }

    public BeanModel<Profession> getProfessionModel() {
        return this.beanModelSource.createDisplayModel(Profession.class, this.resources.getMessages());
    }

    void onSelectedFromAddNewProfession() throws SuiviObsmerException {
        ProfessionImpl profession = new ProfessionImpl();
        if (!StringUtils.isEmpty((String)this.professionId)) {
            Profession professionSelected = (Profession)this.getProfessionSelectModel().findObject(this.professionId);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Add new profession from : " + professionSelected);
            }
            profession = this.serviceSampling.getNewProfession(professionSelected);
        }
        this.getSampleRow().setProfession((Profession)profession);
        this.edited = true;
    }

    public GenericSelectModel<FishingZone> getFishingZoneSelectModel() throws SuiviObsmerException {
        if (this.fishingZoneSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getFishingZones]");
            }
            List zones = this.serviceReferential.getFishingZones();
            this.fishingZoneSelectModel = new GenericSelectModel(zones, FishingZone.class, "code", "topiaId", this.propertyAccess);
        }
        return this.fishingZoneSelectModel;
    }

    public List<FishingZone> getFishingZones() throws SuiviObsmerException {
        return this.getSampleRow().getFishingZone();
    }

    void onSelectedFromAddFishingZone() throws SuiviObsmerException {
        this.fishingZone = (FishingZone)this.getFishingZoneSelectModel().findObject(this.fishingZoneId);
        if (!this.getFishingZones().contains(this.fishingZone)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Add new fishingZone");
            }
            this.getFishingZones().add(this.fishingZone);
        }
        this.edited = true;
    }

    void onSelectedFromRemoveFishingZone(int index) throws SuiviObsmerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remove fishingZone at position : " + index);
        }
        this.getFishingZones().remove(index);
        this.edited = true;
    }

    public SelectModel getProgramSelectModel() throws SuiviObsmerException {
        if (this.programSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getPrograms]");
            }
            ArrayList<OptionModelImpl> options = new ArrayList<OptionModelImpl>();
            for (String name : this.serviceSampling.getPrograms()) {
                options.add(new OptionModelImpl(name, (Object)name));
            }
            this.programSelectModel = new SelectModelImpl(null, options);
        }
        return this.programSelectModel;
    }

    public PeriodDates getPeriod() throws SuiviObsmerException {
        if (this.period == null) {
            Date begin = this.getSampleRow().getPeriodBegin();
            Date end = this.getSampleRow().getPeriodEnd();
            this.period = new PeriodDates(begin, end);
        }
        return this.period;
    }

    public List<SampleMonth> getSampleMonths() throws SuiviObsmerException {
        if (this.sampleMonths == null) {
            this.sampleMonths = new ArrayList();
            for (Date currMonth : this.getPeriod().getMonths()) {
                SampleMonth curr = this.getSampleRow().getSampleMonth(currMonth);
                if (curr != null) {
                    this.sampleMonths.add(curr);
                    continue;
                }
                if (!this.periodChanged) continue;
                if (curr == null) {
                    curr = this.serviceSampling.getNewSampleMonth(currMonth, this.getSampleRow());
                }
                this.sampleMonths.add(curr);
            }
        }
        return this.sampleMonths;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("MM/yyyy");
    }

    @Log
    void onSelectedFromRefreshMonths() throws SuiviObsmerException {
        this.getSampleRow().setPeriod(this.period);
        this.periodChanged = true;
        this.sampleMonths = null;
        this.getSampleMonths();
        this.saveProgram();
    }

    protected void saveProgram() throws SuiviObsmerException {
        if (StringUtils.isNotEmpty((String)this.programName)) {
            this.getSampleRow().setProgramName(this.programName);
            this.programId = null;
        } else if (StringUtils.isNotEmpty((String)this.programId)) {
            this.getSampleRow().setProgramName(this.programId);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Program : " + this.getSampleRow().getProgramName());
        }
    }

    @Log
    void onSelectedFromDeleteMonth(int index) throws SuiviObsmerException {
        this.getSampleMonths().remove(index);
        this.edited = true;
    }

    public SampleRow getSampleRow() throws SuiviObsmerException {
        if (this.sampleRow == null) {
            if (!StringUtils.isEmpty((String)this.sampleRowId)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("BUSINESS REQUEST [getSampleRow]");
                }
                this.sampleRow = this.serviceSampling.getSampleRow(this.sampleRowId);
            } else {
                this.sampleRow = this.serviceSampling.getNewSampleRow();
            }
        }
        return this.sampleRow;
    }

    public SampleRowLog getSampleRowLog() throws SuiviObsmerException {
        if (this.sampleRowLog == null) {
            this.sampleRowLog = new SampleRowLogImpl();
            this.sampleRowLog.setSampleRow(this.getSampleRow());
            this.sampleRowLog.setUser(this.user);
        }
        return this.sampleRowLog;
    }

    public BeanModel<SampleRow> getSampleRowModel() {
        if (this.sampleRowModel == null) {
            this.sampleRowModel = this.beanModelSource.createEditModel(SampleRow.class, this.resources.getMessages());
            this.sampleRowModel.add("company", null);
            this.sampleRowModel.add("boats", null);
            this.sampleRowModel.include(new String[]{"code", "company", "nbObservants", "averageTideTime", "boats", "comment"});
        }
        return this.sampleRowModel;
    }

    public GenericSelectModel<Company> getCompanySelectModel() throws SuiviObsmerException {
        if (this.companySelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getCompanies]");
            }
            List companies = this.serviceUser.getCompanies(true);
            this.companySelectModel = new GenericSelectModel(companies, Company.class, "name", "topiaId", this.propertyAccess);
        }
        return this.companySelectModel;
    }

    public boolean isCreateMode() throws SuiviObsmerException {
        return StringUtils.isEmpty((String)this.getSampleRow().getTopiaId());
    }

    void onSelectedFromCancelSave() {
        this.cancel = true;
    }

    void onSelectedFromSaveData() throws SuiviObsmerException {
        this.saveProgram();
    }

    @Log
    void onValidateFormFromSampleRowForm() throws SuiviObsmerException {
        this.sampleRowForm.clearErrors();
        try {
            if (!this.cancel && !this.edited) {
                if (StringUtils.isEmpty((String)this.getSampleRow().getProgramName())) {
                    this.sampleRowForm.recordError(this.program, "Vous devez choisir un programme existant ou en cr\u00e9er un nouveau");
                }
                Date periodBegin = this.getSampleRow().getPeriodBegin();
                Date periodEnd = this.getSampleRow().getPeriodEnd();
                if (periodBegin == null) {
                    this.sampleRowForm.recordError(this.programPeriodBegin, "Vous ne pouvez pas rafra\u00eechir les mois avec une date de d\u00e9but de programme vide");
                }
                if (periodEnd == null) {
                    this.sampleRowForm.recordError(this.programPeriodEnd, "Vous ne pouvez pas rafra\u00eechir les mois avec une date de fin de programme vide");
                }
                if (periodBegin != null && periodEnd != null) {
                    Date firstDate;
                    int size = this.getSampleMonths().size();
                    SampleMonth firstMonth = (SampleMonth)this.getSampleMonths().get(0);
                    SampleMonth lastMonth = (SampleMonth)this.getSampleMonths().get(size - 1);
                    if (firstMonth != null && periodBegin.after(firstDate = firstMonth.getPeriodDate()) && firstMonth.getRealTidesValue() != 0) {
                        this.sampleRowForm.recordError(this.programPeriodBegin, "Vous ne pouvez pas r\u00e9duire la p\u00e9riode du programme. Il existe des enregistrements de mar\u00e9es r\u00e9els.");
                    }
                    for (SampleMonth month : this.getSampleMonths()) {
                        if (month.getExpectedTidesValue() >= month.getRealTidesValue()) continue;
                        this.sampleRowForm.recordError("Il n'est pas possible de mettre moins de mar\u00e9es (" + month.getExpectedTidesValue() + ") " + "pour le mois " + this.getDateFormat().format(month.getPeriodDate()) + " qu'il y en a de r\u00e9els (" + month.getRealTidesValue() + ")");
                    }
                }
                if (!this.periodChanged) {
                    int nbZones;
                    Profession profession;
                    if (!this.isCreateMode() && StringUtils.isEmpty((String)this.sampleRowLog.getComment())) {
                        this.sampleRowForm.recordError(this.updateComment, "Un commentaire est obligatoire lors d'une modification de la ligne");
                    }
                    if (StringUtils.isEmpty((String)(profession = this.getSampleRow().getProfession()).getCodeDCF5())) {
                        this.sampleRowForm.recordError("Le m\u00e9tier doit obligatoirement avoir un Code DCF niveau 5");
                    }
                    if ((nbZones = this.getSampleRow().sizeFishingZone()) == 0) {
                        this.sampleRowForm.recordError(this.fishingZoneSelect, "Vous devez ajouter au moins une zone de p\u00eache \u00e0 la ligne");
                    }
                    this.boats = this.serviceBoat.getBoatsByImmatriculations(this.immatriculations);
                } else if (this.isCreateMode()) {
                    String rowCode = this.serviceSampling.getNewSampleRowCode(periodBegin);
                    this.getSampleRow().setCode(rowCode);
                }
            }
        }
        catch (SuiviObsmerBusinessException eee) {
            this.sampleRowForm.recordError(eee.getMessage());
            this.log.error("BUSINESS ERROR : " + eee.getType() + " depuis " + eee.getServiceName() + " : " + eee.getMessage());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("SampleMonths : " + this.getSampleMonths());
        }
    }

    @Log
    Object onSuccessFromSampleRowForm() throws SuiviObsmerException {
        if (this.cancel) {
            return this;
        }
        if (!this.edited && !this.periodChanged) {
            if (!this.getSampleRow().hasSampleMonthRealTideTime()) {
                Company company = (Company)this.getCompanySelectModel().findObject(this.companyId);
                this.getSampleRow().setCompany(company);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("SampleMonths : " + this.getSampleMonths());
            }
            this.getSampleRow().setSampleMonth(this.getSampleMonths());
            this.serviceSampling.createUpdateSampleRow(this.sampleRow, this.boats, this.getSampleRowLog());
            return SamplingPlan.class;
        }
        this.professionId = null;
        return this.sampleRowForm;
    }

    @Log
    Object onFailureFromSampleRowForm() {
        return this.sampleRowForm;
    }
}

