/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importDb;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.io.EchoBaseIOUtil;
import fr.ifremer.echobase.io.InputFile;
import fr.ifremer.echobase.services.service.importdb.ImportDbConfiguration;
import fr.ifremer.echobase.services.service.importdb.ImportDbMode;
import fr.ifremer.echobase.ui.actions.AbstractConfigureAction;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public class Configure
extends AbstractConfigureAction<ImportDbConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Configure.class);
    protected Map<String, String> modes;

    public Map<String, String> getModes() {
        return this.modes;
    }

    public Configure() {
        super(ImportDbConfiguration.class);
    }

    protected ImportDbConfiguration createModel() {
        return new ImportDbConfiguration(this.getLocale());
    }

    protected void prepareInputAction(ImportDbConfiguration model) {
        this.modes = this.decoratorService.decorateEnums((Enum[])ImportDbMode.values());
        if (model.getImportDbMode() == null) {
            model.setImportDbMode(ImportDbMode.REFERENTIAL);
        }
    }

    protected void prepareExecuteAction(ImportDbConfiguration model) throws IOException {
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-importDb-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary((File)dataDirectory);
        model.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Temporary directory to use : " + dataDirectory));
        }
        InputFile input = model.getInput();
        EchoBaseIOUtil.copyFile((InputFile)input, (File)dataDirectory);
    }

    @InputConfig(methodName="input")
    public String configure() throws Exception {
        return this.execute();
    }

    public void setInputFileName(String fileName) {
        ((ImportDbConfiguration)this.getModel()).getInput().setFileName(fileName);
    }

    public void setInput(File file) {
        ((ImportDbConfiguration)this.getModel()).getInput().setFile(file);
    }

    public void setInputContentType(String contentType) {
        ((ImportDbConfiguration)this.getModel()).getInput().setContentType(contentType);
    }
}

