package fr.ifremer.echobase.ui.actions.workingDb;

/*
 * #%L
 * EchoBase :: UI
 * $Id: Disconnect.java 591 2012-09-02 16:38:43Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.5.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/workingDb/Disconnect.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.entities.WorkingDbConfiguration;
import fr.ifremer.echobase.persistence.JdbcConfiguration;

/**
 * Disconnects from a {@link WorkingDbConfiguration}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.1
 */
public class Disconnect extends AbstractWorkingDbAction {

    private static final long serialVersionUID = 1L;

    @Override
    public String execute() throws Exception {
        JdbcConfiguration sessionConf =
                getEchoBaseSession().getWorkingDbConfiguration();
        getEchoBaseSession().releaseWorkingDb();
        addFlashMessage(_("echobase.info.workingDbconfiguration.disconnected",
                          sessionConf.getUrl()));
        return SUCCESS;
    }
}
